/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.games;

import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Random;
import scala.util.control.Breaks$;
import textworldexpress.data.LoadCookingWorldDataJSON;
import textworldexpress.data.LoadCookingWorldDataJSON$;
import textworldexpress.data.LoadTWCDataJSON;
import textworldexpress.data.LoadTWCDataJSON$;
import textworldexpress.data.MathProblemGenerator$;
import textworldexpress.games.ArithmeticGame;
import textworldexpress.games.ArithmeticGame$;
import textworldexpress.goldagent.ArithmeticGoldAgent;
import textworldexpress.objects.Backyard;
import textworldexpress.objects.Bathroom;
import textworldexpress.objects.Bedroom;
import textworldexpress.objects.Box;
import textworldexpress.objects.BundleOfObjects;
import textworldexpress.objects.Corridor;
import textworldexpress.objects.DoorMaker;
import textworldexpress.objects.Driveway;
import textworldexpress.objects.FastObject;
import textworldexpress.objects.Kitchen;
import textworldexpress.objects.Kitchen$;
import textworldexpress.objects.LaundryRoom;
import textworldexpress.objects.LivingRoom;
import textworldexpress.objects.MathProblem;
import textworldexpress.objects.Pantry;
import textworldexpress.objects.Room;
import textworldexpress.objects.Street;
import textworldexpress.objects.Supermarket;
import textworldexpress.preprocessing.ArithmeticProblem;

public class ArithmeticGameGenerator {
    private final LoadTWCDataJSON TWCObjectDatabase = new LoadTWCDataJSON(LoadTWCDataJSON$.MODULE$.$lessinit$greater$default$1());
    private final LoadCookingWorldDataJSON CookingWorldObjectDatabase = new LoadCookingWorldDataJSON(LoadCookingWorldDataJSON$.MODULE$.$lessinit$greater$default$1());
    private final DoorMaker doorMaker = new DoorMaker();

    public Tuple5<ArrayBuffer<Room>, ArithmeticProblem, MathProblem, Box, FastObject> mkEnvironment(Random r, int seed, String fold) {
        ArrayBuffer<Room> locations = new ArrayBuffer<Room>();
        int randLocationIdx = r.nextInt(11);
        Object object = randLocationIdx == 0 ? locations.append(new Kitchen(r, false, Kitchen$.MODULE$.$lessinit$greater$default$3())) : BoxedUnit.UNIT;
        Object object2 = randLocationIdx == 1 ? locations.append(new Pantry(r)) : BoxedUnit.UNIT;
        Object object3 = randLocationIdx == 2 ? locations.append(new Corridor(r)) : BoxedUnit.UNIT;
        Object object4 = randLocationIdx == 3 ? locations.append(new Bedroom(r)) : BoxedUnit.UNIT;
        Object object5 = randLocationIdx == 4 ? locations.append(new Backyard(r)) : BoxedUnit.UNIT;
        Object object6 = randLocationIdx == 5 ? locations.append(new LivingRoom(r)) : BoxedUnit.UNIT;
        Object object7 = randLocationIdx == 6 ? locations.append(new Bathroom(r)) : BoxedUnit.UNIT;
        Object object8 = randLocationIdx == 7 ? locations.append(new LaundryRoom(r)) : BoxedUnit.UNIT;
        Object object9 = randLocationIdx == 8 ? locations.append(new Driveway(r)) : BoxedUnit.UNIT;
        Object object10 = randLocationIdx == 9 ? locations.append(new Street(r)) : BoxedUnit.UNIT;
        Object object11 = randLocationIdx == 10 ? locations.append(new Supermarket(r)) : BoxedUnit.UNIT;
        Tuple2<MathProblem, ArithmeticProblem> tuple2 = this.mkArithmeticProblem(seed, fold);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MathProblem mathProblemObj = tuple2._1();
        ArithmeticProblem arithmeticProblem = tuple2._2();
        Tuple2<MathProblem, ArithmeticProblem> tuple22 = new Tuple2<MathProblem, ArithmeticProblem>(mathProblemObj, arithmeticProblem);
        Tuple2<MathProblem, ArithmeticProblem> tuple23 = tuple22;
        MathProblem mathProblemObj2 = tuple23._1();
        ArithmeticProblem arithmeticProblem2 = tuple23._2();
        ((FastObject)locations.apply(0)).addObject(mathProblemObj2);
        Box answerBox = new Box();
        ((FastObject)locations.apply(0)).addObject(answerBox);
        Tuple2<FastObject, FastObject[]> tuple24 = this.mkCorrectAndDistractorObjects(r, arithmeticProblem2, fold);
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        FastObject correctObject = tuple24._1();
        FastObject[] distractorObjects = tuple24._2();
        Tuple2<FastObject, FastObject[]> tuple25 = new Tuple2<FastObject, FastObject[]>(correctObject, distractorObjects);
        Tuple2<FastObject, FastObject[]> tuple26 = tuple25;
        FastObject correctObject2 = tuple26._1();
        FastObject[] distractorObjects2 = tuple26._2();
        FastObject[] objectsToPlace = (FastObject[])((IterableOnceOps)r.shuffle(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(new FastObject[]{correctObject2}), distractorObjects2, ClassTag$.MODULE$.apply(FastObject.class))).toList(), BuildFrom$.MODULE$.buildFromIterableOps())).toArray(ClassTag$.MODULE$.apply(FastObject.class));
        Room qual$1 = (Room)locations.apply(0);
        ListBuffer<FastObject> x$1 = qual$1.collectVisibleObjects$default$1();
        ListBuffer<FastObject> visibleObjects = qual$1.collectVisibleObjects(x$1);
        ArrayBuffer validContainers = new ArrayBuffer();
        visibleObjects.foreach((Function1<FastObject, Object> & Serializable)obj -> {
            Object object;
            if (obj.isContainer() && obj.isOpen()) {
                String string = obj.name();
                String string2 = answerBox.name();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    object = validContainers.append(obj);
                    return object;
                }
            }
            object = BoxedUnit.UNIT;
            return object;
        });
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(objectsToPlace), (Function1<FastObject, Object> & Serializable)obj -> {
            ArithmeticGameGenerator.$anonfun$mkEnvironment$2(validContainers, r, locations, obj);
            return BoxedUnit.UNIT;
        });
        return new Tuple5<ArrayBuffer<Room>, ArithmeticProblem, MathProblem, Box, FastObject>(locations, arithmeticProblem2, mathProblemObj2, answerBox, correctObject2);
    }

    public Tuple2<MathProblem, ArithmeticProblem> mkArithmeticProblem(int seed, String gameFold) {
        Option<ArithmeticProblem> arithmeticProblem = MathProblemGenerator$.MODULE$.getProblem(seed, gameFold);
        if (arithmeticProblem.isEmpty()) {
            throw new RuntimeException("ERROR: Unable to generate arithmetic problem.");
        }
        MathProblem mathproblem = new MathProblem();
        mathproblem.readText_$eq(new StringBuilder(54).append("Your task is to solve the following math problem: ").append(arithmeticProblem.get().generateText()).append(" . \n").toString());
        mathproblem.readText_$eq(new StringBuilder(86).append(mathproblem.readText()).append("Then, pick up the item with the same quantity as the answer, and place it in the box. ").toString());
        return new Tuple2<MathProblem, ArithmeticProblem>(mathproblem, arithmeticProblem.get());
    }

    public Tuple2<FastObject, FastObject[]> mkCorrectAndDistractorObjects(Random r, ArithmeticProblem arithmeticProblem, String gameFold) {
        Tuple2[] tuple2Array;
        Tuple2[] objectNamesTrain = (Tuple2[])((Object[])new Tuple2[]{new Tuple2<String, String>("apple", "apples"), new Tuple2<String, String>("orange", "oranges"), new Tuple2<String, String>("grape", "grapes"), new Tuple2<String, String>("tangerine", "tangerines"), new Tuple2<String, String>("banana", "bananas"), new Tuple2<String, String>("pineapple", "pineapples"), new Tuple2<String, String>("papaya", "papayas"), new Tuple2<String, String>("peach", "peaches"), new Tuple2<String, String>("strawberry", "strawberries"), new Tuple2<String, String>("grapefruit", "grapefruits")});
        Tuple2[] objectNamesDev = (Tuple2[])((Object[])new Tuple2[]{new Tuple2<String, String>("broccoli", "brocollis"), new Tuple2<String, String>("onion", "onions"), new Tuple2<String, String>("cucumber", "cucumbers"), new Tuple2<String, String>("potato", "potatoes"), new Tuple2<String, String>("cucumber", "cucumbers"), new Tuple2<String, String>("coconut", "coconuts"), new Tuple2<String, String>("watermelon", "watermelons"), new Tuple2<String, String>("mango", "mangos"), new Tuple2<String, String>("olive", "olives"), new Tuple2<String, String>("lime", "limes"), new Tuple2<String, String>("pear", "pears")});
        Tuple2[] objectNamesTest = (Tuple2[])((Object[])new Tuple2[]{new Tuple2<String, String>("pepper", "peppers"), new Tuple2<String, String>("tomato", "tomatoes"), new Tuple2<String, String>("eggplant", "eggplants"), new Tuple2<String, String>("squash", "squashes"), new Tuple2<String, String>("pumpkin", "pumpkins"), new Tuple2<String, String>("pea", "peas"), new Tuple2<String, String>("avocado", "avocados"), new Tuple2<String, String>("cabbage", "cabbages"), new Tuple2<String, String>("prune", "prunes"), new Tuple2<String, String>("blueberry", "blueberries")});
        String string = gameFold;
        String string2 = "train";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            tuple2Array = objectNamesTrain;
        } else {
            String string3 = gameFold;
            String string4 = "dev";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                tuple2Array = objectNamesDev;
            } else {
                String string5 = gameFold;
                String string6 = "test";
                tuple2Array = !(string5 != null ? !string5.equals(string6) : string6 != null) ? objectNamesTest : (Tuple2[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class));
            }
        }
        Tuple2[] objectNames = tuple2Array;
        Tuple2[] shuffled = (Tuple2[])((IterableOnceOps)r.shuffle(Predef$.MODULE$.wrapRefArray((Object[])objectNames).toList(), BuildFrom$.MODULE$.buildFromIterableOps())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        Tuple2 trueObjectName = shuffled[0];
        Tuple2[] distractorObjectNames = (Tuple2[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.refArrayOps(shuffled), 1, shuffled.length);
        BundleOfObjects trueObject = this.mkBundledObject(trueObjectName, BoxesRunTime.unboxToInt(arithmeticProblem.generateResult().get()));
        ArrayBuffer distractorObjects = new ArrayBuffer();
        int[] distractorQuantities = arithmeticProblem.generateDistractors();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), distractorQuantities.length).foreach((Function1<Object, ArrayBuffer> & Serializable)i -> ArithmeticGameGenerator.$anonfun$mkCorrectAndDistractorObjects$1(this, distractorObjects, distractorObjectNames, distractorQuantities, BoxesRunTime.unboxToInt(i)));
        return new Tuple2<BundleOfObjects, Object>(trueObject, distractorObjects.toArray(ClassTag$.MODULE$.apply(FastObject.class)));
    }

    public BundleOfObjects mkBundledObject(Tuple2<String, String> names, int quantity) {
        String nameStr = quantity == 1 ? names._1() : names._2();
        String fullNameStr = new StringBuilder(1).append(Integer.toString(quantity)).append(" ").append(nameStr).toString();
        BundleOfObjects obj = new BundleOfObjects(fullNameStr);
        return obj;
    }

    public ArithmeticGame mkGame(long seed, String fold) {
        Integer n;
        Integer n2;
        Map props = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        props.update("seed", BoxesRunTime.boxToInteger((int)seed));
        String string = fold;
        String string2 = "train";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            n2 = BoxesRunTime.boxToInteger(1);
        } else {
            String string3 = fold;
            String string4 = "dev";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                n2 = BoxesRunTime.boxToInteger(2);
            } else {
                String string5 = fold;
                String string6 = "test";
                n2 = !(string5 != null ? !string5.equals(string6) : string6 != null) ? BoxesRunTime.boxToInteger(3) : BoxesRunTime.boxToInteger(-1);
            }
        }
        props.update("gameSet", n2);
        Random r = new Random(seed);
        Tuple5<ArrayBuffer<Room>, ArithmeticProblem, MathProblem, Box, FastObject> tuple5 = this.mkEnvironment(r, (int)seed, fold);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        ArrayBuffer<Room> locations = tuple5._1();
        ArithmeticProblem arithmeticProblem = tuple5._2();
        MathProblem mathProblemObj = tuple5._3();
        Box answerBox = tuple5._4();
        FastObject correctObject = tuple5._5();
        Tuple5<ArrayBuffer<Room>, ArithmeticProblem, MathProblem, Box, FastObject> tuple52 = new Tuple5<ArrayBuffer<Room>, ArithmeticProblem, MathProblem, Box, FastObject>(locations, arithmeticProblem, mathProblemObj, answerBox, correctObject);
        Tuple5<ArrayBuffer<Room>, ArithmeticProblem, MathProblem, Box, FastObject> tuple53 = tuple52;
        ArrayBuffer<Room> locations2 = tuple53._1();
        ArithmeticProblem arithmeticProblem2 = tuple53._2();
        MathProblem mathProblemObj2 = tuple53._3();
        Box answerBox2 = tuple53._4();
        FastObject correctObject2 = tuple53._5();
        props.update("hidden_num1", BoxesRunTime.boxToInteger(arithmeticProblem2.num1()));
        props.update("hidden_num2", BoxesRunTime.boxToInteger(arithmeticProblem2.num2()));
        String string7 = arithmeticProblem2.operation();
        String string8 = "+";
        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
            n = BoxesRunTime.boxToInteger(0);
        } else {
            String string9 = arithmeticProblem2.operation();
            String string10 = "-";
            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                n = BoxesRunTime.boxToInteger(1);
            } else {
                String string11 = arithmeticProblem2.operation();
                String string12 = "*";
                if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                    n = BoxesRunTime.boxToInteger(2);
                } else {
                    String string13 = arithmeticProblem2.operation();
                    String string14 = "/";
                    n = !(string13 != null ? !string13.equals(string14) : string14 != null) ? BoxesRunTime.boxToInteger(3) : BoxesRunTime.boxToInteger(-1);
                }
            }
        }
        props.update("hidden_op", n);
        Room[] x$1 = (Room[])locations2.toArray(ClassTag$.MODULE$.apply(Room.class));
        MathProblem x$2 = mathProblemObj2;
        Box x$3 = answerBox2;
        FastObject x$4 = correctObject2;
        scala.collection.immutable.Map<String, Object> x$5 = props.toMap($less$colon$less$.MODULE$.refl());
        long x$6 = ArithmeticGame$.MODULE$.$lessinit$greater$default$5();
        ArithmeticGame game = new ArithmeticGame(x$1, x$2, x$3, x$4, x$6, x$5);
        return game;
    }

    public Tuple2<ArithmeticGame, String[]> mkGameWithGoldPath(long seed, String fold) {
        int MAX_ATTEMPTS = 50;
        Random rg = new Random();
        IntRef attempts = IntRef.create(0);
        ObjectRef<String[]> goldPath = ObjectRef.create((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        Breaks$.MODULE$.breakable(() -> {
            while (attempts$2.elem < MAX_ATTEMPTS) {
                ArithmeticGame game = this.mkGame(seed, fold);
                ArithmeticGoldAgent goldAgent = new ArithmeticGoldAgent(game);
                Tuple2<Object, String[]> tuple2 = goldAgent.mkGoldPath(rg);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                boolean success = tuple2._1$mcZ$sp();
                String[] _goldPath = tuple2._2();
                Tuple2<Boolean, String[]> tuple22 = new Tuple2<Boolean, String[]>(BoxesRunTime.boxToBoolean(success), _goldPath);
                Tuple2<Boolean, String[]> tuple23 = tuple22;
                boolean success2 = tuple23._1$mcZ$sp();
                String[] _goldPath2 = tuple23._2();
                if (success2) {
                    goldPath$1.elem = _goldPath2;
                }
                if (success2) {
                    throw Breaks$.MODULE$.break();
                }
                ++attempts$2.elem;
            }
            Predef$.MODULE$.println(new StringBuilder(91).append("ERROR: Unknown error: Gold path could not be generated after maximum number of attempts (").append(MAX_ATTEMPTS).append(").").toString());
        });
        ArithmeticGame game = this.mkGame(seed, fold);
        return new Tuple2<ArithmeticGame, String[]>(game, (String[])goldPath.elem);
    }

    public static final /* synthetic */ void $anonfun$mkEnvironment$2(ArrayBuffer validContainers$1, Random r$1, ArrayBuffer locations$1, FastObject obj) {
        if (validContainers$1.length() > 0) {
            FastObject randContainer = (FastObject)validContainers$1.apply(r$1.nextInt(validContainers$1.length()));
            randContainer.addObject(obj);
        } else {
            ((FastObject)locations$1.apply(0)).addObject(obj);
        }
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$mkCorrectAndDistractorObjects$1(ArithmeticGameGenerator $this, ArrayBuffer distractorObjects$1, Tuple2[] distractorObjectNames$1, int[] distractorQuantities$1, int i) {
        return (ArrayBuffer)distractorObjects$1.append($this.mkBundledObject(distractorObjectNames$1[i], distractorQuantities$1[i]));
    }
}

