/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.data;

import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.AbstractMap;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.Map$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.Random;
import textworldexpress.data.TWCObject;
import textworldexpress.objects.FastObject;
import ujson.Arr;
import ujson.Obj;
import ujson.Readable$;
import ujson.Value;
import ujson.package$;

public class LoadTWCDataJSON {
    private final /* synthetic */ Tuple3 x$1;
    private final TWCObject[] allObjsTrain;
    private final Map<String, TWCObject> lutObjTrain;
    private final Map<String, ArrayBuffer<TWCObject>> lutLocationTrain;
    private final /* synthetic */ Tuple3 x$2;
    private final TWCObject[] allObjsDev;
    private final Map<String, TWCObject> lutObjDev;
    private final Map<String, ArrayBuffer<TWCObject>> lutLocationDev;
    private final /* synthetic */ Tuple3 x$3;
    private final TWCObject[] allObjsTest;
    private final Map<String, TWCObject> lutObjTest;
    private final Map<String, ArrayBuffer<TWCObject>> lutLocationTest;

    public TWCObject[] allObjsTrain() {
        return this.allObjsTrain;
    }

    public Map<String, ArrayBuffer<TWCObject>> lutLocationTrain() {
        return this.lutLocationTrain;
    }

    public TWCObject[] allObjsDev() {
        return this.allObjsDev;
    }

    public Map<String, ArrayBuffer<TWCObject>> lutLocationDev() {
        return this.lutLocationDev;
    }

    public TWCObject[] allObjsTest() {
        return this.allObjsTest;
    }

    public Map<String, ArrayBuffer<TWCObject>> lutLocationTest() {
        return this.lutLocationTest;
    }

    public Option<FastObject> mkRandomObjectByLocation(Random r, String location, String fold) {
        String string = fold;
        String string2 = "train";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.mkRandomObjectByLocation(r, location, this.lutLocationTrain());
        }
        String string3 = fold;
        String string4 = "dev";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            return this.mkRandomObjectByLocation(r, location, this.lutLocationDev());
        }
        String string5 = fold;
        String string6 = "test";
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            return this.mkRandomObjectByLocation(r, location, this.lutLocationTest());
        }
        throw new RuntimeException(new StringBuilder(22).append("ERROR: Unknown fold (").append(fold).append(")").toString());
    }

    public Option<FastObject> mkRandomObject(Random r, String fold) {
        TWCObject[] objs;
        TWCObject[] tWCObjectArray;
        if (!ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(new String[]{"train", "dev", "test"}), fold)) {
            throw new RuntimeException(new StringBuilder(22).append("ERROR: Unknown fold (").append(fold).append(")").toString());
        }
        String string = fold;
        String string2 = "train";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            tWCObjectArray = this.allObjsTrain();
        } else {
            String string3 = fold;
            String string4 = "dev";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                tWCObjectArray = this.allObjsDev();
            } else {
                String string5 = fold;
                String string6 = "test";
                tWCObjectArray = !(string5 != null ? !string5.equals(string6) : string6 != null) ? this.allObjsTest() : (objs = this.allObjsTrain());
            }
        }
        if (objs.length == 0) {
            return None$.MODULE$;
        }
        int randObjIdx = r.nextInt(objs.length);
        FastObject randObj = objs[randObjIdx].toFastObject();
        return new Some<FastObject>(randObj);
    }

    private Option<FastObject> mkRandomObjectByLocation(Random r, String location, Map<String, ArrayBuffer<TWCObject>> lutLocation) {
        if (!lutLocation.contains(location)) {
            return None$.MODULE$;
        }
        ArrayBuffer validObjects = (ArrayBuffer)lutLocation.apply(location);
        if (validObjects.isEmpty()) {
            return None$.MODULE$;
        }
        int randIdx = r.nextInt(validObjects.length());
        FastObject obj = ((TWCObject)validObjects.apply(randIdx)).toFastObject();
        return new Some<FastObject>(obj);
    }

    public Tuple3<TWCObject[], Map<String, TWCObject>, Map<String, ArrayBuffer<TWCObject>>> load(String filenameIn, String foldName) {
        String jsonString = Source$.MODULE$.fromFile(filenameIn, Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
        LinkedHashMap dataRawAllFolds = (LinkedHashMap)package$.MODULE$.read(Readable$.MODULE$.fromString(jsonString), package$.MODULE$.read$default$2()).value();
        Object dataRaw = ((Obj)dataRawAllFolds.apply(foldName)).value();
        ArrayBuffer out = new ArrayBuffer();
        ((LinkedHashMap)dataRaw).keySet().foreach(arg_0 -> LoadTWCDataJSON.$anonfun$load$1((LinkedHashMap)dataRaw, out, arg_0));
        scala.collection.mutable.Map lutObj = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        out.foreach((Function1<TWCObject, Object> & Serializable)obj -> {
            lutObj.update(obj.name(), obj);
            return BoxedUnit.UNIT;
        });
        scala.collection.mutable.Map lutLocation = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        out.foreach((Function1<TWCObject, Object> & Serializable)obj -> {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(obj.locations()), (Function1<String, ArrayBuffer> & Serializable)location -> {
                block0: {
                    if (lutLocation$1.contains(location)) break block0;
                    lutLocation$1.update(location, new ArrayBuffer());
                }
                return (ArrayBuffer)((Buffer)lutLocation$1.apply(location)).append(obj);
            });
            return BoxedUnit.UNIT;
        });
        return new Tuple3(out.toArray(ClassTag$.MODULE$.apply(TWCObject.class)), lutObj.toMap($less$colon$less$.MODULE$.refl()), lutLocation.toMap($less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$load$1(LinkedHashMap dataRaw$1, ArrayBuffer out$1, String key) {
        Object record = ((Obj)dataRaw$1.apply(key)).value();
        String name = ((Value)((AbstractMap)record).apply("name")).toString().replaceAll("\"", "");
        String[] locations = (String[])((IterableOnceOps)((ArrayBuffer)((Arr)((AbstractMap)record).apply("locations")).value()).map((Function1<Value, String> & Serializable)x$4 -> x$4.toString().replaceAll("\"", ""))).toArray(ClassTag$.MODULE$.apply(String.class));
        return (ArrayBuffer)out$1.append(new TWCObject(name, locations));
    }

    public LoadTWCDataJSON(String filename) {
        Tuple3<TWCObject[], Map<String, TWCObject>, Map<String, ArrayBuffer<TWCObject>>> tuple3 = this.load(filename, "train");
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        TWCObject[] allObjsTrain = tuple3._1();
        Map<String, TWCObject> lutObjTrain = tuple3._2();
        Map<String, ArrayBuffer<TWCObject>> lutLocationTrain = tuple3._3();
        Tuple3<TWCObject[], Map<String, TWCObject>, Map<String, ArrayBuffer<TWCObject>>> tuple32 = new Tuple3<TWCObject[], Map<String, TWCObject>, Map<String, ArrayBuffer<TWCObject>>>(allObjsTrain, lutObjTrain, lutLocationTrain);
        this.x$1 = tuple32;
        this.allObjsTrain = (TWCObject[])this.x$1._1();
        this.lutObjTrain = (Map)this.x$1._2();
        this.lutLocationTrain = (Map)this.x$1._3();
        Tuple3<TWCObject[], Map<String, TWCObject>, Map<String, ArrayBuffer<TWCObject>>> tuple33 = this.load(filename, "valid");
        if (tuple33 == null) {
            throw new MatchError(tuple33);
        }
        TWCObject[] allObjsDev = tuple33._1();
        Map<String, TWCObject> lutObjDev = tuple33._2();
        Map<String, ArrayBuffer<TWCObject>> lutLocationDev = tuple33._3();
        Tuple3<TWCObject[], Map<String, TWCObject>, Map<String, ArrayBuffer<TWCObject>>> tuple34 = new Tuple3<TWCObject[], Map<String, TWCObject>, Map<String, ArrayBuffer<TWCObject>>>(allObjsDev, lutObjDev, lutLocationDev);
        this.x$2 = tuple34;
        this.allObjsDev = (TWCObject[])this.x$2._1();
        this.lutObjDev = (Map)this.x$2._2();
        this.lutLocationDev = (Map)this.x$2._3();
        Tuple3<TWCObject[], Map<String, TWCObject>, Map<String, ArrayBuffer<TWCObject>>> tuple35 = this.load(filename, "test");
        if (tuple35 == null) {
            throw new MatchError(tuple35);
        }
        TWCObject[] allObjsTest = tuple35._1();
        Map<String, TWCObject> lutObjTest = tuple35._2();
        Map<String, ArrayBuffer<TWCObject>> lutLocationTest = tuple35._3();
        Tuple3<TWCObject[], Map<String, TWCObject>, Map<String, ArrayBuffer<TWCObject>>> tuple36 = new Tuple3<TWCObject[], Map<String, TWCObject>, Map<String, ArrayBuffer<TWCObject>>>(allObjsTest, lutObjTest, lutLocationTest);
        this.x$3 = tuple36;
        this.allObjsTest = (TWCObject[])this.x$3._1();
        this.lutObjTest = (Map)this.x$3._2();
        this.lutLocationTest = (Map)this.x$3._3();
    }
}

