/*
 * Decompiled with CFR 0.152.
 */
package scala.io;

import java.io.Closeable;
import scala.$less$colon$less;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Tuple2;
import scala.collection.AbstractIterator;
import scala.collection.BufferedIterator;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.io.Position;
import scala.io.Source$RelaxedPosition$;
import scala.io.Source$RelaxedPositioner$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class Source
implements Closeable,
Iterator<Object> {
    private volatile Source$RelaxedPosition$ RelaxedPosition$module;
    private volatile Source$RelaxedPositioner$ RelaxedPositioner$module;
    private String descr = "";
    private int nerrors = 0;
    private int nwarnings = 0;
    private Function0<Source> resetFunction = null;
    private Function0<BoxedUnit> closeFunction = null;
    private Positioner positioner = this.RelaxedPositioner();

    @Override
    public final Iterator<Object> iterator() {
        return Iterator.iterator$(this);
    }

    @Override
    public BufferedIterator<Object> buffered() {
        return Iterator.buffered$(this);
    }

    @Override
    public int indexWhere(Function1<Object, Object> p, int from) {
        return Iterator.indexWhere$(this, p, from);
    }

    @Override
    public boolean isEmpty() {
        return Iterator.isEmpty$(this);
    }

    @Override
    public Iterator<Object> filterImpl(Function1<Object, Object> p, boolean isFlipped) {
        return Iterator.filterImpl$(this, p, isFlipped);
    }

    @Override
    public <B> Iterator<B> map(Function1<Object, B> f) {
        return Iterator.map$(this, f);
    }

    @Override
    public <B> Iterator<B> flatMap(Function1<Object, IterableOnce<B>> f) {
        return Iterator.flatMap$(this, f);
    }

    @Override
    public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
        return Iterator.concat$(this, xs);
    }

    @Override
    public Iterator<Object> take(int n) {
        return Iterator.take$(this, n);
    }

    @Override
    public Iterator<Object> takeWhile(Function1<Object, Object> p) {
        return Iterator.takeWhile$(this, p);
    }

    @Override
    public Iterator<Object> drop(int n) {
        return Iterator.drop$(this, n);
    }

    @Override
    public Iterator<Object> sliceIterator(int from, int until) {
        return Iterator.sliceIterator$(this, from, until);
    }

    @Override
    public <B> boolean sameElements(IterableOnce<B> that) {
        return Iterator.sameElements$(this, that);
    }

    @Override
    public String toString() {
        return Iterator.toString$(this);
    }

    @Override
    public <U> void foreach(Function1<Object, U> f) {
        IterableOnceOps.foreach$(this, f);
    }

    @Override
    public boolean forall(Function1<Object, Object> p) {
        return IterableOnceOps.forall$(this, p);
    }

    @Override
    public boolean exists(Function1<Object, Object> p) {
        return IterableOnceOps.exists$(this, p);
    }

    @Override
    public Option<Object> find(Function1<Object, Object> p) {
        return IterableOnceOps.find$(this, p);
    }

    @Override
    public <B> B foldLeft(B z, Function2<B, Object, B> op) {
        return (B)IterableOnceOps.foldLeft$(this, z, op);
    }

    @Override
    public boolean nonEmpty() {
        return IterableOnceOps.nonEmpty$(this);
    }

    @Override
    public int size() {
        return IterableOnceOps.size$(this);
    }

    @Override
    public <B> int copyToArray(Object xs) {
        return IterableOnceOps.copyToArray$(this, xs);
    }

    @Override
    public <B> int copyToArray(Object xs, int start) {
        return IterableOnceOps.copyToArray$(this, xs, start);
    }

    @Override
    public <B> int copyToArray(Object xs, int start, int len) {
        return IterableOnceOps.copyToArray$(this, xs, start, len);
    }

    @Override
    public final String mkString(String start, String sep, String end) {
        return IterableOnceOps.mkString$(this, start, sep, end);
    }

    @Override
    public final String mkString(String sep) {
        return IterableOnceOps.mkString$(this, sep);
    }

    @Override
    public final String mkString() {
        return IterableOnceOps.mkString$(this);
    }

    @Override
    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return IterableOnceOps.addString$(this, b, start, sep, end);
    }

    @Override
    public List<Object> toList() {
        return IterableOnceOps.toList$(this);
    }

    @Override
    public <K$, V$> Map<K$, V$> toMap($less$colon$less<Object, Tuple2<K$, V$>> ev) {
        return IterableOnceOps.toMap$(this, ev);
    }

    @Override
    public <B> Set<B> toSet() {
        return IterableOnceOps.toSet$(this);
    }

    @Override
    public Seq<Object> toSeq() {
        return IterableOnceOps.toSeq$(this);
    }

    @Override
    public <B> Object toArray(ClassTag<B> evidence$2) {
        return IterableOnceOps.toArray$(this, evidence$2);
    }

    @Override
    public Iterable<Object> reversed() {
        return IterableOnceOps.reversed$(this);
    }

    @Override
    public int knownSize() {
        return IterableOnce.knownSize$(this);
    }

    public Source$RelaxedPosition$ RelaxedPosition() {
        if (this.RelaxedPosition$module == null) {
            this.RelaxedPosition$lzycompute$1();
        }
        return this.RelaxedPosition$module;
    }

    public Source$RelaxedPositioner$ RelaxedPositioner() {
        if (this.RelaxedPositioner$module == null) {
            this.RelaxedPositioner$lzycompute$1();
        }
        return this.RelaxedPositioner$module;
    }

    public abstract Iterator<Object> iter();

    public void descr_$eq(String x$1) {
        this.descr = x$1;
    }

    public Iterator<String> getLines() {
        return new LineIterator();
    }

    @Override
    public boolean hasNext() {
        return this.iter().hasNext();
    }

    @Override
    public char next() {
        return this.positioner.next();
    }

    public Source withReset(Function0<Source> f) {
        this.resetFunction = f;
        return this;
    }

    public Source withClose(Function0<BoxedUnit> f) {
        this.closeFunction = f;
        return this;
    }

    public Source withDescription(String text) {
        this.descr_$eq(text);
        return this;
    }

    @Override
    public void close() {
        if (this.closeFunction != null) {
            this.closeFunction.apply$mcV$sp();
        }
    }

    private final void RelaxedPosition$lzycompute$1() {
        synchronized (this) {
            if (this.RelaxedPosition$module == null) {
                this.RelaxedPosition$module = new Source$RelaxedPosition$(this);
            }
            return;
        }
    }

    private final void RelaxedPositioner$lzycompute$1() {
        synchronized (this) {
            if (this.RelaxedPositioner$module == null) {
                this.RelaxedPositioner$module = new Source$RelaxedPositioner$(this);
            }
            return;
        }
    }

    public class LineIterator
    extends AbstractIterator<String> {
        private BufferedIterator<Object> iter;
        private final StringBuilder sb;
        private volatile boolean bitmap$0;

        private BufferedIterator<Object> iter$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.iter = this.scala$io$Source$LineIterator$$$outer().iter().buffered();
                    this.bitmap$0 = true;
                }
            }
            return this.iter;
        }

        public BufferedIterator<Object> iter() {
            if (!this.bitmap$0) {
                return this.iter$lzycompute();
            }
            return this.iter;
        }

        public boolean getc() {
            if (this.iter().hasNext()) {
                boolean bl;
                char ch = BoxesRunTime.unboxToChar(this.iter().next());
                if (ch == '\n') {
                    bl = false;
                } else if (ch == '\r') {
                    if (this.iter().hasNext() && BoxesRunTime.unboxToChar(this.iter().head()) == '\n') {
                        this.iter().next();
                    }
                    bl = false;
                } else {
                    this.sb.append(ch);
                    bl = true;
                }
                if (bl) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.iter().hasNext();
        }

        @Override
        public String next() {
            this.sb.clear();
            while (this.getc()) {
            }
            StringBuilder stringBuilder = this.sb;
            if (stringBuilder == null) {
                throw null;
            }
            return stringBuilder.result();
        }

        public /* synthetic */ Source scala$io$Source$LineIterator$$$outer() {
            return Source.this;
        }

        public LineIterator() {
            if (Source.this == null) {
                throw null;
            }
            this.sb = new StringBuilder();
        }
    }

    public class Positioner {
        private final Position encoder;
        private char ch;
        private int pos;
        private int cline;
        private int ccol;
        private int tabinc;
        public final /* synthetic */ Source $outer;

        public char ch() {
            return this.ch;
        }

        public void ch_$eq(char x$1) {
            this.ch = x$1;
        }

        public void pos_$eq(int x$1) {
            this.pos = x$1;
        }

        public int cline() {
            return this.cline;
        }

        public void cline_$eq(int x$1) {
            this.cline = x$1;
        }

        public int ccol() {
            return this.ccol;
        }

        public void ccol_$eq(int x$1) {
            this.ccol = x$1;
        }

        public int tabinc() {
            return this.tabinc;
        }

        public char next() {
            this.ch_$eq(BoxesRunTime.unboxToChar(this.scala$io$Source$Positioner$$$outer().iter().next()));
            this.pos_$eq(this.encoder.encode(this.cline(), this.ccol()));
            switch (this.ch()) {
                case '\n': {
                    this.ccol_$eq(1);
                    this.cline_$eq(this.cline() + 1);
                    break;
                }
                case '\t': {
                    this.ccol_$eq(this.ccol() + this.tabinc());
                    break;
                }
                default: {
                    this.ccol_$eq(this.ccol() + 1);
                }
            }
            return this.ch();
        }

        public /* synthetic */ Source scala$io$Source$Positioner$$$outer() {
            return this.$outer;
        }

        public Positioner(Source $outer, Position encoder) {
            this.encoder = encoder;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.pos = 0;
            this.cline = 1;
            this.ccol = 1;
            this.tabinc = 4;
        }
    }
}

