/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.Function0;
import scala.Function1;
import scala.collection.AbstractIndexedSeqView;
import scala.collection.IndexedSeqView;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.CheckedIndexedSeqView;

public final class ArrayBufferView<A>
extends AbstractIndexedSeqView<A> {
    private final ArrayBuffer<A> underlying;
    private final Function0<Object> mutationCount;

    @Override
    public A apply(int n) throws IndexOutOfBoundsException {
        return this.underlying.apply(n);
    }

    @Override
    public int length() {
        return this.underlying.length();
    }

    @Override
    public String className() {
        return "ArrayBufferView";
    }

    @Override
    public Iterator<A> iterator() {
        return new CheckedIndexedSeqView.CheckedIterator(this, this.mutationCount);
    }

    @Override
    public Iterator<A> reverseIterator() {
        return new CheckedIndexedSeqView.CheckedReverseIterator(this, this.mutationCount);
    }

    @Override
    public <B> IndexedSeqView<B> appended(B elem) {
        return new CheckedIndexedSeqView.Appended<B>(this, elem, this.mutationCount);
    }

    @Override
    public IndexedSeqView<A> drop(int n) {
        return new CheckedIndexedSeqView.Drop(this, n, this.mutationCount);
    }

    @Override
    public <B> IndexedSeqView<B> map(Function1<A, B> f) {
        return new CheckedIndexedSeqView.Map<A, B>(this, f, this.mutationCount);
    }

    @Override
    public IndexedSeqView<A> slice(int from, int until) {
        return new CheckedIndexedSeqView.Slice(this, from, until, this.mutationCount);
    }

    public ArrayBufferView(ArrayBuffer<A> underlying, Function0<Object> mutationCount) {
        this.underlying = underlying;
        this.mutationCount = mutationCount;
    }
}

