/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.Arrays;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.collection.Hashing$;
import scala.collection.IterableOnce;
import scala.collection.immutable.HashCollisionSetNode;
import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;
import scala.collection.immutable.SetNode;
import scala.collection.immutable.SetNode$;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class BitmapIndexedSetNode<A>
extends SetNode<A> {
    private int dataMap;
    private int nodeMap;
    private Object[] content;
    private int[] originalHashes;
    private int size;
    private int cachedJavaKeySetHashCode;

    public int dataMap() {
        return this.dataMap;
    }

    public void dataMap_$eq(int x$1) {
        this.dataMap = x$1;
    }

    public int nodeMap() {
        return this.nodeMap;
    }

    public void nodeMap_$eq(int x$1) {
        this.nodeMap = x$1;
    }

    public Object[] content() {
        return this.content;
    }

    public void content_$eq(Object[] x$1) {
        this.content = x$1;
    }

    public int[] originalHashes() {
        return this.originalHashes;
    }

    public void originalHashes_$eq(int[] x$1) {
        this.originalHashes = x$1;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void size_$eq(int x$1) {
        this.size = x$1;
    }

    @Override
    public int cachedJavaKeySetHashCode() {
        return this.cachedJavaKeySetHashCode;
    }

    public void cachedJavaKeySetHashCode_$eq(int x$1) {
        this.cachedJavaKeySetHashCode = x$1;
    }

    @Override
    public A getPayload(int index) {
        return (A)this.content()[index];
    }

    @Override
    public int getHash(int index) {
        return this.originalHashes()[index];
    }

    @Override
    public SetNode<A> getNode(int index) {
        return (SetNode)this.content()[this.content().length - 1 - index];
    }

    @Override
    public boolean contains(A element, int originalHash, int elementHash, int shift) {
        int n = elementHash >>> shift & 0x1F;
        int n2 = 1 << n;
        if ((this.dataMap() & n2) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), n, n2);
            return this.originalHashes()[index] == originalHash && BoxesRunTime.equals(element, this.content()[index]);
        }
        if ((this.nodeMap() & n2) != 0) {
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), n, n2);
            return ((SetNode)this.getNode(index)).contains(element, originalHash, elementHash, shift + 5);
        }
        return false;
    }

    @Override
    public BitmapIndexedSetNode<A> updated(A element, int originalHash, int elementHash, int shift) {
        int n = elementHash >>> shift & 0x1F;
        int n2 = 1 << n;
        if ((this.dataMap() & n2) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), n, n2);
            Object element0 = this.content()[index];
            if (element0 == element) {
                return this;
            }
            int n3 = this.originalHashes()[index];
            int element0Hash = Hashing$.MODULE$.improve(n3);
            if (originalHash == n3 && BoxesRunTime.equals(element0, element)) {
                return this;
            }
            SetNode<Object> subNodeNew = this.mergeTwoKeyValPairs(element0, n3, element0Hash, element, originalHash, elementHash, shift + 5);
            return this.copyAndMigrateFromInlineToNode(n2, element0Hash, subNodeNew);
        }
        if ((this.nodeMap() & n2) != 0) {
            SetNode<A> subNodeNew;
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), n, n2);
            Node subNode = this.getNode(index);
            if (subNode == (subNodeNew = ((SetNode)subNode).updated(element, originalHash, elementHash, shift + 5))) {
                return this;
            }
            return this.copyAndSetNode(n2, (SetNode<A>)subNode, subNodeNew);
        }
        return this.copyAndInsertValue(n2, element, originalHash, elementHash);
    }

    /*
     * Unable to fully structure code
     */
    public int updateWithShallowMutations(A element, int originalHash, int elementHash, int shift, int shallowlyMutableNodeMap) {
        block5: {
            var24_6 = elementHash >>> shift & 31;
            var25_7 = 1 << var24_6;
            if ((this.dataMap() & var25_7) != 0) {
                index = Node$.MODULE$.indexFrom(this.dataMap(), var24_6, var25_7);
                v0 = var22_9 = this.content()[index];
                var22_9 = null;
                element0 = v0;
                var23_11 = this.originalHashes()[index];
                if (var23_11 == originalHash && BoxesRunTime.equals(element0, element)) {
                    return shallowlyMutableNodeMap;
                }
                element0Hash = Hashing$.MODULE$.improve(var23_11);
                subNodeNew = this.mergeTwoKeyValPairs(element0, var23_11, element0Hash, element, originalHash, elementHash, shift + 5);
                this.migrateFromInlineToNodeInPlace(var25_7, element0Hash, subNodeNew);
                return shallowlyMutableNodeMap | var25_7;
            }
            if ((this.nodeMap() & var25_7) == 0) break block5;
            index = Node$.MODULE$.indexFrom(this.nodeMap(), var24_6, var25_7);
            subNode = this.getNode(index);
            subNodeSize = subNode.size();
            subNodeCachedJavaKeySetHashCode = subNode.cachedJavaKeySetHashCode();
            returnNodeMap = shallowlyMutableNodeMap;
            if (!(subNode instanceof BitmapIndexedSetNode)) ** GOTO lbl-1000
            var16_19 = (BitmapIndexedSetNode)subNode;
            if ((var25_7 & shallowlyMutableNodeMap) != 0) {
                var16_19.updateWithShallowMutations(element, originalHash, elementHash, shift + 5, 0);
                var6_20 = var16_19;
            } else lbl-1000:
            // 2 sources

            {
                if ((subNodeNew = subNode.updated(element, originalHash, elementHash, shift + 5)) != subNode) {
                    returnNodeMap = shallowlyMutableNodeMap | var25_7;
                }
                var6_20 = subNodeNew;
            }
            this.content()[this.content().length - 1 - this.nodeIndex((int)var25_7)] = var6_20;
            this.size_$eq(this.size() - subNodeSize + var6_20.size());
            this.cachedJavaKeySetHashCode_$eq(this.cachedJavaKeySetHashCode() - subNodeCachedJavaKeySetHashCode + var6_20.cachedJavaKeySetHashCode());
            return returnNodeMap;
        }
        dataIx = this.dataIndex(var25_7);
        src = this.content();
        dst = new Object[src.length + 1];
        System.arraycopy(src, 0, dst, 0, dataIx);
        dst[dataIx] = element;
        System.arraycopy(src, dataIx, dst, dataIx + 1, src.length - dataIx);
        dstHashes = this.insertElement(this.originalHashes(), dataIx, originalHash);
        this.dataMap_$eq(this.dataMap() | var25_7);
        this.content_$eq(dst);
        this.originalHashes_$eq(dstHashes);
        this.size_$eq(this.size() + 1);
        this.cachedJavaKeySetHashCode_$eq(this.cachedJavaKeySetHashCode() + elementHash);
        return shallowlyMutableNodeMap;
    }

    @Override
    public BitmapIndexedSetNode<A> removed(A element, int originalHash, int elementHash, int shift) {
        int n = elementHash >>> shift & 0x1F;
        int n2 = 1 << n;
        if ((this.dataMap() & n2) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), n, n2);
            if (BoxesRunTime.equals(this.content()[index], element)) {
                if (this.payloadArity() == 2 && this.nodeArity() == 0) {
                    int newDataMap;
                    int n3;
                    if (shift == 0) {
                        n3 = this.dataMap() ^ n2;
                    } else {
                        int maskFrom_shift = 0;
                        int n4 = elementHash >>> maskFrom_shift & 0x1F;
                        n3 = newDataMap = 1 << n4;
                    }
                    if (index == 0) {
                        Object[] objectArray = new Object[1];
                        int getPayload_index = 1;
                        objectArray[0] = this.content()[getPayload_index];
                        return new BitmapIndexedSetNode<A>(newDataMap, 0, objectArray, new int[]{this.originalHashes()[1]}, this.size() - 1, Hashing$.MODULE$.improve(this.originalHashes()[1]));
                    }
                    Object[] objectArray = new Object[1];
                    int getPayload_index = 0;
                    objectArray[0] = this.content()[getPayload_index];
                    return new BitmapIndexedSetNode<A>(newDataMap, 0, objectArray, new int[]{this.originalHashes()[0]}, this.size() - 1, Hashing$.MODULE$.improve(this.originalHashes()[0]));
                }
                return this.copyAndRemoveValue(n2, elementHash);
            }
            return this;
        }
        if ((this.nodeMap() & n2) != 0) {
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), n, n2);
            Node subNode = this.getNode(index);
            SetNode<A> subNodeNew = ((SetNode)subNode).removed(element, originalHash, elementHash, shift + 5);
            if (subNodeNew == subNode) {
                return this;
            }
            int subNodeNewSize = subNodeNew.size();
            if (subNodeNewSize == 1) {
                if (this.size() == ((SetNode)subNode).size()) {
                    return (BitmapIndexedSetNode)subNodeNew;
                }
                return this.copyAndMigrateFromNodeToInline(n2, elementHash, (SetNode<A>)subNode, subNodeNew);
            }
            if (subNodeNewSize > 1) {
                return this.copyAndSetNode(n2, (SetNode<A>)subNode, subNodeNew);
            }
        }
        return this;
    }

    public BitmapIndexedSetNode<A> removeWithShallowMutations(A element, int originalHash, int elementHash) {
        int maskFrom_shift = 0;
        int n = elementHash >>> maskFrom_shift & 0x1F;
        int n2 = 1 << n;
        if ((this.dataMap() & n2) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), n, n2);
            if (BoxesRunTime.equals(this.content()[index], element)) {
                if (this.payloadArity() == 2 && this.nodeArity() == 0) {
                    int newDataMap = this.dataMap() ^ n2;
                    if (index == 0) {
                        Object[] objectArray = new Object[1];
                        int getPayload_index = 1;
                        objectArray[0] = this.content()[getPayload_index];
                        Object[] newContent = objectArray;
                        int[] newOriginalHashes = new int[]{this.originalHashes()[1]};
                        int getHash_index = 1;
                        int newCachedJavaKeySetHashCode = Hashing$.MODULE$.improve(this.originalHashes()[getHash_index]);
                        this.content_$eq(newContent);
                        this.originalHashes_$eq(newOriginalHashes);
                        this.cachedJavaKeySetHashCode_$eq(newCachedJavaKeySetHashCode);
                    } else {
                        Object[] objectArray = new Object[1];
                        int getPayload_index = 0;
                        objectArray[0] = this.content()[getPayload_index];
                        Object[] newContent = objectArray;
                        int[] newOriginalHashes = new int[]{this.originalHashes()[0]};
                        int getHash_index = 0;
                        int newCachedJavaKeySetHashCode = Hashing$.MODULE$.improve(this.originalHashes()[getHash_index]);
                        this.content_$eq(newContent);
                        this.originalHashes_$eq(newOriginalHashes);
                        this.cachedJavaKeySetHashCode_$eq(newCachedJavaKeySetHashCode);
                    }
                    this.dataMap_$eq(newDataMap);
                    this.nodeMap_$eq(0);
                    this.size_$eq(1);
                    return this;
                }
                int dataIx = this.dataIndex(n2);
                int idx = 1 * dataIx;
                Object[] src = this.content();
                Object[] dst = new Object[src.length - 1];
                System.arraycopy(src, 0, dst, 0, idx);
                System.arraycopy(src, idx + 1, dst, idx, src.length - idx - 1);
                int[] dstHashes = this.removeElement(this.originalHashes(), dataIx);
                this.dataMap_$eq(this.dataMap() ^ n2);
                this.content_$eq(dst);
                this.originalHashes_$eq(dstHashes);
                this.size_$eq(this.size() - 1);
                this.cachedJavaKeySetHashCode_$eq(this.cachedJavaKeySetHashCode() - elementHash);
                return this;
            }
            return this;
        }
        if ((this.nodeMap() & n2) != 0) {
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), n, n2);
            Node subNode = this.getNode(index);
            BitmapIndexedSetNode subNodeNew = (BitmapIndexedSetNode)((SetNode)subNode).removed(element, originalHash, elementHash, 5);
            if (subNodeNew == subNode) {
                return this;
            }
            if (subNodeNew.size() == 1) {
                if (this.payloadArity() == 0 && this.nodeArity() == 1) {
                    this.dataMap_$eq(subNodeNew.dataMap());
                    this.nodeMap_$eq(subNodeNew.nodeMap());
                    this.content_$eq(subNodeNew.content());
                    this.originalHashes_$eq(subNodeNew.originalHashes());
                    this.size_$eq(subNodeNew.size());
                    this.cachedJavaKeySetHashCode_$eq(subNodeNew.cachedJavaKeySetHashCode());
                    return this;
                }
                this.migrateFromNodeToInlineInPlace(n2, originalHash, elementHash, (SetNode<A>)subNode, subNodeNew);
                return this;
            }
            this.content()[this.content().length - 1 - this.nodeIndex((int)n2)] = subNodeNew;
            this.size_$eq(this.size() - 1);
            this.cachedJavaKeySetHashCode_$eq(this.cachedJavaKeySetHashCode() - subNode.cachedJavaKeySetHashCode() + subNodeNew.cachedJavaKeySetHashCode());
            return this;
        }
        return this;
    }

    public SetNode<A> mergeTwoKeyValPairs(A key0, int originalKeyHash0, int keyHash0, A key1, int originalKeyHash1, int keyHash1, int shift) {
        if (shift >= 32) {
            return new HashCollisionSetNode(originalKeyHash0, keyHash0, Vector$.MODULE$.from((IterableOnce)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{key0, key1})));
        }
        int n = keyHash0 >>> shift & 0x1F;
        int n2 = keyHash1 >>> shift & 0x1F;
        if (n != n2) {
            int dataMap = 1 << n | 1 << n2;
            int newCachedHashCode = keyHash0 + keyHash1;
            if (n < n2) {
                return new BitmapIndexedSetNode<A>(dataMap, 0, new Object[]{key0, key1}, new int[]{originalKeyHash0, originalKeyHash1}, 2, newCachedHashCode);
            }
            return new BitmapIndexedSetNode<A>(dataMap, 0, new Object[]{key1, key0}, new int[]{originalKeyHash1, originalKeyHash0}, 2, newCachedHashCode);
        }
        int n3 = 1 << n;
        SetNode<A> node = this.mergeTwoKeyValPairs(key0, originalKeyHash0, keyHash0, key1, originalKeyHash1, keyHash1, shift + 5);
        return new BitmapIndexedSetNode<A>(0, n3, new Object[]{node}, Array$.MODULE$.emptyIntArray(), node.size(), node.cachedJavaKeySetHashCode());
    }

    @Override
    public boolean hasPayload() {
        return this.dataMap() != 0;
    }

    @Override
    public int payloadArity() {
        return Integer.bitCount(this.dataMap());
    }

    @Override
    public boolean hasNodes() {
        return this.nodeMap() != 0;
    }

    @Override
    public int nodeArity() {
        return Integer.bitCount(this.nodeMap());
    }

    public int dataIndex(int bitpos) {
        return Integer.bitCount(this.dataMap() & bitpos - 1);
    }

    public int nodeIndex(int bitpos) {
        return Integer.bitCount(this.nodeMap() & bitpos - 1);
    }

    public BitmapIndexedSetNode<A> copyAndSetNode(int bitpos, SetNode<A> oldNode, SetNode<A> newNode) {
        int idx = this.content().length - 1 - this.nodeIndex(bitpos);
        Object[] src = this.content();
        Object[] dst = new Object[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        dst[idx] = newNode;
        return new BitmapIndexedSetNode<A>(this.dataMap(), this.nodeMap(), dst, this.originalHashes(), this.size() - oldNode.size() + newNode.size(), this.cachedJavaKeySetHashCode() - oldNode.cachedJavaKeySetHashCode() + newNode.cachedJavaKeySetHashCode());
    }

    public BitmapIndexedSetNode<A> copyAndInsertValue(int bitpos, A key, int originalHash, int elementHash) {
        int dataIx = this.dataIndex(bitpos);
        int idx = 1 * dataIx;
        Object[] src = this.content();
        Object[] dst = new Object[src.length + 1];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = key;
        System.arraycopy(src, idx, dst, idx + 1, src.length - idx);
        int[] dstHashes = this.insertElement(this.originalHashes(), dataIx, originalHash);
        return new BitmapIndexedSetNode<A>(this.dataMap() | bitpos, this.nodeMap(), dst, dstHashes, this.size() + 1, this.cachedJavaKeySetHashCode() + elementHash);
    }

    public BitmapIndexedSetNode<A> copyAndRemoveValue(int bitpos, int elementHash) {
        int dataIx = this.dataIndex(bitpos);
        int idx = 1 * dataIx;
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 1];
        System.arraycopy(src, 0, dst, 0, idx);
        System.arraycopy(src, idx + 1, dst, idx, src.length - idx - 1);
        int[] dstHashes = this.removeElement(this.originalHashes(), dataIx);
        return new BitmapIndexedSetNode<A>(this.dataMap() ^ bitpos, this.nodeMap(), dst, dstHashes, this.size() - 1, this.cachedJavaKeySetHashCode() - elementHash);
    }

    public BitmapIndexedSetNode<A> copyAndMigrateFromInlineToNode(int bitpos, int elementHash, SetNode<A> node) {
        int dataIx = this.dataIndex(bitpos);
        int idxOld = 1 * dataIx;
        int idxNew = this.content().length - 1 - this.nodeIndex(bitpos);
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 1 + 1];
        System.arraycopy(src, 0, dst, 0, idxOld);
        System.arraycopy(src, idxOld + 1, dst, idxOld, idxNew - idxOld);
        dst[idxNew] = node;
        System.arraycopy(src, idxNew + 1, dst, idxNew + 1, src.length - idxNew - 1);
        int[] dstHashes = this.removeElement(this.originalHashes(), dataIx);
        return new BitmapIndexedSetNode<A>(this.dataMap() ^ bitpos, this.nodeMap() | bitpos, dst, dstHashes, this.size() - 1 + node.size(), this.cachedJavaKeySetHashCode() - elementHash + node.cachedJavaKeySetHashCode());
    }

    public BitmapIndexedSetNode<A> migrateFromInlineToNodeInPlace(int bitpos, int keyHash, SetNode<A> node) {
        int dataIx = this.dataIndex(bitpos);
        int idxOld = 1 * dataIx;
        int idxNew = this.content().length - 1 - this.nodeIndex(bitpos);
        System.arraycopy(this.content(), idxOld + 1, this.content(), idxOld, idxNew - idxOld);
        this.content()[idxNew] = node;
        this.dataMap_$eq(this.dataMap() ^ bitpos);
        this.nodeMap_$eq(this.nodeMap() | bitpos);
        this.originalHashes_$eq(this.removeElement(this.originalHashes(), dataIx));
        this.size_$eq(this.size() - 1 + node.size());
        this.cachedJavaKeySetHashCode_$eq(this.cachedJavaKeySetHashCode() - keyHash + node.cachedJavaKeySetHashCode());
        return this;
    }

    public BitmapIndexedSetNode<A> copyAndMigrateFromNodeToInline(int bitpos, int elementHash, SetNode<A> oldNode, SetNode<A> node) {
        int idxOld = this.content().length - 1 - this.nodeIndex(bitpos);
        int dataIxNew = this.dataIndex(bitpos);
        int idxNew = 1 * dataIxNew;
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 1 + 1];
        System.arraycopy(src, 0, dst, 0, idxNew);
        dst[idxNew] = node.getPayload(0);
        System.arraycopy(src, idxNew, dst, idxNew + 1, idxOld - idxNew);
        System.arraycopy(src, idxOld + 1, dst, idxOld + 1, src.length - idxOld - 1);
        int hash = node.getHash(0);
        int[] dstHashes = this.insertElement(this.originalHashes(), dataIxNew, hash);
        return new BitmapIndexedSetNode<A>(this.dataMap() | bitpos, this.nodeMap() ^ bitpos, dst, dstHashes, this.size() - oldNode.size() + 1, this.cachedJavaKeySetHashCode() - oldNode.cachedJavaKeySetHashCode() + node.cachedJavaKeySetHashCode());
    }

    public void migrateFromNodeToInlineInPlace(int bitpos, int originalHash, int elementHash, SetNode<A> oldNode, SetNode<A> node) {
        int idxOld = this.content().length - 1 - this.nodeIndex(bitpos);
        int dataIxNew = this.dataIndex(bitpos);
        A element = node.getPayload(0);
        System.arraycopy(this.content(), dataIxNew, this.content(), dataIxNew + 1, idxOld - dataIxNew);
        this.content()[dataIxNew] = element;
        int hash = node.getHash(0);
        int[] dstHashes = this.insertElement(this.originalHashes(), dataIxNew, hash);
        this.dataMap_$eq(this.dataMap() | bitpos);
        this.nodeMap_$eq(this.nodeMap() ^ bitpos);
        this.originalHashes_$eq(dstHashes);
        this.size_$eq(this.size() - oldNode.size() + 1);
        this.cachedJavaKeySetHashCode_$eq(this.cachedJavaKeySetHashCode() - oldNode.cachedJavaKeySetHashCode() + node.cachedJavaKeySetHashCode());
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        int thisPayloadArity = this.payloadArity();
        for (int i = 0; i < thisPayloadArity; ++i) {
            f.apply(this.content()[i]);
        }
        int thisNodeArity = this.nodeArity();
        for (int j = 0; j < thisNodeArity; ++j) {
            ((SetNode)this.getNode(j)).foreach(f);
        }
    }

    @Override
    public BitmapIndexedSetNode<A> filterImpl(Function1<A, Object> pred, boolean flipped) {
        if (this.size() == 0) {
            return this;
        }
        if (this.size() == 1) {
            int getPayload_index = 0;
            if (BoxesRunTime.unboxToBoolean(pred.apply(this.content()[getPayload_index])) != flipped) {
                return this;
            }
            return SetNode$.MODULE$.empty();
        }
        if (this.nodeMap() == 0) {
            int minimumIndex = Integer.numberOfTrailingZeros(this.dataMap());
            int maximumIndex = 32 - Integer.numberOfLeadingZeros(this.dataMap());
            int newDataMap = 0;
            int newCachedHashCode = 0;
            int dataIndex = 0;
            for (int i = minimumIndex; i < maximumIndex; ++i) {
                Object object;
                int n = 1 << i;
                if ((n & this.dataMap()) == 0) continue;
                Object object2 = object = this.content()[dataIndex];
                object = null;
                Object payload = object2;
                if (BoxesRunTime.unboxToBoolean(pred.apply(payload)) != flipped) {
                    newDataMap |= n;
                    newCachedHashCode += Hashing$.MODULE$.improve(this.originalHashes()[dataIndex]);
                }
                ++dataIndex;
            }
            if (newDataMap == 0) {
                return SetNode$.MODULE$.empty();
            }
            if (newDataMap == this.dataMap()) {
                return this;
            }
            int newSize = Integer.bitCount(newDataMap);
            Object[] newContent = new Object[newSize];
            int[] newOriginalHashCodes = new int[newSize];
            int newMaximumIndex = 32 - Integer.numberOfLeadingZeros(newDataMap);
            int newDataIndex = 0;
            for (int j = Integer.numberOfTrailingZeros(newDataMap); j < newMaximumIndex; ++j) {
                int n = 1 << j;
                if ((n & newDataMap) == 0) continue;
                int n2 = Integer.bitCount(this.dataMap() & n - 1);
                newContent[newDataIndex] = this.content()[n2];
                newOriginalHashCodes[newDataIndex] = this.originalHashes()[n2];
                ++newDataIndex;
            }
            return new BitmapIndexedSetNode<A>(newDataMap, 0, newContent, newOriginalHashCodes, newSize, newCachedHashCode);
        }
        int allMap = this.dataMap() | this.nodeMap();
        int minimumIndex = Integer.numberOfTrailingZeros(allMap);
        int maximumIndex = 32 - Integer.numberOfLeadingZeros(allMap);
        int oldDataPassThrough = 0;
        int nodeMigrateToDataTargetMap = 0;
        Object nodesToMigrateToData = null;
        int nodesToPassThroughMap = 0;
        int mapOfNewNodes = 0;
        Object newNodes = null;
        int newDataMap = 0;
        int newNodeMap = 0;
        int newSize = 0;
        int newCachedHashCode = 0;
        int dataIndex = 0;
        int nodeIndex = 0;
        for (int i = minimumIndex; i < maximumIndex; ++i) {
            int n = 1 << i;
            if ((n & this.dataMap()) != 0) {
                Object object;
                Object object3 = object = this.content()[dataIndex];
                object = null;
                Object payload = object3;
                if (BoxesRunTime.unboxToBoolean(pred.apply(payload)) != flipped) {
                    newDataMap |= n;
                    oldDataPassThrough |= n;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(this.originalHashes()[dataIndex]);
                }
                ++dataIndex;
                continue;
            }
            if ((n & this.nodeMap()) == 0) continue;
            Node oldSubNode = this.getNode(nodeIndex);
            SetNode<A> newSubNode = ((SetNode)oldSubNode).filterImpl(pred, flipped);
            newSize += newSubNode.size();
            newCachedHashCode += newSubNode.cachedJavaKeySetHashCode();
            if (newSubNode.size() > 1) {
                newNodeMap |= n;
                if (oldSubNode == newSubNode) {
                    nodesToPassThroughMap |= n;
                } else {
                    mapOfNewNodes |= n;
                    if (newNodes == null) {
                        newNodes = Queue$.MODULE$.empty();
                    }
                    ((AbstractBuffer)newNodes).$plus$eq(newSubNode);
                }
            } else if (newSubNode.size() == 1) {
                newDataMap |= n;
                nodeMigrateToDataTargetMap |= n;
                if (nodesToMigrateToData == null) {
                    nodesToMigrateToData = Queue$.MODULE$.empty();
                }
                ((AbstractBuffer)nodesToMigrateToData).$plus$eq(newSubNode);
            }
            ++nodeIndex;
        }
        return this.newNodeFrom(newSize, newDataMap, newNodeMap, minimumIndex, oldDataPassThrough, nodesToPassThroughMap, nodeMigrateToDataTargetMap, (Queue<SetNode<A>>)nodesToMigrateToData, mapOfNewNodes, (Queue<SetNode<A>>)newNodes, newCachedHashCode);
    }

    @Override
    public BitmapIndexedSetNode<A> diff(SetNode<A> that, int shift) {
        BitmapIndexedSetNode bitmapIndexedSetNode;
        if (that instanceof BitmapIndexedSetNode) {
            BitmapIndexedSetNode bitmapIndexedSetNode2 = (BitmapIndexedSetNode)that;
            if (this.size() == 0) {
                bitmapIndexedSetNode = this;
            } else if (this.size() == 1) {
                int getHash_index = 0;
                int n = this.originalHashes()[getHash_index];
                int getPayload_index = 0;
                bitmapIndexedSetNode = that.contains(this.content()[getPayload_index], n, Hashing$.MODULE$.improve(n), shift) ? SetNode$.MODULE$.empty() : this;
            } else {
                int allMap = this.dataMap() | this.nodeMap();
                int minimumIndex = Integer.numberOfTrailingZeros(allMap);
                int maximumIndex = 32 - Integer.numberOfLeadingZeros(allMap);
                int oldDataPassThrough = 0;
                int nodeMigrateToDataTargetMap = 0;
                Object nodesToMigrateToData = null;
                int nodesToPassThroughMap = 0;
                int mapOfNewNodes = 0;
                Object newNodes = null;
                int newDataMap = 0;
                int newNodeMap = 0;
                int newSize = 0;
                int newCachedHashCode = 0;
                int dataIndex = 0;
                int nodeIndex = 0;
                for (int i = minimumIndex; i < maximumIndex; ++i) {
                    SetNode<Object> setNode;
                    int n = 1 << i;
                    if ((n & this.dataMap()) != 0) {
                        int hash;
                        Object object;
                        Object object2 = object = this.content()[dataIndex];
                        object = null;
                        Object payload = object2;
                        int n2 = this.originalHashes()[dataIndex];
                        if (!bitmapIndexedSetNode2.contains(payload, n2, hash = Hashing$.MODULE$.improve(n2), shift)) {
                            newDataMap |= n;
                            oldDataPassThrough |= n;
                            ++newSize;
                            newCachedHashCode += hash;
                        }
                        ++dataIndex;
                        continue;
                    }
                    if ((n & this.nodeMap()) == 0) continue;
                    SetNode<Object> oldSubNode = this.getNode(nodeIndex);
                    if ((n & bitmapIndexedSetNode2.dataMap()) != 0) {
                        Object object;
                        int n3 = Integer.bitCount(bitmapIndexedSetNode2.dataMap() & n - 1);
                        Object object3 = object = bitmapIndexedSetNode2.content()[n3];
                        object = null;
                        Object thatPayload = object3;
                        int n4 = bitmapIndexedSetNode2.originalHashes()[n3];
                        int thatHash = Hashing$.MODULE$.improve(n4);
                        setNode = oldSubNode.removed(thatPayload, n4, thatHash, shift + 5);
                    } else {
                        setNode = (n & bitmapIndexedSetNode2.nodeMap()) != 0 ? oldSubNode.diff((SetNode<Object>)bitmapIndexedSetNode2.getNode(Integer.bitCount(bitmapIndexedSetNode2.nodeMap() & n - 1)), shift + 5) : oldSubNode;
                    }
                    SetNode<Object> newSubNode = setNode;
                    newSize += newSubNode.size();
                    newCachedHashCode += newSubNode.cachedJavaKeySetHashCode();
                    if (newSubNode.size() > 1) {
                        newNodeMap |= n;
                        if (oldSubNode == newSubNode) {
                            nodesToPassThroughMap |= n;
                        } else {
                            mapOfNewNodes |= n;
                            if (newNodes == null) {
                                newNodes = Queue$.MODULE$.empty();
                            }
                            ((AbstractBuffer)newNodes).$plus$eq(newSubNode);
                        }
                    } else if (newSubNode.size() == 1) {
                        newDataMap |= n;
                        nodeMigrateToDataTargetMap |= n;
                        if (nodesToMigrateToData == null) {
                            nodesToMigrateToData = Queue$.MODULE$.empty();
                        }
                        ((AbstractBuffer)nodesToMigrateToData).$plus$eq(newSubNode);
                    }
                    ++nodeIndex;
                }
                bitmapIndexedSetNode = super.newNodeFrom(newSize, newDataMap, newNodeMap, minimumIndex, oldDataPassThrough, nodesToPassThroughMap, nodeMigrateToDataTargetMap, (Queue<SetNode<A>>)nodesToMigrateToData, mapOfNewNodes, (Queue<SetNode<A>>)newNodes, newCachedHashCode);
            }
        } else {
            if (that instanceof HashCollisionSetNode) {
                throw new RuntimeException("BitmapIndexedSetNode diff HashCollisionSetNode");
            }
            throw new MatchError(that);
        }
        BitmapIndexedSetNode bitmapIndexedSetNode3 = bitmapIndexedSetNode;
        return bitmapIndexedSetNode3;
    }

    private BitmapIndexedSetNode<A> newNodeFrom(int newSize, int newDataMap, int newNodeMap, int minimumIndex, int oldDataPassThrough, int nodesToPassThroughMap, int nodeMigrateToDataTargetMap, Queue<SetNode<A>> nodesToMigrateToData, int mapOfNewNodes, Queue<SetNode<A>> newNodes, int newCachedHashCode) {
        if (newSize == 0) {
            return SetNode$.MODULE$.empty();
        }
        if (newSize == this.size()) {
            return this;
        }
        int newDataSize = Integer.bitCount(newDataMap);
        int newContentSize = newDataSize + Integer.bitCount(newNodeMap);
        Object[] newContent = new Object[newContentSize];
        int[] newOriginalHashes = new int[newDataSize];
        int newAllMap = newDataMap | newNodeMap;
        int maxIndex = 32 - Integer.numberOfLeadingZeros(newAllMap);
        int oldDataIndex = 0;
        int oldNodeIndex = 0;
        int newDataIndex = 0;
        int newNodeIndex = 0;
        for (int i = minimumIndex; i < maxIndex; ++i) {
            int n = 1 << i;
            if ((n & oldDataPassThrough) != 0) {
                newContent[newDataIndex] = this.content()[oldDataIndex];
                newOriginalHashes[newDataIndex] = this.originalHashes()[oldDataIndex];
                ++newDataIndex;
                ++oldDataIndex;
                continue;
            }
            if ((n & nodesToPassThroughMap) != 0) {
                newContent[newContentSize - newNodeIndex - 1] = this.getNode(oldNodeIndex);
                ++newNodeIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((n & nodeMigrateToDataTargetMap) != 0) {
                SetNode<A> node = nodesToMigrateToData.dequeue();
                newContent[newDataIndex] = node.getPayload(0);
                newOriginalHashes[newDataIndex] = node.getHash(0);
                ++newDataIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((n & mapOfNewNodes) != 0) {
                newContent[newContentSize - newNodeIndex - 1] = newNodes.dequeue();
                ++newNodeIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((n & this.dataMap()) != 0) {
                ++oldDataIndex;
                continue;
            }
            if ((n & this.nodeMap()) == 0) continue;
            ++oldNodeIndex;
        }
        return new BitmapIndexedSetNode<A>(newDataMap, newNodeMap, newContent, newOriginalHashes, newSize, newCachedHashCode);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        void deepContentEquality_length;
        void deepContentEquality_a2;
        if (!(that instanceof BitmapIndexedSetNode)) return false;
        BitmapIndexedSetNode bitmapIndexedSetNode = (BitmapIndexedSetNode)that;
        if (this == bitmapIndexedSetNode) return true;
        if (this.cachedJavaKeySetHashCode() != bitmapIndexedSetNode.cachedJavaKeySetHashCode()) return false;
        if (this.nodeMap() != bitmapIndexedSetNode.nodeMap()) return false;
        if (this.dataMap() != bitmapIndexedSetNode.dataMap()) return false;
        if (this.size() != bitmapIndexedSetNode.size()) return false;
        if (!Arrays.equals(this.originalHashes(), bitmapIndexedSetNode.originalHashes())) return false;
        int n = this.content().length;
        Object[] objectArray = bitmapIndexedSetNode.content();
        Object[] deepContentEquality_a1 = this.content();
        if (deepContentEquality_a1 == deepContentEquality_a2) {
            return true;
        }
        boolean deepContentEquality_isEqual = true;
        for (int deepContentEquality_i = 0; deepContentEquality_isEqual && deepContentEquality_i < deepContentEquality_length; ++deepContentEquality_i) {
            deepContentEquality_isEqual = BoxesRunTime.equals(deepContentEquality_a1[deepContentEquality_i], deepContentEquality_a2[deepContentEquality_i]);
        }
        boolean bl = deepContentEquality_isEqual;
        Object var4_5 = null;
        objectArray = null;
        if (!bl) return false;
        return true;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Trie nodes do not support hashing.");
    }

    @Override
    public BitmapIndexedSetNode<A> copy() {
        Object[] contentClone = (Object[])this.content().clone();
        int contentLength = contentClone.length;
        for (int i = Integer.bitCount(this.dataMap()); i < contentLength; ++i) {
            contentClone[i] = ((SetNode)contentClone[i]).copy();
        }
        return new BitmapIndexedSetNode<A>(this.dataMap(), this.nodeMap(), contentClone, (int[])this.originalHashes().clone(), this.size(), this.cachedJavaKeySetHashCode());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public BitmapIndexedSetNode<A> concat(SetNode<A> that, int shift) {
        int newCachedHashCode;
        int newSize;
        int[] newOriginalHashes;
        Object[] newContent;
        int newNodeMap;
        int newDataMap;
        boolean anyChangesMadeSoFar;
        if (that instanceof BitmapIndexedSetNode) {
            BitmapIndexedSetNode bitmapIndexedSetNode = (BitmapIndexedSetNode)that;
            if (this.size() == 0) {
                return bitmapIndexedSetNode;
            }
            if (bitmapIndexedSetNode.size() == 0 || bitmapIndexedSetNode == this) {
                return this;
            }
            if (bitmapIndexedSetNode.size() == 1) {
                int originalHash = bitmapIndexedSetNode.getHash(0);
                return this.updated((Object)bitmapIndexedSetNode.getPayload(0), originalHash, Hashing$.MODULE$.improve(originalHash), shift);
            }
            anyChangesMadeSoFar = false;
            int allMap = this.dataMap() | bitmapIndexedSetNode.dataMap() | this.nodeMap() | bitmapIndexedSetNode.nodeMap();
            int minimumBitPos = Node$.MODULE$.bitposFrom(Integer.numberOfTrailingZeros(allMap));
            int maximumBitPos = Node$.MODULE$.bitposFrom(32 - Integer.numberOfLeadingZeros(allMap) - 1);
            int leftNodeRightNode = 0;
            int leftDataRightNode = 0;
            int leftNodeRightData = 0;
            int leftDataOnly = 0;
            int rightDataOnly = 0;
            int leftNodeOnly = 0;
            int rightNodeOnly = 0;
            int leftDataRightDataMigrateToNode = 0;
            int leftDataRightDataLeftOverwrites = 0;
            int dataToNodeMigrationTargets = 0;
            int bitpos = minimumBitPos;
            int leftIdx = 0;
            int rightIdx = 0;
            boolean finished = false;
            while (!finished) {
                if ((bitpos & this.dataMap()) != 0) {
                    if ((bitpos & bitmapIndexedSetNode.dataMap()) != 0) {
                        if (this.getHash(leftIdx) == bitmapIndexedSetNode.getHash(rightIdx) && BoxesRunTime.equals(this.getPayload(leftIdx), bitmapIndexedSetNode.getPayload(rightIdx))) {
                            leftDataRightDataLeftOverwrites |= bitpos;
                        } else {
                            leftDataRightDataMigrateToNode |= bitpos;
                            dataToNodeMigrationTargets |= Node$.MODULE$.bitposFrom(Node$.MODULE$.maskFrom(Hashing$.MODULE$.improve(this.getHash(leftIdx)), shift));
                        }
                        ++rightIdx;
                    } else if ((bitpos & bitmapIndexedSetNode.nodeMap()) != 0) {
                        leftDataRightNode |= bitpos;
                    } else {
                        leftDataOnly |= bitpos;
                    }
                    ++leftIdx;
                } else if ((bitpos & this.nodeMap()) != 0) {
                    if ((bitpos & bitmapIndexedSetNode.dataMap()) != 0) {
                        leftNodeRightData |= bitpos;
                        ++rightIdx;
                    } else if ((bitpos & bitmapIndexedSetNode.nodeMap()) != 0) {
                        leftNodeRightNode |= bitpos;
                    } else {
                        leftNodeOnly |= bitpos;
                    }
                } else if ((bitpos & bitmapIndexedSetNode.dataMap()) != 0) {
                    rightDataOnly |= bitpos;
                    ++rightIdx;
                } else if ((bitpos & bitmapIndexedSetNode.nodeMap()) != 0) {
                    rightNodeOnly |= bitpos;
                }
                if (bitpos == maximumBitPos) {
                    finished = true;
                    continue;
                }
                bitpos <<= 1;
            }
            newDataMap = leftDataOnly | rightDataOnly | leftDataRightDataLeftOverwrites;
            newNodeMap = leftNodeRightNode | leftDataRightNode | leftNodeRightData | leftNodeOnly | rightNodeOnly | dataToNodeMigrationTargets;
            if (newDataMap == (leftDataOnly | leftDataRightDataLeftOverwrites) && newNodeMap == leftNodeOnly) {
                return this;
            }
            int newDataSize = Integer.bitCount(newDataMap);
            int newContentSize = newDataSize + Integer.bitCount(newNodeMap);
            newContent = new Object[newContentSize];
            newOriginalHashes = new int[newDataSize];
            newSize = 0;
            newCachedHashCode = 0;
            int leftDataIdx = 0;
            int rightDataIdx = 0;
            int leftNodeIdx = 0;
            int rightNodeIdx = 0;
            int nextShift = shift + 5;
            int compressedDataIdx = 0;
            int compressedNodeIdx = 0;
            int bitpos2 = minimumBitPos;
            boolean finished2 = false;
            while (!finished2) {
                if ((bitpos2 & leftNodeRightNode) != 0) {
                    SetNode newNode;
                    Node leftNode = this.getNode(leftNodeIdx);
                    if (leftNode != (newNode = ((SetNode)leftNode).concat(bitmapIndexedSetNode.getNode(rightNodeIdx), nextShift))) {
                        anyChangesMadeSoFar = true;
                    }
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode;
                    ++compressedNodeIdx;
                    ++rightNodeIdx;
                    ++leftNodeIdx;
                    newSize += newNode.size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataRightNode) != 0) {
                    SetNode<A> newNode;
                    anyChangesMadeSoFar = true;
                    Node n = bitmapIndexedSetNode.getNode(rightNodeIdx);
                    A leftPayload = this.getPayload(leftDataIdx);
                    int leftOriginalHash = this.getHash(leftDataIdx);
                    int leftImproved = Hashing$.MODULE$.improve(leftOriginalHash);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode = ((SetNode)n).updated(leftPayload, leftOriginalHash, leftImproved, nextShift);
                    ++compressedNodeIdx;
                    ++rightNodeIdx;
                    ++leftDataIdx;
                    newSize += newNode.size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftNodeRightData) != 0) {
                    void var50_49;
                    int rightOriginalHash = bitmapIndexedSetNode.getHash(rightDataIdx);
                    Node leftNode = this.getNode(leftNodeIdx);
                    SetNode<A> updated = ((SetNode)leftNode).updated(bitmapIndexedSetNode.getPayload(rightDataIdx), bitmapIndexedSetNode.getHash(rightDataIdx), Hashing$.MODULE$.improve(rightOriginalHash), nextShift);
                    if (updated != leftNode) {
                        anyChangesMadeSoFar = true;
                    }
                    newContent[newContentSize - compressedNodeIdx - 1] = var50_49;
                    ++compressedNodeIdx;
                    ++leftNodeIdx;
                    ++rightDataIdx;
                    newSize += var50_49.size();
                    newCachedHashCode += var50_49.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataOnly) != 0) {
                    int originalHash = this.originalHashes()[leftDataIdx];
                    newContent[compressedDataIdx] = this.getPayload(leftDataIdx);
                    newOriginalHashes[compressedDataIdx] = originalHash;
                    ++compressedDataIdx;
                    ++leftDataIdx;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(originalHash);
                } else if ((bitpos2 & rightDataOnly) != 0) {
                    anyChangesMadeSoFar = true;
                    int originalHash = bitmapIndexedSetNode.originalHashes()[rightDataIdx];
                    newContent[compressedDataIdx] = bitmapIndexedSetNode.getPayload(rightDataIdx);
                    newOriginalHashes[compressedDataIdx] = originalHash;
                    ++compressedDataIdx;
                    ++rightDataIdx;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(originalHash);
                } else if ((bitpos2 & leftNodeOnly) != 0) {
                    Node newNode = this.getNode(leftNodeIdx);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode;
                    ++compressedNodeIdx;
                    ++leftNodeIdx;
                    newSize += ((SetNode)newNode).size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & rightNodeOnly) != 0) {
                    anyChangesMadeSoFar = true;
                    Node newNode = bitmapIndexedSetNode.getNode(rightNodeIdx);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode;
                    ++compressedNodeIdx;
                    ++rightNodeIdx;
                    newSize += ((SetNode)newNode).size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataRightDataMigrateToNode) != 0) {
                    SetNode<A> newNode;
                    anyChangesMadeSoFar = true;
                    int leftOriginalHash = this.getHash(leftDataIdx);
                    int rightOriginalHash = bitmapIndexedSetNode.getHash(rightDataIdx);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode = bitmapIndexedSetNode.mergeTwoKeyValPairs(this.getPayload(leftDataIdx), leftOriginalHash, Hashing$.MODULE$.improve(leftOriginalHash), bitmapIndexedSetNode.getPayload(rightDataIdx), rightOriginalHash, Hashing$.MODULE$.improve(rightOriginalHash), nextShift);
                    ++compressedNodeIdx;
                    ++leftDataIdx;
                    ++rightDataIdx;
                    newSize += newNode.size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataRightDataLeftOverwrites) != 0) {
                    int originalHash = bitmapIndexedSetNode.originalHashes()[rightDataIdx];
                    newContent[compressedDataIdx] = bitmapIndexedSetNode.getPayload(rightDataIdx);
                    newOriginalHashes[compressedDataIdx] = originalHash;
                    ++compressedDataIdx;
                    ++rightDataIdx;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(originalHash);
                    ++leftDataIdx;
                }
                if (bitpos2 == maximumBitPos) {
                    finished2 = true;
                    continue;
                }
                bitpos2 <<= 1;
            }
        } else {
            throw new UnsupportedOperationException("Cannot concatenate a HashCollisionSetNode with a BitmapIndexedSetNode");
        }
        BitmapIndexedSetNode<A> bitmapIndexedSetNode = anyChangesMadeSoFar ? new BitmapIndexedSetNode<A>(newDataMap, newNodeMap, newContent, newOriginalHashes, newSize, newCachedHashCode) : this;
        return bitmapIndexedSetNode;
    }

    @Override
    public void foreachWithHash(Function2<A, Object, BoxedUnit> f) {
        int iN = this.payloadArity();
        for (int i = 0; i < iN; ++i) {
            f.apply(this.content()[i], this.originalHashes()[i]);
        }
        int jN = this.nodeArity();
        for (int j = 0; j < jN; ++j) {
            ((SetNode)this.getNode(j)).foreachWithHash(f);
        }
    }

    public BitmapIndexedSetNode(int dataMap, int nodeMap, Object[] content, int[] originalHashes, int size, int cachedJavaKeySetHashCode) {
        this.dataMap = dataMap;
        this.nodeMap = nodeMap;
        this.content = content;
        this.originalHashes = originalHashes;
        this.size = size;
        this.cachedJavaKeySetHashCode = cachedJavaKeySetHashCode;
    }
}

