/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import py4j.CallbackClient;
import py4j.DefaultGatewayServerListener;
import py4j.Gateway;
import py4j.GatewayConnection;
import py4j.GatewayServerListener;
import py4j.NetworkUtil;
import py4j.Py4JJavaServer;
import py4j.Py4JNetworkException;
import py4j.Py4JPythonClient;
import py4j.Py4JServerConnection;
import py4j.commands.Command;

public class GatewayServer
extends DefaultGatewayServerListener
implements Runnable,
Py4JJavaServer {
    public static final Logger PY4J_LOGGER = Logger.getLogger("py4j");
    private final InetAddress address;
    private final int port;
    private int pythonPort;
    private InetAddress pythonAddress;
    private final Gateway gateway;
    private final int connectTimeout;
    private final int readTimeout;
    private final Logger logger = Logger.getLogger(GatewayServer.class.getName());
    private final List<Py4JServerConnection> connections = new ArrayList<Py4JServerConnection>();
    private final List<Class<? extends Command>> customCommands;
    private final CopyOnWriteArrayList<GatewayServerListener> listeners;
    private final ServerSocketFactory sSocketFactory;
    private ServerSocket sSocket;
    private boolean isShutdown = false;
    private boolean isShuttingDown = false;
    private final Lock lock = new ReentrantLock(true);

    public static void turnLoggingOff() {
        PY4J_LOGGER.setLevel(Level.OFF);
    }

    public static InetAddress defaultAddress() {
        try {
            return InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            throw new Py4JNetworkException(e);
        }
    }

    public GatewayServer() {
        this(null, 25333, 0, 0);
    }

    public GatewayServer(Object entryPoint, int port) {
        this(entryPoint, port, 0, 0);
    }

    public GatewayServer(Object entryPoint, int port, int connectTimeout, int readTimeout) {
        this(entryPoint, port, 25334, connectTimeout, readTimeout, null);
    }

    public GatewayServer(Object entryPoint, int port, int pythonPort, int connectTimeout, int readTimeout, List<Class<? extends Command>> customCommands) {
        this(entryPoint, port, GatewayServer.defaultAddress(), connectTimeout, readTimeout, customCommands, new CallbackClient(pythonPort, GatewayServer.defaultAddress()), ServerSocketFactory.getDefault());
    }

    public GatewayServer(Object entryPoint, int port, InetAddress address, int connectTimeout, int readTimeout, List<Class<? extends Command>> customCommands, Py4JPythonClient cbClient, ServerSocketFactory sSocketFactory) {
        this.port = port;
        this.address = address;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.gateway = new Gateway(entryPoint, cbClient);
        this.pythonPort = cbClient.getPort();
        this.pythonAddress = cbClient.getAddress();
        this.gateway.putObject("GATEWAY_SERVER", this);
        this.customCommands = customCommands != null ? customCommands : new ArrayList<Class<? extends Command>>();
        this.listeners = new CopyOnWriteArrayList();
        this.sSocketFactory = sSocketFactory;
    }

    public void addListener(GatewayServerListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    @Override
    public void connectionStopped(Py4JServerConnection gatewayConnection) {
        try {
            this.lock.lock();
            if (!this.isShutdown) {
                this.connections.remove(gatewayConnection);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Py4JServerConnection createConnection(Gateway gateway, Socket socket) throws IOException {
        GatewayConnection connection = new GatewayConnection(gateway, socket, this.customCommands, this.listeners);
        connection.startConnection();
        return connection;
    }

    protected void fireConnectionError(Exception e) {
        this.logger.log(Level.SEVERE, "Connection Server Error", e);
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.connectionError(e);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "A listener crashed.", ex);
            }
        }
    }

    protected void fireConnectionStarted(Py4JServerConnection gatewayConnection) {
        this.logger.info("Connection Started");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.connectionStarted(gatewayConnection);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void fireServerError(Exception e) {
        if (e.getMessage().contains("Socket closed")) {
            this.logger.log(Level.FINE, "Gateway Server Error", e);
        } else {
            this.logger.log(Level.SEVERE, "Gateway Server Error", e);
        }
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverError(e);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "A listener crashed.", ex);
            }
        }
    }

    protected void fireServerPostShutdown() {
        this.logger.fine("Gateway Server Post Shutdown");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverPostShutdown();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void fireServerPreShutdown() {
        this.logger.fine("Gateway Server Pre Shutdown");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverPreShutdown();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void fireServerStarted() {
        this.logger.info("Gateway Server Started");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverStarted();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void fireServerStopped() {
        this.logger.info("Gateway Server Stopped");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverStopped();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void processSocket(Socket socket) {
        try {
            this.lock.lock();
            if (!this.isShutdown) {
                socket.setSoTimeout(this.readTimeout);
                Py4JServerConnection gatewayConnection = this.createConnection(this.gateway, socket);
                this.connections.add(gatewayConnection);
                this.fireConnectionStarted(gatewayConnection);
            }
        }
        catch (Exception e) {
            this.fireConnectionError(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeListener(GatewayServerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void run() {
        try {
            this.gateway.startup();
            this.fireServerStarted();
            this.addListener(this);
            while (!this.isShutdown) {
                Socket socket = this.sSocket.accept();
                this.processSocket(socket);
            }
        }
        catch (Exception e) {
            this.fireServerError(e);
        }
        this.fireServerStopped();
        this.removeListener(this);
    }

    @Override
    public void shutdown() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean shutdownCallbackClient) {
        this.fireServerPreShutdown();
        try {
            this.lock.lock();
            if (this.isShuttingDown) {
                return;
            }
            this.isShutdown = true;
            this.isShuttingDown = true;
            NetworkUtil.quietlyClose(this.sSocket);
            ArrayList<Py4JServerConnection> tempConnections = new ArrayList<Py4JServerConnection>(this.connections);
            for (Py4JServerConnection connection : tempConnections) {
                connection.shutdown();
            }
            this.connections.clear();
            this.gateway.shutdown(shutdownCallbackClient);
        }
        finally {
            this.isShuttingDown = false;
            this.lock.unlock();
        }
        this.fireServerPostShutdown();
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean fork) {
        this.startSocket();
        if (fork) {
            Thread t = new Thread(this);
            t.start();
        } else {
            this.run();
        }
    }

    protected void startSocket() throws Py4JNetworkException {
        try {
            this.sSocket = this.sSocketFactory.createServerSocket();
            this.sSocket.setSoTimeout(this.connectTimeout);
            this.sSocket.setReuseAddress(true);
            this.sSocket.bind(new InetSocketAddress(this.address, this.port), -1);
        }
        catch (IOException e) {
            throw new Py4JNetworkException(e);
        }
    }

    static {
        GatewayServer.turnLoggingOff();
    }
}

