# generated from PeriodicTableJSON.json 2023 Jan 28. Do not hand edit
import io
from dataclasses import dataclass, field,fields
from dataclasses_json import dataclass_json
from typing import Iterable, List, Optional


@dataclass_json
@dataclass
class Element:
    name: str
    atomic: int
    symbol: str
    appearance : Optional[str]
    atomic_mass : Optional[float]
    block : Optional[str]
    bohr_model_3d : Optional[str]
    bohr_model_image : Optional[str]
    boil : Optional[float]
    category : Optional[str]
    cpk_hex : Optional[str]
    density : Optional[float]
    discovered_by : Optional[str]
    electron_affinity : Optional[float]
    electron_configuration : Optional[str]
    electron_configuration_semantic : Optional[str]
    electronegativity_pauling : Optional[float]
    group : Optional[int]
    melt : Optional[float]
    molar_heat : Optional[float]
    named_by : Optional[str]
    period : Optional[int]
    phase : Optional[str]
    source : Optional[str]
    spectral_img : Optional[str]
    summary : Optional[str]
    wxpos : Optional[int]
    wypos : Optional[int]
    xpos : Optional[int]
    ypos : Optional[int]
    _altnames : List[str] = field(default_factory=list)

    def __str__(self):
        buffer = io.StringIO()
        print(f'Element {self.name}',file=buffer)
        names = [f.name for f in fields(self) if not f.name.startswith('_') and f.name != 'name']
        nlen = max([len(n) for n in names])
        for name in names:
            print(f'    {name:{nlen}} = {getattr(self,name)}',file=buffer)
        return buffer.getvalue()

    def setnames(self,names:Iterable[str])->None: 
        self._altnames = [n.lower()  for n in names]
        
        
    def is_named(self,value)->bool:
        """Case-insensitive search of names"""
        svalue = value.lower()
        return svalue == self.name.lower() or svalue in self._altnames



class PeriodicTable:

    def __init__(self):
        self.elements =  (
            Element("""Hydrogen""",1,"""H""","""colorless gas""",1.008,"""s""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_001_hydrogen/element_001_hydrogen.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_001_hydrogen/element_001_hydrogen_srp_th.png""",20.271,"""diatomic nonmetal""","""ffffff""",0.08988,"""Henry Cavendish""",72.769,"""1s1""","""1s1""",2.2,1,13.99,28.836,"""Antoine Lavoisier""",1,"""Gas""","""https://en.wikipedia.org/wiki/Hydrogen""","""https://en.wikipedia.org/wiki/File:Hydrogen_Spectra.jpg""","""Hydrogen is a chemical element with chemical symbol H and atomic number 1. With an atomic weight of 1.00794 u, hydrogen is the lightest element on the periodic table. Its monatomic form (H) is the most abundant chemical substance in the Universe, constituting roughly 75% of all baryonic mass.""",1,1,1,1),
            Element("""Helium""",2,"""He""","""colorless gas, exhibiting a red-orange glow when placed in a high-voltage electric field""",4.0026022,"""s""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_002_helium/element_002_helium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_002_helium/element_002_helium_srp_th.png""",4.222,"""noble gas""","""d9ffff""",0.1786,"""Pierre Janssen""",-48,"""1s2""","""1s2""",None,18,0.95,None,None,1,"""Gas""","""https://en.wikipedia.org/wiki/Helium""","""https://en.wikipedia.org/wiki/File:Helium_spectrum.jpg""","""Helium is a chemical element with symbol He and atomic number 2. It is a colorless, odorless, tasteless, non-toxic, inert, monatomic gas that heads the noble gas group in the periodic table. Its boiling and melting points are the lowest among all the elements.""",32,1,18,1),
            Element("""Lithium""",3,"""Li""","""silvery-white""",6.94,"""s""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_003_lithium/element_003_lithium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_003_lithium/element_003_lithium_srp_th.png""",1603,"""alkali metal""","""cc80ff""",0.534,"""Johan August Arfwedson""",59.6326,"""1s2 2s1""","""[He] 2s1""",0.98,1,453.65,24.86,None,2,"""Solid""","""https://en.wikipedia.org/wiki/Lithium""",None,"""Lithium (from Greek:λίθος lithos, "stone") is a chemical element with the symbol Li and atomic number 3. It is a soft, silver-white metal belonging to the alkali metal group of chemical elements. Under standard conditions it is the lightest metal and the least dense solid element.""",1,2,1,2),
            Element("""Beryllium""",4,"""Be""","""white-gray metallic""",9.01218315,"""s""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_004_beryllium/element_004_beryllium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_004_beryllium/element_004_beryllium_srp_th.png""",2742,"""alkaline earth metal""","""c2ff00""",1.85,"""Louis Nicolas Vauquelin""",-48,"""1s2 2s2""","""[He] 2s2""",1.57,2,1560,16.443,None,2,"""Solid""","""https://en.wikipedia.org/wiki/Beryllium""",None,"""Beryllium is a chemical element with symbol Be and atomic number 4. It is created through stellar nucleosynthesis and is a relatively rare element in the universe. It is a divalent element which occurs naturally only in combination with other elements in minerals.""",2,2,2,2),
            Element("""Boron""",5,"""B""","""black-brown""",10.81,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_005_boron/element_005_boron.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_005_boron/element_005_boron_srp_th.png""",4200,"""metalloid""","""ffb5b5""",2.08,"""Joseph Louis Gay-Lussac""",26.989,"""1s2 2s2 2p1""","""[He] 2s2 2p1""",2.04,13,2349,11.087,None,2,"""Solid""","""https://en.wikipedia.org/wiki/Boron""",None,"""Boron is a metalloid chemical element with symbol B and atomic number 5. Produced entirely by cosmic ray spallation and supernovae and not by stellar nucleosynthesis, it is a low-abundance element in both the Solar system and the Earth's crust. Boron is concentrated on Earth by the water-solubility of its more common naturally occurring compounds, the borate minerals.""",27,2,13,2),
            Element("""Carbon""",6,"""C""",None,12.011,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_006_carbon/element_006_carbon.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_006_carbon/element_006_carbon_srp_th.png""",None,"""polyatomic nonmetal""","""909090""",1.821,"""Ancient Egypt""",121.7763,"""1s2 2s2 2p2""","""[He] 2s2 2p2""",2.55,14,None,8.517,None,2,"""Solid""","""https://en.wikipedia.org/wiki/Carbon""","""https://en.wikipedia.org/wiki/File:Carbon_Spectra.jpg""","""Carbon (from Latin:carbo "coal") is a chemical element with symbol C and atomic number 6. On the periodic table, it is the first (row 2) of six elements in column (group) 14, which have in common the composition of their outer electron shell. It is nonmetallic and tetravalent—making four electrons available to form covalent chemical bonds.""",28,2,14,2),
            Element("""Nitrogen""",7,"""N""","""colorless gas, liquid or solid""",14.007,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_007_nitrogen/element_007_nitrogen.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_007_nitrogen/element_007_nitrogen_srp_th.png""",77.355,"""diatomic nonmetal""","""3050f8""",1.251,"""Daniel Rutherford""",-6.8,"""1s2 2s2 2p3""","""[He] 2s2 2p3""",3.04,15,63.15,None,"""Jean-Antoine Chaptal""",2,"""Gas""","""https://en.wikipedia.org/wiki/Nitrogen""","""https://en.wikipedia.org/wiki/File:Nitrogen_Spectra.jpg""","""Nitrogen is a chemical element with symbol N and atomic number 7. It is the lightest pnictogen and at room temperature, it is a transparent, odorless diatomic gas. Nitrogen is a common element in the universe, estimated at about seventh in total abundance in the Milky Way and the Solar System.""",29,2,15,2),
            Element("""Oxygen""",8,"""O""",None,15.999,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_008_oxygen/element_008_oxygen.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_008_oxygen/element_008_oxygen_srp_th.png""",90.188,"""diatomic nonmetal""","""ff0d0d""",1.429,"""Carl Wilhelm Scheele""",140.976,"""1s2 2s2 2p4""","""[He] 2s2 2p4""",3.44,16,54.36,None,"""Antoine Lavoisier""",2,"""Gas""","""https://en.wikipedia.org/wiki/Oxygen""","""https://en.wikipedia.org/wiki/File:Oxygen_spectre.jpg""","""Oxygen is a chemical element with symbol O and atomic number 8. It is a member of the chalcogen group on the periodic table and is a highly reactive nonmetal and oxidizing agent that readily forms compounds (notably oxides) with most elements. By mass, oxygen is the third-most abundant element in the universe, after hydrogen and helium.""",30,2,16,2),
            Element("""Fluorine""",9,"""F""",None,18.9984031636,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_009_fluorine/element_009_fluorine.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_009_fluorine/element_009_fluorine_srp_th.png""",85.03,"""diatomic nonmetal""","""90e050""",1.696,"""André-Marie Ampère""",328.1649,"""1s2 2s2 2p5""","""[He] 2s2 2p5""",3.98,17,53.48,None,"""Humphry Davy""",2,"""Gas""","""https://en.wikipedia.org/wiki/Fluorine""",None,"""Fluorine is a chemical element with symbol F and atomic number 9. It is the lightest halogen and exists as a highly toxic pale yellow diatomic gas at standard conditions. As the most electronegative element, it is extremely reactive:almost all other elements, including some noble gases, form compounds with fluorine.""",31,2,17,2),
            Element("""Neon""",10,"""Ne""","""colorless gas exhibiting an orange-red glow when placed in a high voltage electric field""",20.17976,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_010_neon/element_010_neon.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_010_neon/element_010_neon_srp_th.png""",27.104,"""noble gas""","""b3e3f5""",0.9002,"""Morris Travers""",-116,"""1s2 2s2 2p6""","""[He] 2s2 2p6""",None,18,24.56,None,None,2,"""Gas""","""https://en.wikipedia.org/wiki/Neon""","""https://en.wikipedia.org/wiki/File:Neon_spectra.jpg""","""Neon is a chemical element with symbol Ne and atomic number 10. It is in group 18 (noble gases) of the periodic table. Neon is a colorless, odorless, inert monatomic gas under standard conditions, with about two-thirds the density of air.""",32,2,18,2),
            Element("""Sodium""",11,"""Na""","""silvery white metallic""",22.989769282,"""s""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_011_sodium/element_011_sodium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_011_sodium/element_011_sodium_srp_th.png""",1156.09,"""alkali metal""","""ab5cf2""",0.968,"""Humphry Davy""",52.867,"""1s2 2s2 2p6 3s1""","""[Ne] 3s1""",0.93,1,370.944,28.23,None,3,"""Solid""","""https://en.wikipedia.org/wiki/Sodium""","""https://en.wikipedia.org/wiki/File:Sodium_Spectra.jpg""","""Sodium /ˈsoʊdiəm/ is a chemical element with symbol Na (from Ancient Greek Νάτριο) and atomic number 11. It is a soft, silver-white, highly reactive metal. In the Periodic table it is in column 1 (alkali metals), and shares with the other six elements in that column that it has a single electron in its outer shell, which it readily donates, creating a positively charged atom - a cation.""",1,3,1,3),
            Element("""Magnesium""",12,"""Mg""","""shiny grey solid""",24.305,"""s""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_012_magnesium/element_012_magnesium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_012_magnesium/element_012_magnesium_srp_th.png""",1363,"""alkaline earth metal""","""8aff00""",1.738,"""Joseph Black""",-40,"""1s2 2s2 2p6 3s2""","""[Ne] 3s2""",1.31,2,923,24.869,None,3,"""Solid""","""https://en.wikipedia.org/wiki/Magnesium""","""https://en.wikipedia.org/wiki/File:Magnesium_Spectra.jpg""","""Magnesium is a chemical element with symbol Mg and atomic number 12. It is a shiny gray solid which bears a close physical resemblance to the other five elements in the second column (Group 2, or alkaline earth metals) of the periodic table:they each have the same electron configuration in their outer electron shell producing a similar crystal structure. Magnesium is the ninth most abundant element in the universe.""",2,3,2,3),
            Element("""Aluminium""",13,"""Al""","""silvery gray metallic""",26.98153857,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_013_aluminum/element_013_aluminum.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_013_aluminum/element_013_aluminum_srp_th.png""",2743,"""post-transition metal""","""bfa6a6""",2.7,None,41.762,"""1s2 2s2 2p6 3s2 3p1""","""[Ne] 3s2 3p1""",1.61,13,933.47,24.2,"""Humphry Davy""",3,"""Solid""","""https://en.wikipedia.org/wiki/Aluminium""",None,"""Aluminium (or aluminum; see different endings) is a chemical element in the boron group with symbol Al and atomic number 13. It is a silvery-white, soft, nonmagnetic, ductile metal. Aluminium is the third most abundant element (after oxygen and silicon), and the most abundant metal, in the Earth's crust.""",27,3,13,3),
            Element("""Silicon""",14,"""Si""","""crystalline, reflective with bluish-tinged faces""",28.085,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_014_silicon/element_014_silicon.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_014_silicon/element_014_silicon_srp_th.png""",3538,"""metalloid""","""f0c8a0""",2.329,"""Jöns Jacob Berzelius""",134.0684,"""1s2 2s2 2p6 3s2 3p2""","""[Ne] 3s2 3p2""",1.9,14,1687,19.789,"""Thomas Thomson (chemist)""",3,"""Solid""","""https://en.wikipedia.org/wiki/Silicon""","""https://en.wikipedia.org/wiki/File:Silicon_Spectra.jpg""","""Silicon is a chemical element with symbol Si and atomic number 14. It is a tetravalent metalloid, more reactive than germanium, the metalloid directly below it in the table. Controversy about silicon's character dates to its discovery.""",28,3,14,3),
            Element("""Phosphorus""",15,"""P""","""colourless, waxy white, yellow, scarlet, red, violet, black""",30.9737619985,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_015_phosphorus/element_015_phosphorus.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_015_phosphorus/element_015_phosphorus_srp_th.png""",None,"""polyatomic nonmetal""","""ff8000""",1.823,"""Hennig Brand""",72.037,"""1s2 2s2 2p6 3s2 3p3""","""[Ne] 3s2 3p3""",2.19,15,None,23.824,None,3,"""Solid""","""https://en.wikipedia.org/wiki/Phosphorus""",None,"""Phosphorus is a chemical element with symbol P and atomic number 15. As an element, phosphorus exists in two major forms—white phosphorus and red phosphorus—but due to its high reactivity, phosphorus is never found as a free element on Earth. Instead phosphorus-containing minerals are almost always present in their maximally oxidised state, as inorganic phosphate rocks.""",29,3,15,3),
            Element("""Sulfur""",16,"""S""","""lemon yellow sintered microcrystals""",32.06,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_016_sulfur/element_016_sulfur.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_016_sulfur/element_016_sulfur_srp_th.png""",717.8,"""polyatomic nonmetal""","""ffff30""",2.07,"""Ancient china""",200.4101,"""1s2 2s2 2p6 3s2 3p4""","""[Ne] 3s2 3p4""",2.58,16,388.36,22.75,None,3,"""Solid""","""https://en.wikipedia.org/wiki/Sulfur""","""https://en.wikipedia.org/wiki/File:Sulfur_Spectrum.jpg""","""Sulfur or sulphur (see spelling differences) is a chemical element with symbol S and atomic number 16. It is an abundant, multivalent non-metal. Under normal conditions, sulfur atoms form cyclic octatomic molecules with chemical formula S8.""",30,3,16,3),
            Element("""Chlorine""",17,"""Cl""","""pale yellow-green gas""",35.45,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_017_chlorine/element_017_chlorine.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_017_chlorine/element_017_chlorine_srp_th.png""",239.11,"""diatomic nonmetal""","""1ff01f""",3.2,"""Carl Wilhelm Scheele""",348.575,"""1s2 2s2 2p6 3s2 3p5""","""[Ne] 3s2 3p5""",3.16,17,171.6,None,None,3,"""Gas""","""https://en.wikipedia.org/wiki/Chlorine""","""https://en.wikipedia.org/wiki/File:Chlorine_spectrum_visible.png""","""Chlorine is a chemical element with symbol Cl and atomic number 17. It also has a relative atomic mass of 35.5. Chlorine is in the halogen group (17) and is the second lightest halogen following fluorine.""",31,3,17,3),
            Element("""Argon""",18,"""Ar""","""colorless gas exhibiting a lilac/violet glow when placed in a high voltage electric field""",39.9481,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_018_argon/element_018_argon.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_018_argon/element_018_argon_srp_th.png""",87.302,"""noble gas""","""80d1e3""",1.784,"""Lord Rayleigh""",-96,"""1s2 2s2 2p6 3s2 3p6""","""[Ne] 3s2 3p6""",None,18,83.81,None,None,3,"""Gas""","""https://en.wikipedia.org/wiki/Argon""","""https://en.wikipedia.org/wiki/File:Argon_Spectrum.png""","""Argon is a chemical element with symbol Ar and atomic number 18. It is in group 18 of the periodic table and is a noble gas. Argon is the third most common gas in the Earth's atmosphere, at 0.934% (9,340 ppmv), making it over twice as abundant as the next most common atmospheric gas, water vapor (which averages about 4000 ppmv, but varies greatly), and 23 times as abundant as the next most common non-condensing atmospheric gas, carbon dioxide (400 ppmv), and more than 500 times as abundant as the next most common noble gas, neon (18 ppmv).""",32,3,18,3),
            Element("""Potassium""",19,"""K""","""silvery gray""",39.09831,"""s""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_019_potassium/element_019_potassium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_019_potassium/element_019_potassium_srp_th.png""",1032,"""alkali metal""","""8f40d4""",0.862,"""Humphry Davy""",48.383,"""1s2 2s2 2p6 3s2 3p6 4s1""","""[Ar] 4s1""",0.82,1,336.7,29.6,None,4,"""Solid""","""https://en.wikipedia.org/wiki/Potassium""","""https://en.wikipedia.org/wiki/File:Potassium_Spectrum.jpg""","""Potassium is a chemical element with symbol K (derived from Neo-Latin, kalium) and atomic number 19. It was first isolated from potash, the ashes of plants, from which its name is derived. In the Periodic table, potassium is one of seven elements in column (group) 1 (alkali metals):they all have a single valence electron in their outer electron shell, which they readily give up to create an atom with a positive charge - a cation, and combine with anions to form salts.""",1,4,1,4),
            Element("""Calcium""",20,"""Ca""",None,40.0784,"""s""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_020_calcium/element_020_calcium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_020_calcium/element_020_calcium_srp_th.png""",1757,"""alkaline earth metal""","""3dff00""",1.55,"""Humphry Davy""",2.37,"""1s2 2s2 2p6 3s2 3p6 4s2""","""[Ar] 4s2""",1,2,1115,25.929,None,4,"""Solid""","""https://en.wikipedia.org/wiki/Calcium""","""https://en.wikipedia.org/wiki/File:Calcium_Spectrum.png""","""Calcium is a chemical element with symbol Ca and atomic number 20. Calcium is a soft gray alkaline earth metal, fifth-most-abundant element by mass in the Earth's crust. The ion Ca2+ is also the fifth-most-abundant dissolved ion in seawater by both molarity and mass, after sodium, chloride, magnesium, and sulfate.""",2,4,2,4),
            Element("""Scandium""",21,"""Sc""","""silvery white""",44.9559085,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_021_scandium/element_021_scandium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_021_scandium/element_021_scandium_srp_th.png""",3109,"""transition metal""","""e6e6e6""",2.985,"""Lars Fredrik Nilson""",18,"""1s2 2s2 2p6 3s2 3p6 4s2 3d1""","""[Ar] 3d1 4s2""",1.36,3,1814,25.52,None,4,"""Solid""","""https://en.wikipedia.org/wiki/Scandium""",None,"""Scandium is a chemical element with symbol Sc and atomic number 21. A silvery-white metallic d-block element, it has historically been sometimes classified as a rare earth element, together with yttrium and the lanthanoids. It was discovered in 1879 by spectral analysis of the minerals euxenite and gadolinite from Scandinavia.""",17,4,3,4),
            Element("""Titanium""",22,"""Ti""","""silvery grey-white metallic""",47.8671,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_022_titanium/element_022_titanium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_022_titanium/element_022_titanium_srp_th.png""",3560,"""transition metal""","""bfc2c7""",4.506,"""William Gregor""",7.289,"""1s2 2s2 2p6 3s2 3p6 4s2 3d2""","""[Ar] 3d2 4s2""",1.54,4,1941,25.06,"""Martin Heinrich Klaproth""",4,"""Solid""","""https://en.wikipedia.org/wiki/Titanium""",None,"""Titanium is a chemical element with symbol Ti and atomic number 22. It is a lustrous transition metal with a silver color, low density and high strength. It is highly resistant to corrosion in sea water, aqua regia and chlorine.""",18,4,4,4),
            Element("""Vanadium""",23,"""V""","""blue-silver-grey metal""",50.94151,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_023_vanadium/element_023_vanadium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_023_vanadium/element_023_vanadium_srp_th.png""",3680,"""transition metal""","""a6a6ab""",6,"""Andrés Manuel del Río""",50.911,"""1s2 2s2 2p6 3s2 3p6 4s2 3d3""","""[Ar] 3d3 4s2""",1.63,5,2183,24.89,"""Isotopes of vanadium""",4,"""Solid""","""https://en.wikipedia.org/wiki/Vanadium""",None,"""Vanadium is a chemical element with symbol V and atomic number 23. It is a hard, silvery grey, ductile and malleable transition metal. The element is found only in chemically combined form in nature, but once isolated artificially, the formation of an oxide layer stabilizes the free metal somewhat against further oxidation.""",19,4,5,4),
            Element("""Chromium""",24,"""Cr""","""silvery metallic""",51.99616,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_024_chromium/element_024_chromium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_024_chromium/element_024_chromium_srp_th.png""",2944,"""transition metal""","""8a99c7""",7.19,"""Louis Nicolas Vauquelin""",65.21,"""1s2 2s2 2p6 3s2 3p6 4s1 3d5""","""[Ar] 3d5 4s1""",1.66,6,2180,23.35,None,4,"""Solid""","""https://en.wikipedia.org/wiki/Chromium""",None,"""Chromium is a chemical element with symbol Cr and atomic number 24. It is the first element in Group 6. It is a steely-gray, lustrous, hard and brittle metal which takes a high polish, resists tarnishing, and has a high melting point.""",20,4,6,4),
            Element("""Manganese""",25,"""Mn""","""silvery metallic""",54.9380443,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_025_manganese/element_025_manganese.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_025_manganese/element_025_manganese_srp_th.png""",2334,"""transition metal""","""9c7ac7""",7.21,"""Torbern Olof Bergman""",-50,"""1s2 2s2 2p6 3s2 3p6 4s2 3d5""","""[Ar] 3d5 4s2""",1.55,7,1519,26.32,None,4,"""Solid""","""https://en.wikipedia.org/wiki/Manganese""",None,"""Manganese is a chemical element with symbol Mn and atomic number 25. It is not found as a free element in nature; it is often found in combination with iron, and in many minerals. Manganese is a metal with important industrial metal alloy uses, particularly in stainless steels.""",21,4,7,4),
            Element("""Iron""",26,"""Fe""","""lustrous metallic with a grayish tinge""",55.8452,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_026_iron/element_026_iron.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_026_iron/element_026_iron_srp_th.png""",3134,"""transition metal""","""e06633""",7.874,"""5000 BC""",14.785,"""1s2 2s2 2p6 3s2 3p6 4s2 3d6""","""[Ar] 3d6 4s2""",1.83,8,1811,25.1,None,4,"""Solid""","""https://en.wikipedia.org/wiki/Iron""","""https://en.wikipedia.org/wiki/File:Iron_Spectrum.jpg""","""Iron is a chemical element with symbol Fe (from Latin:ferrum) and atomic number 26. It is a metal in the first transition series. It is by mass the most common element on Earth, forming much of Earth's outer and inner core.""",22,4,8,4),
            Element("""Cobalt""",27,"""Co""","""hard lustrous gray metal""",58.9331944,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_027_cobalt/element_027_cobalt.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_027_cobalt/element_027_cobalt_srp_th.png""",3200,"""transition metal""","""f090a0""",8.9,"""Georg Brandt""",63.898,"""1s2 2s2 2p6 3s2 3p6 4s2 3d7""","""[Ar] 3d7 4s2""",1.88,9,1768,24.81,None,4,"""Solid""","""https://en.wikipedia.org/wiki/Cobalt""",None,"""Cobalt is a chemical element with symbol Co and atomic number 27. Like nickel, cobalt in the Earth's crust is found only in chemically combined form, save for small deposits found in alloys of natural meteoric iron. The free element, produced by reductive smelting, is a hard, lustrous, silver-gray metal.""",23,4,9,4),
            Element("""Nickel""",28,"""Ni""","""lustrous, metallic, and silver with a gold tinge""",58.69344,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_028_nickel/element_028_nickel.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_028_nickel/element_028_nickel_srp_th.png""",3003,"""transition metal""","""50d050""",8.908,"""Axel Fredrik Cronstedt""",111.65,"""1s2 2s2 2p6 3s2 3p6 4s2 3d8""","""[Ar] 3d8 4s2""",1.91,10,1728,26.07,None,4,"""Solid""","""https://en.wikipedia.org/wiki/Nickel""",None,"""Nickel is a chemical element with symbol Ni and atomic number 28. It is a silvery-white lustrous metal with a slight golden tinge. Nickel belongs to the transition metals and is hard and ductile.""",24,4,10,4),
            Element("""Copper""",29,"""Cu""","""red-orange metallic luster""",63.5463,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_029_copper/element_029_copper.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_029_copper/element_029_copper_srp_th.png""",2835,"""transition metal""","""c88033""",8.96,"""Middle East""",119.235,"""1s2 2s2 2p6 3s2 3p6 4s1 3d10""","""[Ar] 3d10 4s1""",1.9,11,1357.77,24.44,None,4,"""Solid""","""https://en.wikipedia.org/wiki/Copper""",None,"""Copper is a chemical element with symbol Cu (from Latin:cuprum) and atomic number 29. It is a soft, malleable and ductile metal with very high thermal and electrical conductivity. A freshly exposed surface of pure copper has a reddish-orange color.""",25,4,11,4),
            Element("""Zinc""",30,"""Zn""","""silver-gray""",65.382,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_030_zinc/element_030_zinc.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_030_zinc/element_030_zinc_srp_th.png""",1180,"""transition metal""","""7d80b0""",7.14,"""India""",-58,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10""","""[Ar] 3d10 4s2""",1.65,12,692.68,25.47,None,4,"""Solid""","""https://en.wikipedia.org/wiki/Zinc""",None,"""Zinc, in commerce also spelter, is a chemical element with symbol Zn and atomic number 30. It is the first element of group 12 of the periodic table. In some respects zinc is chemically similar to magnesium:its ion is of similar size and its only common oxidation state is +2.""",26,4,12,4),
            Element("""Gallium""",31,"""Ga""","""silver-white""",69.7231,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_031_gallium/element_031_gallium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_031_gallium/element_031_gallium_srp_th.png""",2673,"""post-transition metal""","""c28f8f""",5.91,"""Lecoq de Boisbaudran""",41,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p1""","""[Ar] 3d10 4s2 4p1""",1.81,13,302.9146,25.86,None,4,"""Solid""","""https://en.wikipedia.org/wiki/Gallium""",None,"""Gallium is a chemical element with symbol Ga and atomic number 31. Elemental gallium does not occur in free form in nature, but as the gallium(III) compounds that are in trace amounts in zinc ores and in bauxite. Gallium is a soft, silvery metal, and elemental gallium is a brittle solid at low temperatures, and melts at 29.76 °C (85.57 °F) (slightly above room temperature).""",27,4,13,4),
            Element("""Germanium""",32,"""Ge""","""grayish-white""",72.6308,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_032_germanium/element_032_germanium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_032_germanium/element_032_germanium_srp_th.png""",3106,"""metalloid""","""668f8f""",5.323,"""Clemens Winkler""",118.9352,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p2""","""[Ar] 3d10 4s2 4p2""",2.01,14,1211.4,23.222,None,4,"""Solid""","""https://en.wikipedia.org/wiki/Germanium""",None,"""Germanium is a chemical element with symbol Ge and atomic number 32. It is a lustrous, hard, grayish-white metalloid in the carbon group, chemically similar to its group neighbors tin and silicon. Purified germanium is a semiconductor, with an appearance most similar to elemental silicon.""",28,4,14,4),
            Element("""Arsenic""",33,"""As""","""metallic grey""",74.9215956,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_033_arsenic/element_033_arsenic.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_033_arsenic/element_033_arsenic_srp_th.png""",None,"""metalloid""","""bd80e3""",5.727,"""Bronze Age""",77.65,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p3""","""[Ar] 3d10 4s2 4p3""",2.18,15,None,24.64,None,4,"""Solid""","""https://en.wikipedia.org/wiki/Arsenic""",None,"""Arsenic is a chemical element with symbol As and atomic number 33. Arsenic occurs in many minerals, usually in conjunction with sulfur and metals, and also as a pure elemental crystal. Arsenic is a metalloid.""",29,4,15,4),
            Element("""Selenium""",34,"""Se""","""black, red, and gray (not pictured) allotropes""",78.9718,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_034_selenium/element_034_selenium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_034_selenium/element_034_selenium_srp_th.png""",958,"""polyatomic nonmetal""","""ffa100""",4.81,"""Jöns Jakob Berzelius""",194.9587,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p4""","""[Ar] 3d10 4s2 4p4""",2.55,16,494,25.363,None,4,"""Solid""","""https://en.wikipedia.org/wiki/Selenium""",None,"""Selenium is a chemical element with symbol Se and atomic number 34. It is a nonmetal with properties that are intermediate between those of its periodic table column-adjacent chalcogen elements sulfur and tellurium. It rarely occurs in its elemental state in nature, or as pure ore compounds.""",30,4,16,4),
            Element("""Bromine""",35,"""Br""",None,79.904,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_035_bromine/element_035_bromine.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_035_bromine/element_035_bromine_srp_th.png""",332,"""diatomic nonmetal""","""a62929""",3.1028,"""Antoine Jérôme Balard""",324.537,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p5""","""[Ar] 3d10 4s2 4p5""",2.96,17,265.8,None,None,4,"""Liquid""","""https://en.wikipedia.org/wiki/Bromine""",None,"""Bromine (from Ancient Greek:βρῶμος, brómos, meaning "stench") is a chemical element with symbol Br, and atomic number 35. It is a halogen. The element was isolated independently by two chemists, Carl Jacob Löwig and Antoine Jerome Balard, in 1825–1826.""",31,4,17,4),
            Element("""Krypton""",36,"""Kr""","""colorless gas, exhibiting a whitish glow in a high electric field""",83.7982,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_036_krypton/element_036_krypton.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_036_krypton/element_036_krypton_srp_th.png""",119.93,"""noble gas""","""5cb8d1""",3.749,"""William Ramsay""",-96,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6""","""[Ar] 3d10 4s2 4p6""",3,18,115.78,None,None,4,"""Gas""","""https://en.wikipedia.org/wiki/Krypton""","""https://en.wikipedia.org/wiki/File:Krypton_Spectrum.jpg""","""Krypton (from Greek:κρυπτός kryptos "the hidden one") is a chemical element with symbol Kr and atomic number 36. It is a member of group 18 (noble gases) elements. A colorless, odorless, tasteless noble gas, krypton occurs in trace amounts in the atmosphere, is isolated by fractionally distilling liquefied air, and is often used with other rare gases in fluorescent lamps.""",32,4,18,4),
            Element("""Rubidium""",37,"""Rb""","""grey white""",85.46783,"""s""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_037_rubidium/element_037_rubidium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_037_rubidium/element_037_rubidium_srp_th.png""",961,"""alkali metal""","""702eb0""",1.532,"""Robert Bunsen""",46.884,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s1""","""[Kr] 5s1""",0.82,1,312.45,31.06,None,5,"""Solid""","""https://en.wikipedia.org/wiki/Rubidium""",None,"""Rubidium is a chemical element with symbol Rb and atomic number 37. Rubidium is a soft, silvery-white metallic element of the alkali metal group, with an atomic mass of 85.4678. Elemental rubidium is highly reactive, with properties similar to those of other alkali metals, such as very rapid oxidation in air.""",1,5,1,5),
            Element("""Strontium""",38,"""Sr""",None,87.621,"""s""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_038_strontium/element_038_strontium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_038_strontium/element_038_strontium_srp_th.png""",1650,"""alkaline earth metal""","""00ff00""",2.64,"""William Cruickshank (chemist)""",5.023,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2""","""[Kr] 5s2""",0.95,2,1050,26.4,None,5,"""Solid""","""https://en.wikipedia.org/wiki/Strontium""",None,"""Strontium is a chemical element with symbol Sr and atomic number 38. An alkaline earth metal, strontium is a soft silver-white or yellowish metallic element that is highly reactive chemically. The metal turns yellow when it is exposed to air.""",2,5,2,5),
            Element("""Yttrium""",39,"""Y""","""silvery white""",88.905842,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_039_yttrium/element_039_yttrium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_039_yttrium/element_039_yttrium_srp_th.png""",3203,"""transition metal""","""94ffff""",4.472,"""Johan Gadolin""",29.6,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d1""","""[Kr] 4d1 5s2""",1.22,3,1799,26.53,None,5,"""Solid""","""https://en.wikipedia.org/wiki/Yttrium""",None,"""Yttrium is a chemical element with symbol Y and atomic number 39. It is a silvery-metallic transition metal chemically similar to the lanthanides and it has often been classified as a "rare earth element". Yttrium is almost always found combined with the lanthanides in rare earth minerals and is never found in nature as a free element.""",17,5,3,5),
            Element("""Zirconium""",40,"""Zr""","""silvery white""",91.2242,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_040_zirconium/element_040_zirconium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_040_zirconium/element_040_zirconium_srp_th.png""",4650,"""transition metal""","""94e0e0""",6.52,"""Martin Heinrich Klaproth""",41.806,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d2""","""[Kr] 4d2 5s2""",1.33,4,2128,25.36,None,5,"""Solid""","""https://en.wikipedia.org/wiki/Zirconium""",None,"""Zirconium is a chemical element with symbol Zr and atomic number 40. The name of zirconium is taken from the name of the mineral zircon, the most important source of zirconium. The word zircon comes from the Persian word zargun زرگون, meaning "gold-colored".""",18,5,4,5),
            Element("""Niobium""",41,"""Nb""","""gray metallic, bluish when oxidized""",92.906372,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_041_niobium/element_041_niobium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_041_niobium/element_041_niobium_srp_th.png""",5017,"""transition metal""","""73c2c9""",8.57,"""Charles Hatchett""",88.516,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s1 4d4""","""[Kr] 4d4 5s1""",1.6,5,2750,24.6,None,5,"""Solid""","""https://en.wikipedia.org/wiki/Niobium""",None,"""Niobium, formerly columbium, is a chemical element with symbol Nb (formerly Cb) and atomic number 41. It is a soft, grey, ductile transition metal, which is often found in the pyrochlore mineral, the main commercial source for niobium, and columbite. The name comes from Greek mythology:Niobe, daughter of Tantalus since it is so similar to tantalum.""",19,5,5,5),
            Element("""Molybdenum""",42,"""Mo""","""gray metallic""",95.951,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_042_molybdenum/element_042_molybdenum.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_042_molybdenum/element_042_molybdenum_srp_th.png""",4912,"""transition metal""","""54b5b5""",10.28,"""Carl Wilhelm Scheele""",72.1,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s1 4d5""","""[Kr] 4d5 5s1""",2.16,6,2896,24.06,None,5,"""Solid""","""https://en.wikipedia.org/wiki/Molybdenum""",None,"""Molybdenum is a chemical element with symbol Mo and atomic number 42. The name is from Neo-Latin molybdaenum, from Ancient Greek Μόλυβδος molybdos, meaning lead, since its ores were confused with lead ores. Molybdenum minerals have been known throughout history, but the element was discovered (in the sense of differentiating it as a new entity from the mineral salts of other metals) in 1778 by Carl Wilhelm Scheele.""",20,5,6,5),
            Element("""Technetium""",43,"""Tc""","""shiny gray metal""",98,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_043_technetium/element_043_technetium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_043_technetium/element_043_technetium_srp_th.png""",4538,"""transition metal""","""3b9e9e""",11,"""Emilio Segrè""",53,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d5""","""[Kr] 4d5 5s2""",1.9,7,2430,24.27,None,5,"""Solid""","""https://en.wikipedia.org/wiki/Technetium""",None,"""Technetium (/tɛkˈniːʃiəm/) is a chemical element with symbol Tc and atomic number 43. It is the element with the lowest atomic number in the periodic table that has no stable isotopes:every form of it is radioactive. Nearly all technetium is produced synthetically, and only minute amounts are found in nature.""",21,5,7,5),
            Element("""Ruthenium""",44,"""Ru""","""silvery white metallic""",101.072,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_044_ruthenium/element_044_ruthenium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_044_ruthenium/element_044_ruthenium_srp_th.png""",4423,"""transition metal""","""248f8f""",12.45,"""Karl Ernst Claus""",100.96,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s1 4d7""","""[Kr] 4d7 5s1""",2.2,8,2607,24.06,None,5,"""Solid""","""https://en.wikipedia.org/wiki/Ruthenium""",None,"""Ruthenium is a chemical element with symbol Ru and atomic number 44. It is a rare transition metal belonging to the platinum group of the periodic table. Like the other metals of the platinum group, ruthenium is inert to most other chemicals.""",22,5,8,5),
            Element("""Rhodium""",45,"""Rh""","""silvery white metallic""",102.905502,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_045_rhodium/element_045_rhodium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_045_rhodium/element_045_rhodium_srp_th.png""",3968,"""transition metal""","""0a7d8c""",12.41,"""William Hyde Wollaston""",110.27,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s1 4d8""","""[Kr] 4d8 5s1""",2.28,9,2237,24.98,None,5,"""Solid""","""https://en.wikipedia.org/wiki/Rhodium""",None,"""Rhodium is a chemical element with symbol Rh and atomic number 45. It is a rare, silvery-white, hard, and chemically inert transition metal. It is a member of the platinum group.""",23,5,9,5),
            Element("""Palladium""",46,"""Pd""","""silvery white""",106.421,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_046_palladium/element_046_palladium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_046_palladium/element_046_palladium_srp_th.png""",3236,"""transition metal""","""006985""",12.023,"""William Hyde Wollaston""",54.24,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 4d10""","""[Kr] 4d10""",2.2,10,1828.05,25.98,None,5,"""Solid""","""https://en.wikipedia.org/wiki/Palladium""",None,"""Palladium is a chemical element with symbol Pd and atomic number 46. It is a rare and lustrous silvery-white metal discovered in 1803 by William Hyde Wollaston. He named it after the asteroid Pallas, which was itself named after the epithet of the Greek goddess Athena, acquired by her when she slew Pallas.""",24,5,10,5),
            Element("""Silver""",47,"""Ag""","""lustrous white metal""",107.86822,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_047_silver/element_047_silver.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_047_silver/element_047_silver_srp_th.png""",2435,"""transition metal""","""c0c0c0""",10.49,"""unknown, before 5000 BC""",125.862,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s1 4d10""","""[Kr] 4d10 5s1""",1.93,11,1234.93,25.35,None,5,"""Solid""","""https://en.wikipedia.org/wiki/Silver""",None,"""Silver is a chemical element with symbol Ag (Greek:άργυρος árguros, Latin:argentum, both from the Indo-European root *h₂erǵ- for "grey" or "shining") and atomic number 47. A soft, white, lustrous transition metal, it possesses the highest electrical conductivity, thermal conductivity and reflectivity of any metal. The metal occurs naturally in its pure, free form (native silver), as an alloy with gold and other metals, and in minerals such as argentite and chlorargyrite.""",25,5,11,5),
            Element("""Cadmium""",48,"""Cd""","""silvery bluish-gray metallic""",112.4144,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_048_cadmium/element_048_cadmium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_048_cadmium/element_048_cadmium_srp_th.png""",1040,"""transition metal""","""ffd98f""",8.65,"""Karl Samuel Leberecht Hermann""",-68,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10""","""[Kr] 4d10 5s2""",1.69,12,594.22,26.02,"""Isotopes of cadmium""",5,"""Solid""","""https://en.wikipedia.org/wiki/Cadmium""",None,"""Cadmium is a chemical element with symbol Cd and atomic number 48. This soft, bluish-white metal is chemically similar to the two other stable metals in group 12, zinc and mercury. Like zinc, it prefers oxidation state +2 in most of its compounds and like mercury it shows a low melting point compared to transition metals.""",26,5,12,5),
            Element("""Indium""",49,"""In""","""silvery lustrous gray""",114.8181,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_049_indium/element_049_indium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_049_indium/element_049_indium_srp_th.png""",2345,"""post-transition metal""","""a67573""",7.31,"""Ferdinand Reich""",37.043,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p1""","""[Kr] 4d10 5s2 5p1""",1.78,13,429.7485,26.74,None,5,"""Solid""","""https://en.wikipedia.org/wiki/Indium""",None,"""Indium is a chemical element with symbol In and atomic number 49. It is a post-transition metallic element that is rare in Earth's crust. The metal is very soft, malleable and easily fusible, with a melting point higher than sodium, but lower than lithium or tin.""",27,5,13,5),
            Element("""Tin""",50,"""Sn""","""silvery-white (beta, β) or gray (alpha, α)""",118.7107,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_050_tin/element_050_tin.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_050_tin/element_050_tin_srp_th.png""",2875,"""post-transition metal""","""668080""",7.365,"""unknown, before 3500 BC""",107.2984,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p2""","""[Kr] 4d10 5s2 5p2""",1.96,14,505.08,27.112,None,5,"""Solid""","""https://en.wikipedia.org/wiki/Tin""",None,"""Tin is a chemical element with the symbol Sn (for Latin:stannum) and atomic number 50. It is a main group metal in group 14 of the periodic table. Tin shows a chemical similarity to both neighboring group-14 elements, germanium and lead, and has two possible oxidation states, +2 and the slightly more stable +4.""",28,5,14,5),
            Element("""Antimony""",51,"""Sb""","""silvery lustrous gray""",121.7601,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_051_antimony/element_051_antimony.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_051_antimony/element_051_antimony_srp_th.png""",1908,"""metalloid""","""9e63b5""",6.697,"""unknown, before 3000 BC""",101.059,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p3""","""[Kr] 4d10 5s2 5p3""",2.05,15,903.78,25.23,None,5,"""Solid""","""https://en.wikipedia.org/wiki/Antimony""",None,"""Antimony is a chemical element with symbol Sb (from Latin:stibium) and atomic number 51. A lustrous gray metalloid, it is found in nature mainly as the sulfide mineral stibnite (Sb2S3). Antimony compounds have been known since ancient times and were used for cosmetics; metallic antimony was also known, but it was erroneously identified as lead upon its discovery.""",29,5,15,5),
            Element("""Tellurium""",52,"""Te""",None,127.603,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_052_tellurium/element_052_tellurium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_052_tellurium/element_052_tellurium_srp_th.png""",1261,"""metalloid""","""d47a00""",6.24,"""Franz-Joseph Müller von Reichenstein""",190.161,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p4""","""[Kr] 4d10 5s2 5p4""",2.1,16,722.66,25.73,None,5,"""Solid""","""https://en.wikipedia.org/wiki/Tellurium""",None,"""Tellurium is a chemical element with symbol Te and atomic number 52. It is a brittle, mildly toxic, rare, silver-white metalloid. Tellurium is chemically related to selenium and sulfur.""",30,5,16,5),
            Element("""Iodine""",53,"""I""","""lustrous metallic gray, violet as a gas""",126.904473,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_053_iodine/element_053_iodine.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_053_iodine/element_053_iodine_srp_th.png""",457.4,"""diatomic nonmetal""","""940094""",4.933,"""Bernard Courtois""",295.1531,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p5""","""[Kr] 4d10 5s2 5p5""",2.66,17,386.85,None,None,5,"""Solid""","""https://en.wikipedia.org/wiki/Iodine""",None,"""Iodine is a chemical element with symbol I and atomic number 53. The name is from Greek ἰοειδής ioeidēs, meaning violet or purple, due to the color of iodine vapor. Iodine and its compounds are primarily used in nutrition, and industrially in the production of acetic acid and certain polymers.""",31,5,17,5),
            Element("""Xenon""",54,"""Xe""","""colorless gas, exhibiting a blue glow when placed in a high voltage electric field""",131.2936,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_054_xenon/element_054_xenon.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_054_xenon/element_054_xenon_srp_th.png""",165.051,"""noble gas""","""429eb0""",5.894,"""William Ramsay""",-77,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6""","""[Kr] 4d10 5s2 5p6""",2.6,18,161.4,None,None,5,"""Gas""","""https://en.wikipedia.org/wiki/Xenon""","""https://en.wikipedia.org/wiki/File:Xenon_Spectrum.jpg""","""Xenon is a chemical element with symbol Xe and atomic number 54. It is a colorless, dense, odorless noble gas, that occurs in the Earth's atmosphere in trace amounts. Although generally unreactive, xenon can undergo a few chemical reactions such as the formation of xenon hexafluoroplatinate, the first noble gas compound to be synthesized.""",32,5,18,5),
            Element("""Cesium""",55,"""Cs""","""silvery gold""",132.905451966,"""s""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_055_cesium/element_055_cesium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_055_cesium/element_055_cesium_srp_th.png""",944,"""alkali metal""","""57178f""",1.93,"""Robert Bunsen""",45.505,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s1""","""[Xe] 6s1""",0.79,1,301.7,32.21,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Cesium""",None,"""Caesium or cesium is a chemical element with symbol Cs and atomic number 55. It is a soft, silvery-gold alkali metal with a melting point of 28 °C (82 °F), which makes it one of only five elemental metals that are liquid at or near room temperature. Caesium is an alkali metal and has physical and chemical properties similar to those of rubidium and potassium.""",1,6,1,6),
            Element("""Barium""",56,"""Ba""",None,137.3277,"""s""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_056_barium/element_056_barium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_056_barium/element_056_barium_srp_th.png""",2118,"""alkaline earth metal""","""00c900""",3.51,"""Carl Wilhelm Scheele""",13.954,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2""","""[Xe] 6s2""",0.89,2,1000,28.07,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Barium""",None,"""Barium is a chemical element with symbol Ba and atomic number 56. It is the fifth element in Group 2, a soft silvery metallic alkaline earth metal. Because of its high chemical reactivity barium is never found in nature as a free element.""",2,6,2,6),
            Element("""Lanthanum""",57,"""La""","""silvery white""",138.905477,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_057_lanthanum/element_057_lanthanum.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_057_lanthanum/element_057_lanthanum_srp_th.png""",3737,"""lanthanide""","""70d4ff""",6.162,"""Carl Gustaf Mosander""",53,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 5d1""","""[Xe] 5d16s2""",1.1,3,1193,27.11,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Lanthanum""",None,"""Lanthanum is a soft, ductile, silvery-white metallic chemical element with symbol La and atomic number 57. It tarnishes rapidly when exposed to air and is soft enough to be cut with a knife. It gave its name to the lanthanide series, a group of 15 similar elements between lanthanum and lutetium in the periodic table:it is also sometimes considered the first element of the 6th-period transition metals.""",3,6,3,9),
            Element("""Cerium""",58,"""Ce""","""silvery white""",140.1161,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_058_cerium/element_058_cerium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_058_cerium/element_058_cerium_srp_th.png""",3716,"""lanthanide""","""ffffc7""",6.77,"""Martin Heinrich Klaproth""",55,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 5d1 4f1""","""[Xe] 4f1 5d1 6s2""",1.12,3,1068,26.94,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Cerium""",None,"""Cerium is a chemical element with symbol Ce and atomic number 58. It is a soft, silvery, ductile metal which easily oxidizes in air. Cerium was named after the dwarf planet Ceres (itself named after the Roman goddess of agriculture).""",4,6,4,9),
            Element("""Praseodymium""",59,"""Pr""","""grayish white""",140.907662,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_059_praseodymium/element_059_praseodymium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_059_praseodymium/element_059_praseodymium_srp_th.png""",3403,"""lanthanide""","""d9ffc7""",6.77,"""Carl Auer von Welsbach""",93,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f3""","""[Xe] 4f3 6s2""",1.13,3,1208,27.2,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Praseodymium""",None,"""Praseodymium is a chemical element with symbol Pr and atomic number 59. Praseodymium is a soft, silvery, malleable and ductile metal in the lanthanide group. It is valued for its magnetic, electrical, chemical, and optical properties.""",5,6,5,9),
            Element("""Neodymium""",60,"""Nd""","""silvery white""",144.2423,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_060_neodymium/element_060_neodymium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_060_neodymium/element_060_neodymium_srp_th.png""",3347,"""lanthanide""","""c7ffc7""",7.01,"""Carl Auer von Welsbach""",184.87,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f4""","""[Xe] 4f4 6s2""",1.14,3,1297,27.45,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Neodymium""",None,"""Neodymium is a chemical element with symbol Nd and atomic number 60. It is a soft silvery metal that tarnishes in air. Neodymium was discovered in 1885 by the Austrian chemist Carl Auer von Welsbach.""",6,6,6,9),
            Element("""Promethium""",61,"""Pm""","""metallic""",145,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_061_promethium/element_061_promethium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_061_promethium/element_061_promethium_srp_th.png""",3273,"""lanthanide""","""a3ffc7""",7.26,"""Chien Shiung Wu""",12.45,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f5""","""[Xe] 4f5 6s2""",1.13,3,1315,None,"""Isotopes of promethium""",6,"""Solid""","""https://en.wikipedia.org/wiki/Promethium""",None,"""Promethium, originally prometheum, is a chemical element with the symbol Pm and atomic number 61. All of its isotopes are radioactive; it is one of only two such elements that are followed in the periodic table by elements with stable forms, a distinction shared with technetium. Chemically, promethium is a lanthanide, which forms salts when combined with other elements.""",7,6,7,9),
            Element("""Samarium""",62,"""Sm""","""silvery white""",150.362,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_062_samarium/element_062_samarium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_062_samarium/element_062_samarium_srp_th.png""",2173,"""lanthanide""","""8fffc7""",7.52,"""Lecoq de Boisbaudran""",15.63,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f6""","""[Xe] 4f6 6s2""",1.17,3,1345,29.54,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Samarium""",None,"""Samarium is a chemical element with symbol Sm and atomic number 62. It is a moderately hard silvery metal that readily oxidizes in air. Being a typical member of the lanthanide series, samarium usually assumes the oxidation state +3.""",8,6,8,9),
            Element("""Europium""",63,"""Eu""",None,151.9641,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_063_europium/element_063_europium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_063_europium/element_063_europium_srp_th.png""",1802,"""lanthanide""","""61ffc7""",5.264,"""Eugène-Anatole Demarçay""",11.2,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f7""","""[Xe] 4f7 6s2""",1.2,3,1099,27.66,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Europium""",None,"""Europium is a chemical element with symbol Eu and atomic number 63. It was isolated in 1901 and is named after the continent of Europe. It is a moderately hard, silvery metal which readily oxidizes in air and water.""",9,6,9,9),
            Element("""Gadolinium""",64,"""Gd""","""silvery white""",157.253,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_064_gadolinium/element_064_gadolinium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_064_gadolinium/element_064_gadolinium_srp_th.png""",3273,"""lanthanide""","""45ffc7""",7.9,"""Jean Charles Galissard de Marignac""",13.22,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f7 5d1""","""[Xe] 4f7 5d1 6s2""",1.2,3,1585,37.03,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Gadolinium""",None,"""Gadolinium is a chemical element with symbol Gd and atomic number 64. It is a silvery-white, malleable and ductile rare-earth metal. It is found in nature only in combined (salt) form.""",10,6,10,9),
            Element("""Terbium""",65,"""Tb""","""silvery white""",158.925352,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_065_terbium/element_065_terbium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_065_terbium/element_065_terbium_srp_th.png""",3396,"""lanthanide""","""30ffc7""",8.23,"""Carl Gustaf Mosander""",112.4,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f9""","""[Xe] 4f9 6s2""",1.1,3,1629,28.91,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Terbium""",None,"""Terbium is a chemical element with symbol Tb and atomic number 65. It is a silvery-white rare earth metal that is malleable, ductile and soft enough to be cut with a knife. Terbium is never found in nature as a free element, but it is contained in many minerals, including cerite, gadolinite, monazite, xenotime and euxenite.""",11,6,11,9),
            Element("""Dysprosium""",66,"""Dy""","""silvery white""",162.5001,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_066_dysprosium/element_066_dysprosium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_066_dysprosium/element_066_dysprosium_srp_th.png""",2840,"""lanthanide""","""1fffc7""",8.54,"""Lecoq de Boisbaudran""",33.96,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f10""","""[Xe] 4f10 6s2""",1.22,3,1680,27.7,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Dysprosium""",None,"""Dysprosium is a chemical element with the symbol Dy and atomic number 66. It is a rare earth element with a metallic silver luster. Dysprosium is never found in nature as a free element, though it is found in various minerals, such as xenotime.""",12,6,12,9),
            Element("""Holmium""",67,"""Ho""","""silvery white""",164.930332,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_067_holmium/element_067_holmium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_067_holmium/element_067_holmium_srp_th.png""",2873,"""lanthanide""","""00ff9c""",8.79,"""Marc Delafontaine""",32.61,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f11""","""[Xe] 4f11 6s2""",1.23,3,1734,27.15,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Holmium""",None,"""Holmium is a chemical element with symbol Ho and atomic number 67. Part of the lanthanide series, holmium is a rare earth element. Holmium was discovered by Swedish chemist Per Theodor Cleve.""",13,6,13,9),
            Element("""Erbium""",68,"""Er""","""silvery white""",167.2593,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_068_erbium/element_068_erbium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_068_erbium/element_068_erbium_srp_th.png""",3141,"""lanthanide""","""00e675""",9.066,"""Carl Gustaf Mosander""",30.1,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f12""","""[Xe] 4f12 6s2""",1.24,3,1802,28.12,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Erbium""",None,"""Erbium is a chemical element in the lanthanide series, with symbol Er and atomic number 68. A silvery-white solid metal when artificially isolated, natural erbium is always found in chemical combination with other elements on Earth. As such, it is a rare earth element which is associated with several other rare elements in the mineral gadolinite from Ytterby in Sweden, where yttrium, ytterbium, and terbium were discovered.""",14,6,14,9),
            Element("""Thulium""",69,"""Tm""","""silvery gray""",168.934222,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_069_thulium/element_069_thulium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_069_thulium/element_069_thulium_srp_th.png""",2223,"""lanthanide""","""00d452""",9.32,"""Per Teodor Cleve""",99,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f13""","""[Xe] 4f13 6s2""",1.25,3,1818,27.03,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Thulium""",None,"""Thulium is a chemical element with symbol Tm and atomic number 69. It is the thirteenth and antepenultimate (third-last) element in the lanthanide series. Like the other lanthanides, the most common oxidation state is +3, seen in its oxide, halides and other compounds.""",15,6,15,9),
            Element("""Ytterbium""",70,"""Yb""",None,173.0451,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_070_ytterbium/element_070_ytterbium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_070_ytterbium/element_070_ytterbium_srp_th.png""",1469,"""lanthanide""","""00bf38""",6.9,"""Jean Charles Galissard de Marignac""",-1.93,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14""","""[Xe] 4f14 6s2""",1.1,3,1097,26.74,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Ytterbium""",None,"""Ytterbium is a chemical element with symbol Yb and atomic number 70. It is the fourteenth and penultimate element in the lanthanide series, which is the basis of the relative stability of its +2 oxidation state. However, like the other lanthanides, its most common oxidation state is +3, seen in its oxide, halides and other compounds.""",16,6,16,9),
            Element("""Lutetium""",71,"""Lu""","""silvery white""",174.96681,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_071_lutetium/element_071_lutetium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_071_lutetium/element_071_lutetium_srp_th.png""",3675,"""lanthanide""","""00ab24""",9.841,"""Georges Urbain""",33.4,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d1""","""[Xe] 4f14 5d1 6s2""",1.27,3,1925,26.86,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Lutetium""",None,"""Lutetium is a chemical element with symbol Lu and atomic number 71. It is a silvery white metal, which resists corrosion in dry, but not in moist air. It is considered the first element of the 6th-period transition metals and the last element in the lanthanide series, and is traditionally counted among the rare earths.""",17,6,17,9),
            Element("""Hafnium""",72,"""Hf""","""steel gray""",178.492,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_072_hafnium/element_072_hafnium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_072_hafnium/element_072_hafnium_srp_th.png""",4876,"""transition metal""","""4dc2ff""",13.31,"""Dirk Coster""",17.18,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d2""","""[Xe] 4f14 5d2 6s2""",1.3,4,2506,25.73,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Hafnium""","""https://en.wikipedia.org/wiki/File:Hafnium_spectrum_visible.png""","""Hafnium is a chemical element with symbol Hf and atomic number 72. A lustrous, silvery gray, tetravalent transition metal, hafnium chemically resembles zirconium and is found in zirconium minerals. Its existence was predicted by Dmitri Mendeleev in 1869, though it was not identified until 1923, making it the penultimate stable element to be discovered (rhenium was identified two years later).""",18,6,4,6),
            Element("""Tantalum""",73,"""Ta""","""gray blue""",180.947882,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_073_tantalum/element_073_tantalum.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_073_tantalum/element_073_tantalum_srp_th.png""",5731,"""transition metal""","""4da6ff""",16.69,"""Anders Gustaf Ekeberg""",31,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d3""","""[Xe] 4f14 5d3 6s2""",1.5,5,3290,25.36,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Tantalum""","""https://en.wikipedia.org/wiki/File:Tantalum_spectrum_visible.png""","""Tantalum is a chemical element with symbol Ta and atomic number 73. Previously known as tantalium, its name comes from Tantalus, an antihero from Greek mythology. Tantalum is a rare, hard, blue-gray, lustrous transition metal that is highly corrosion-resistant.""",19,6,5,6),
            Element("""Tungsten""",74,"""W""","""grayish white, lustrous""",183.841,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_074_tungsten/element_074_tungsten.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_074_tungsten/element_074_tungsten_srp_th.png""",6203,"""transition metal""","""2194d6""",19.25,"""Carl Wilhelm Scheele""",78.76,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d4""","""[Xe] 4f14 5d4 6s2""",2.36,6,3695,24.27,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Tungsten""",None,"""Tungsten, also known as wolfram, is a chemical element with symbol W and atomic number 74. The word tungsten comes from the Swedish language tung sten, which directly translates to heavy stone. Its name in Swedish is volfram, however, in order to distinguish it from scheelite, which in Swedish is alternatively named tungsten.""",20,6,6,6),
            Element("""Rhenium""",75,"""Re""","""silvery-grayish""",186.2071,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_075_rhenium/element_075_rhenium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_075_rhenium/element_075_rhenium_srp_th.png""",5869,"""transition metal""","""267dab""",21.02,"""Masataka Ogawa""",5.8273,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d5""","""[Xe] 4f14 5d5 6s2""",1.9,7,3459,25.48,"""Walter Noddack""",6,"""Solid""","""https://en.wikipedia.org/wiki/Rhenium""",None,"""Rhenium is a chemical element with symbol Re and atomic number 75. It is a silvery-white, heavy, third-row transition metal in group 7 of the periodic table. With an estimated average concentration of 1 part per billion (ppb), rhenium is one of the rarest elements in the Earth's crust.""",21,6,7,6),
            Element("""Osmium""",76,"""Os""","""silvery, blue cast""",190.233,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_076_osmium/element_076_osmium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_076_osmium/element_076_osmium_srp_th.png""",5285,"""transition metal""","""266696""",22.59,"""Smithson Tennant""",103.99,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d6""","""[Xe] 4f14 5d6 6s2""",2.2,8,3306,24.7,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Osmium""",None,"""Osmium (from Greek osme (ὀσμή) meaning "smell") is a chemical element with symbol Os and atomic number 76. It is a hard, brittle, bluish-white transition metal in the platinum group that is found as a trace element in alloys, mostly in platinum ores. Osmium is the densest naturally occurring element, with a density of 22.59 g/cm3.""",22,6,8,6),
            Element("""Iridium""",77,"""Ir""","""silvery white""",192.2173,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_077_iridium/element_077_iridium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_077_iridium/element_077_iridium_srp_th.png""",4403,"""transition metal""","""175487""",22.56,"""Smithson Tennant""",150.94,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d7""","""[Xe] 4f14 5d7 6s2""",2.2,9,2719,25.1,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Iridium""",None,"""Iridium is a chemical element with symbol Ir and atomic number 77. A very hard, brittle, silvery-white transition metal of the platinum group, iridium is generally credited with being the second densest element (after osmium) based on measured density, although calculations involving the space lattices of the elements show that iridium is denser. It is also the most corrosion-resistant metal, even at temperatures as high as 2000 °C. Although only certain molten salts and halogens are corrosive to solid iridium, finely divided iridium dust is much more reactive and can be flammable.""",23,6,9,6),
            Element("""Platinum""",78,"""Pt""","""silvery white""",195.0849,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_078_platinum/element_078_platinum.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_078_platinum/element_078_platinum_srp_th.png""",4098,"""transition metal""","""d0d0e0""",21.45,"""Antonio de Ulloa""",205.041,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s1 4f14 5d9""","""[Xe] 4f14 5d9 6s1""",2.28,10,2041.4,25.86,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Platinum""",None,"""Platinum is a chemical element with symbol Pt and atomic number 78. It is a dense, malleable, ductile, highly unreactive, precious, gray-white transition metal. Its name is derived from the Spanish term platina, which is literally translated into "little silver".""",24,6,10,6),
            Element("""Gold""",79,"""Au""","""metallic yellow""",196.9665695,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_079_gold/element_079_gold.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_079_gold/element_079_gold_srp_th.png""",3243,"""transition metal""","""ffd123""",19.3,"""Middle East""",222.747,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s1 4f14 5d10""","""[Xe] 4f14 5d10 6s1""",2.54,11,1337.33,25.418,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Gold""",None,"""Gold is a chemical element with symbol Au (from Latin:aurum) and atomic number 79. In its purest form, it is a bright, slightly reddish yellow, dense, soft, malleable and ductile metal. Chemically, gold is a transition metal and a group 11 element.""",25,6,11,6),
            Element("""Mercury""",80,"""Hg""","""silvery""",200.5923,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_080_mercury/element_080_mercury.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_080_mercury/element_080_mercury_srp_th.png""",629.88,"""transition metal""","""b8b8d0""",13.534,"""unknown, before 2000 BCE""",-48,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10""","""[Xe] 4f14 5d10 6s2""",2,12,234.321,27.983,None,6,"""Liquid""","""https://en.wikipedia.org/wiki/Mercury (Element)""",None,"""Mercury is a chemical element with symbol Hg and atomic number 80. It is commonly known as quicksilver and was formerly named hydrargyrum (/haɪˈdrɑːrdʒərəm/). A heavy, silvery d-block element, mercury is the only metallic element that is liquid at standard conditions for temperature and pressure; the only other element that is liquid under these conditions is bromine, though metals such as caesium, gallium, and rubidium melt just above room temperature.""",26,6,12,6),
            Element("""Thallium""",81,"""Tl""","""silvery white""",204.38,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_081_thallium/element_081_thallium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_081_thallium/element_081_thallium_srp_th.png""",1746,"""post-transition metal""","""a6544d""",11.85,"""William Crookes""",36.4,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p1""","""[Xe] 4f14 5d10 6s2 6p1""",1.62,13,577,26.32,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Thallium""",None,"""Thallium is a chemical element with symbol Tl and atomic number 81. This soft gray post-transition metal is not found free in nature. When isolated, it resembles tin, but discolors when exposed to air.""",27,6,13,6),
            Element("""Lead""",82,"""Pb""","""metallic gray""",207.21,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_082_lead/element_082_lead.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_082_lead/element_082_lead_srp_th.png""",2022,"""post-transition metal""","""575961""",11.34,"""Middle East""",34.4204,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p2""","""[Xe] 4f14 5d10 6s2 6p2""",1.87,14,600.61,26.65,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Lead_(element)""",None,"""Lead (/lɛd/) is a chemical element in the carbon group with symbol Pb (from Latin:plumbum) and atomic number 82. Lead is a soft, malleable and heavy post-transition metal. Metallic lead has a bluish-white color after being freshly cut, but it soon tarnishes to a dull grayish color when exposed to air.""",28,6,14,6),
            Element("""Bismuth""",83,"""Bi""","""lustrous silver""",208.980401,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_083_bismuth/element_083_bismuth.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_083_bismuth/element_083_bismuth_srp_th.png""",1837,"""post-transition metal""","""9e4fb5""",9.78,"""Claude François Geoffroy""",90.924,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p3""","""[Xe] 4f14 5d10 6s2 6p3""",2.02,15,544.7,25.52,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Bismuth""",None,"""Bismuth is a chemical element with symbol Bi and atomic number 83. Bismuth, a pentavalent post-transition metal, chemically resembles arsenic and antimony. Elemental bismuth may occur naturally, although its sulfide and oxide form important commercial ores.""",29,6,15,6),
            Element("""Polonium""",84,"""Po""","""silvery""",209,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_084_polonium/element_084_polonium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_084_polonium/element_084_polonium_srp_th.png""",1235,"""post-transition metal""","""ab5c00""",9.196,"""Pierre Curie""",136,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p4""","""[Xe] 4f14 5d10 6s2 6p4""",2,16,527,26.4,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Polonium""",None,"""Polonium is a chemical element with symbol Po and atomic number 84, discovered in 1898 by Marie Curie and Pierre Curie. A rare and highly radioactive element with no stable isotopes, polonium is chemically similar to bismuth and tellurium, and it occurs in uranium ores. Applications of polonium are few.""",30,6,16,6),
            Element("""Astatine""",85,"""At""","""unknown, probably metallic""",210,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_085_astatine/element_085_astatine.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_085_astatine/element_085_astatine_srp_th.png""",610,"""metalloid""","""754f45""",6.35,"""Dale R. Corson""",233,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p5""","""[Xe] 4f14 5d10 6s2 6p5""",2.2,17,575,None,None,6,"""Solid""","""https://en.wikipedia.org/wiki/Astatine""",None,"""Astatine is a very rare radioactive chemical element with the chemical symbol At and atomic number 85. It occurs on Earth as the decay product of various heavier elements. All its isotopes are short-lived; the most stable is astatine-210, with a half-life of 8.1 hours.""",31,6,17,6),
            Element("""Radon""",86,"""Rn""","""colorless gas, occasionally glows green or red in discharge tubes""",222,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_086_radon/element_086_radon.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_086_radon/element_086_radon_srp_th.png""",211.5,"""noble gas""","""428296""",9.73,"""Friedrich Ernst Dorn""",-68,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6""","""[Xe] 4f14 5d10 6s2 6p6""",2.2,18,202,None,None,6,"""Gas""","""https://en.wikipedia.org/wiki/Radon""","""https://en.wikipedia.org/wiki/File:Radon_spectrum.png""","""Radon is a chemical element with symbol Rn and atomic number 86. It is a radioactive, colorless, odorless, tasteless noble gas, occurring naturally as a decay product of radium. Its most stable isotope, 222Rn, has a half-life of 3.8 days.""",32,6,18,6),
            Element("""Francium""",87,"""Fr""",None,223,"""s""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_087_francium/element_087_francium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_087_francium/element_087_francium_srp_th.png""",950,"""alkali metal""","""420066""",1.87,"""Marguerite Perey""",46.89,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s1""","""[Rn] 7s1""",0.79,1,300,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Francium""",None,"""Francium is a chemical element with symbol Fr and atomic number 87. It used to be known as eka-caesium and actinium K. It is the second-least electronegative element, behind only caesium. Francium is a highly radioactive metal that decays into astatine, radium, and radon.""",1,7,1,7),
            Element("""Radium""",88,"""Ra""","""silvery white metallic""",226,"""s""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_088_radium/element_088_radium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_088_radium/element_088_radium_srp_th.png""",2010,"""alkaline earth metal""","""007d00""",5.5,"""Pierre Curie""",9.6485,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2""","""[Rn] 7s2""",0.9,2,1233,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Radium""",None,"""Radium is a chemical element with symbol Ra and atomic number 88. It is the sixth element in group 2 of the periodic table, also known as the alkaline earth metals. Pure radium is almost colorless, but it readily combines with nitrogen (rather than oxygen) on exposure to air, forming a black surface layer of radium nitride (Ra3N2).""",2,7,2,7),
            Element("""Actinium""",89,"""Ac""",None,227,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_089_actinium/element_089_actinium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_089_actinium/element_089_actinium_srp_th.png""",3500,"""actinide""","""70abfa""",10,"""Friedrich Oskar Giesel""",33.77,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 6d1""","""[Rn] 6d1 7s2""",1.1,3,1500,27.2,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Actinium""",None,"""Actinium is a radioactive chemical element with symbol Ac (not to be confused with the abbreviation for an acetyl group) and atomic number 89, which was discovered in 1899. It was the first non-primordial radioactive element to be isolated. Polonium, radium and radon were observed before actinium, but they were not isolated until 1902.""",3,7,3,10),
            Element("""Thorium""",90,"""Th""","""silvery, often with black tarnish""",232.03774,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_090_thorium/element_090_thorium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_090_thorium/element_090_thorium_srp_th.png""",5061,"""actinide""","""00baff""",11.724,"""Jöns Jakob Berzelius""",112.72,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 6d2""","""[Rn] 6d2 7s2""",1.3,3,2023,26.23,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Thorium""",None,"""Thorium is a chemical element with symbol Th and atomic number 90. A radioactive actinide metal, thorium is one of only two significantly radioactive elements that still occur naturally in large quantities as a primordial element (the other being uranium). It was discovered in 1828 by the Norwegian Reverend and amateur mineralogist Morten Thrane Esmark and identified by the Swedish chemist Jöns Jakob Berzelius, who named it after Thor, the Norse god of thunder.""",4,7,4,10),
            Element("""Protactinium""",91,"""Pa""","""bright, silvery metallic luster""",231.035882,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_091_protactinium/element_091_protactinium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_091_protactinium/element_091_protactinium_srp_th.png""",4300,"""actinide""","""00a1ff""",15.37,"""William Crookes""",53.03,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f2 6d1""","""[Rn] 5f2 6d1 7s2""",1.5,3,1841,None,"""Otto Hahn""",7,"""Solid""","""https://en.wikipedia.org/wiki/Protactinium""",None,"""Protactinium is a chemical element with symbol Pa and atomic number 91. It is a dense, silvery-gray metal which readily reacts with oxygen, water vapor and inorganic acids. It forms various chemical compounds where protactinium is usually present in the oxidation state +5, but can also assume +4 and even +2 or +3 states.""",5,7,5,10),
            Element("""Uranium""",92,"""U""",None,238.028913,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_092_uranium/element_092_uranium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_092_uranium/element_092_uranium_srp_th.png""",4404,"""actinide""","""008fff""",19.1,"""Martin Heinrich Klaproth""",50.94,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f3 6d1""","""[Rn] 5f3 6d1 7s2""",1.38,3,1405.3,27.665,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Uranium""",None,"""Uranium is a chemical element with symbol U and atomic number 92. It is a silvery-white metal in the actinide series of the periodic table. A uranium atom has 92 protons and 92 electrons, of which 6 are valence electrons.""",6,7,6,10),
            Element("""Neptunium""",93,"""Np""","""silvery metallic""",237,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_093_neptunium/element_093_neptunium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_093_neptunium/element_093_neptunium_srp_th.png""",4447,"""actinide""","""0080ff""",20.45,"""Edwin McMillan""",45.85,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f4 6d1""","""[Rn] 5f4 6d1 7s2""",1.36,3,912,29.46,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Neptunium""",None,"""Neptunium is a chemical element with symbol Np and atomic number 93. A radioactive actinide metal, neptunium is the first transuranic element. Its position in the periodic table just after uranium, named after the planet Uranus, led to it being named after Neptune, the next planet beyond Uranus.""",7,7,7,10),
            Element("""Plutonium""",94,"""Pu""","""silvery white, tarnishing to dark gray in air""",244,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_094_plutonium/element_094_plutonium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_094_plutonium/element_094_plutonium_srp_th.png""",3505,"""actinide""","""006bff""",19.816,"""Glenn T. Seaborg""",-48.33,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f6""","""[Rn] 5f6 7s2""",1.28,3,912.5,35.5,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Plutonium""",None,"""Plutonium is a transuranic radioactive chemical element with symbol Pu and atomic number 94. It is an actinide metal of silvery-gray appearance that tarnishes when exposed to air, and forms a dull coating when oxidized. The element normally exhibits six allotropes and four oxidation states.""",8,7,8,10),
            Element("""Americium""",95,"""Am""","""silvery white""",243,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_095_americium/element_095_americium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_095_americium/element_095_americium_srp_th.png""",2880,"""actinide""","""545cf2""",12,"""Glenn T. Seaborg""",9.93,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f7""","""[Rn] 5f7 7s2""",1.13,3,1449,62.7,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Americium""","""https://en.wikipedia.org/wiki/File:Americium_spectrum_visible.png""","""Americium is a radioactive transuranic chemical element with symbol Am and atomic number 95. This member of the actinide series is located in the periodic table under the lanthanide element europium, and thus by analogy was named after the Americas. Americium was first produced in 1944 by the group of Glenn T.Seaborg from Berkeley, California, at the metallurgical laboratory of University of Chicago.""",9,7,9,10),
            Element("""Curium""",96,"""Cm""","""silvery metallic, glows purple in the dark""",247,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_096_curium/element_096_curium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_096_curium/element_096_curium_srp_th.png""",3383,"""actinide""","""785ce3""",13.51,"""Glenn T. Seaborg""",27.17,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f7 6d1""","""[Rn] 5f7 6d1 7s2""",1.28,3,1613,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Curium""",None,"""Curium is a transuranic radioactive chemical element with symbol Cm and atomic number 96. This element of the actinide series was named after Marie and Pierre Curie – both were known for their research on radioactivity. Curium was first intentionally produced and identified in July 1944 by the group of Glenn T. Seaborg at the University of California, Berkeley.""",10,7,10,10),
            Element("""Berkelium""",97,"""Bk""","""silvery""",247,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_097_berkelium/element_097_berkelium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_097_berkelium/element_097_berkelium_srp_th.png""",2900,"""actinide""","""8a4fe3""",14.78,"""Lawrence Berkeley National Laboratory""",-165.24,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f9""","""[Rn] 5f9 7s2""",1.3,3,1259,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Berkelium""",None,"""Berkelium is a transuranic radioactive chemical element with symbol Bk and atomic number 97. It is a member of the actinide and transuranium element series. It is named after the city of Berkeley, California, the location of the University of California Radiation Laboratory where it was discovered in December 1949.""",11,7,11,10),
            Element("""Californium""",98,"""Cf""","""silvery""",251,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_098_californium/element_098_californium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_098_californium/element_098_californium_srp_th.png""",1743,"""actinide""","""a136d4""",15.1,"""Lawrence Berkeley National Laboratory""",-97.31,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f10""","""[Rn] 5f10 7s2""",1.3,3,1173,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Californium""",None,"""Californium is a radioactive metallic chemical element with symbol Cf and atomic number 98. The element was first made in 1950 at the University of California Radiation Laboratory in Berkeley, by bombarding curium with alpha particles (helium-4 ions). It is an actinide element, the sixth transuranium element to be synthesized, and has the second-highest atomic mass of all the elements that have been produced in amounts large enough to see with the unaided eye (after einsteinium).""",12,7,12,10),
            Element("""Einsteinium""",99,"""Es""","""silver-colored""",252,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_099_einsteinium/element_099_einsteinium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_099_einsteinium/element_099_einsteinium_srp_th.png""",1269,"""actinide""","""b31fd4""",8.84,"""Lawrence Berkeley National Laboratory""",-28.6,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f11""","""[Rn] 5f11 7s2""",1.3,3,1133,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Einsteinium""",None,"""Einsteinium is a synthetic element with symbol Es and atomic number 99. It is the seventh transuranic element, and an actinide. Einsteinium was discovered as a component of the debris of the first hydrogen bomb explosion in 1952, and named after Albert Einstein.""",13,7,13,10),
            Element("""Fermium""",100,"""Fm""",None,257,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_100_fermium/element_100_fermium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_100_fermium/element_100_fermium_srp_th.png""",None,"""actinide""","""b31fba""",None,"""Lawrence Berkeley National Laboratory""",33.96,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f12""","""[Rn] 5f12 7s2""",1.3,3,1800,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Fermium""",None,"""Fermium is a synthetic element with symbol Fm and atomic number 100. It is a member of the actinide series. It is the heaviest element that can be formed by neutron bombardment of lighter elements, and hence the last element that can be prepared in macroscopic quantities, although pure fermium metal has not yet been prepared.""",14,7,14,10),
            Element("""Mendelevium""",101,"""Md""",None,258,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_101_mendelevium/element_101_mendelevium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_101_mendelevium/element_101_mendelevium_srp_th.png""",None,"""actinide""","""b30da6""",None,"""Lawrence Berkeley National Laboratory""",93.91,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f13""","""[Rn] 5f13 7s2""",1.3,3,1100,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Mendelevium""",None,"""Mendelevium is a synthetic element with chemical symbol Md (formerly Mv) and atomic number 101. A metallic radioactive transuranic element in the actinide series, it is the first element that currently cannot be produced in macroscopic quantities through neutron bombardment of lighter elements. It is the antepenultimate actinide and the ninth transuranic element.""",15,7,15,10),
            Element("""Nobelium""",102,"""No""",None,259,"""f""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_102_nobelium/element_102_nobelium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_102_nobelium/element_102_nobelium_srp_th.png""",None,"""actinide""","""bd0d87""",None,"""Joint Institute for Nuclear Research""",-223.22,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14""","""[Rn] 5f14 7s2""",1.3,3,1100,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Nobelium""",None,"""Nobelium is a synthetic chemical element with symbol No and atomic number 102. It is named in honor of Alfred Nobel, the inventor of dynamite and benefactor of science. A radioactive metal, it is the tenth transuranic element and is the penultimate member of the actinide series.""",16,7,16,10),
            Element("""Lawrencium""",103,"""Lr""",None,266,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_103_lawrencium/element_103_lawrencium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_103_lawrencium/element_103_lawrencium_srp_th.png""",None,"""actinide""","""c70066""",None,"""Lawrence Berkeley National Laboratory""",-30.04,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14 7p1""","""[Rn] 5f14 7s2 7p1""",1.3,3,1900,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Lawrencium""",None,"""Lawrencium is a synthetic chemical element with chemical symbol Lr (formerly Lw) and atomic number 103. It is named in honor of Ernest Lawrence, inventor of the cyclotron, a device that was used to discover many artificial radioactive elements. A radioactive metal, lawrencium is the eleventh transuranic element and is also the final member of the actinide series.""",17,7,17,10),
            Element("""Rutherfordium""",104,"""Rf""",None,267,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_104_rutherfordium/element_104_rutherfordium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_104_rutherfordium/element_104_rutherfordium_srp_th.png""",5800,"""transition metal""","""cc0059""",23.2,"""Joint Institute for Nuclear Research""",None,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14 6d2""","""[Rn] 5f14 6d2 7s2""",None,4,2400,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Rutherfordium""",None,"""Rutherfordium is a chemical element with symbol Rf and atomic number 104, named in honor of physicist Ernest Rutherford. It is a synthetic element (an element that can be created in a laboratory but is not found in nature) and radioactive; the most stable known isotope, 267Rf, has a half-life of approximately 1.3 hours. In the periodic table of the elements, it is a d - block element and the second of the fourth - row transition elements.""",18,7,4,7),
            Element("""Dubnium""",105,"""Db""",None,268,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_105_dubnium/element_105_dubnium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_105_dubnium/element_105_dubnium_srp_th.png""",None,"""transition metal""","""d1004f""",29.3,"""Joint Institute for Nuclear Research""",None,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14 6d3""","""*[Rn] 5f14 6d3 7s2""",None,5,None,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Dubnium""",None,"""Dubnium is a chemical element with symbol Db and atomic number 105. It is named after the town of Dubna in Russia (north of Moscow), where it was first produced. It is a synthetic element (an element that can be created in a laboratory but is not found in nature) and radioactive; the most stable known isotope, dubnium-268, has a half-life of approximately 28 hours.""",19,7,5,7),
            Element("""Seaborgium""",106,"""Sg""",None,269,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_106_seaborgium/element_106_seaborgium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_106_seaborgium/element_106_seaborgium_srp_th.png""",None,"""transition metal""","""d90045""",35,"""Lawrence Berkeley National Laboratory""",None,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14 6d4""","""*[Rn] 5f14 6d4 7s2""",None,6,None,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Seaborgium""",None,"""Seaborgium is a synthetic element with symbol Sg and atomic number 106. Its most stable isotope 271Sg has a half-life of 1.9 minutes. A more recently discovered isotope 269Sg has a potentially slightly longer half-life (ca.""",20,7,6,7),
            Element("""Bohrium""",107,"""Bh""",None,270,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_107_bohrium/element_107_bohrium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_107_bohrium/element_107_bohrium_srp_th.png""",None,"""transition metal""","""e00038""",37.1,"""Gesellschaft für Schwerionenforschung""",None,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14 6d5""","""*[Rn] 5f14 6d5 7s2""",None,7,None,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Bohrium""",None,"""Bohrium is a chemical element with symbol Bh and atomic number 107. It is named after Danish physicist Niels Bohr. It is a synthetic element (an element that can be created in a laboratory but is not found in nature) and radioactive; the most stable known isotope, 270Bh, has a half-life of approximately 61 seconds.""",21,7,7,7),
            Element("""Hassium""",108,"""Hs""",None,269,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_108_hassium/element_108_hassium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_108_hassium/element_108_hassium_srp_th.png""",None,"""transition metal""","""e6002e""",40.7,"""Gesellschaft für Schwerionenforschung""",None,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14 6d6""","""*[Rn] 5f14 6d6 7s2""",None,8,126,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Hassium""",None,"""Hassium is a chemical element with symbol Hs and atomic number 108, named after the German state of Hesse. It is a synthetic element (an element that can be created in a laboratory but is not found in nature) and radioactive; the most stable known isotope, 269Hs, has a half-life of approximately 9.7 seconds, although an unconfirmed metastable state, 277mHs, may have a longer half-life of about 130 seconds. More than 100 atoms of hassium have been synthesized to date.""",22,7,8,7),
            Element("""Meitnerium""",109,"""Mt""",None,278,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_109_meitnerium/element_109_meitnerium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_109_meitnerium/element_109_meitnerium_srp_th.png""",None,"""unknown, probably transition metal""","""eb0026""",37.4,"""Gesellschaft für Schwerionenforschung""",None,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14 6d7""","""*[Rn] 5f14 6d7 7s2""",None,9,None,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Meitnerium""",None,"""Meitnerium is a chemical element with symbol Mt and atomic number 109. It is an extremely radioactive synthetic element (an element not found in nature that can be created in a laboratory). The most stable known isotope, meitnerium-278, has a half-life of 7.6 seconds.""",23,7,9,7),
            Element("""Darmstadtium""",110,"""Ds""",None,281,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_110_darmstadtium/element_110_darmstadtium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_110_darmstadtium/element_110_darmstadtium_srp_th.png""",None,"""unknown, probably transition metal""",None,34.8,"""Gesellschaft für Schwerionenforschung""",None,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14 6d8""","""*[Rn] 5f14 6d9 7s1""",None,10,None,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Darmstadtium""",None,"""Darmstadtium is a chemical element with symbol Ds and atomic number 110. It is an extremely radioactive synthetic element. The most stable known isotope, darmstadtium-281, has a half-life of approximately 10 seconds.""",24,7,10,7),
            Element("""Roentgenium""",111,"""Rg""",None,282,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_111_roentgenium/element_111_roentgenium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_111_roentgenium/element_111_roentgenium_srp_th.png""",None,"""unknown, probably transition metal""",None,28.7,"""Gesellschaft für Schwerionenforschung""",151,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14 6d9""","""*[Rn] 5f14 6d10 7s1""",None,11,None,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Roentgenium""",None,"""Roentgenium is a chemical element with symbol Rg and atomic number 111. It is an extremely radioactive synthetic element (an element that can be created in a laboratory but is not found in nature); the most stable known isotope, roentgenium-282, has a half-life of 2.1 minutes. Roentgenium was first created in 1994 by the GSI Helmholtz Centre for Heavy Ion Research near Darmstadt, Germany.""",25,7,11,7),
            Element("""Copernicium""",112,"""Cn""",None,285,"""d""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_112_copernicium/element_112_copernicium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_112_copernicium/element_112_copernicium_srp_th.png""",3570,"""transition metal""",None,14.0,"""Gesellschaft für Schwerionenforschung""",None,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14 6d10""","""*[Rn] 5f14 6d10 7s2""",None,12,None,None,None,7,"""Liquid""","""https://en.wikipedia.org/wiki/Copernicium""",None,"""Copernicium is a chemical element with symbol Cn and atomic number 112. It is an extremely radioactive synthetic element that can only be created in a laboratory. The most stable known isotope, copernicium-285, has a half-life of approximately 29 seconds, but it is possible that this copernicium isotope may have a nuclear isomer with a longer half-life, 8.9 min.""",26,7,12,7),
            Element("""Nihonium""",113,"""Nh""",None,286,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_113_nihonium/element_113_nihonium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_113_nihonium/element_113_nihonium_srp_th.png""",1430,"""unknown, probably transition metal""",None,16,"""RIKEN""",66.6,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14 6d10 7p1""","""*[Rn] 5f14 6d10 7s2 7p1""",None,13,700,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Ununtrium""",None,"""Nihonium is a chemical element with atomic number 113. It has a symbol Nh. It is a synthetic element (an element that can be created in a laboratory but is not found in nature) and is extremely radioactive; its most stable known isotope, nihonium-286, has a half-life of 20 seconds.""",27,7,13,7),
            Element("""Flerovium""",114,"""Fl""",None,289,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_114_flerovium/element_114_flerovium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_114_flerovium/element_114_flerovium_srp_th.png""",420,"""post-transition metal""",None,14,"""Joint Institute for Nuclear Research""",None,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14 6d10 7p2""","""*[Rn] 5f14 6d10 7s2 7p2""",None,14,340,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Flerovium""",None,"""Flerovium is a superheavy artificial chemical element with symbol Fl and atomic number 114. It is an extremely radioactive synthetic element. The element is named after the Flerov Laboratory of Nuclear Reactions of the Joint Institute for Nuclear Research in Dubna, Russia, where the element was discovered in 1998.""",28,7,14,7),
            Element("""Moscovium""",115,"""Mc""",None,289,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_115_moscovium/element_115_moscovium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_115_moscovium/element_115_moscovium_srp_th.png""",1400,"""unknown, probably post-transition metal""",None,13.5,"""Joint Institute for Nuclear Research""",35.3,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14 6d10 7p3""","""*[Rn] 5f14 6d10 7s2 7p3""",None,15,670,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Ununpentium""",None,"""Moscovium is the name of a synthetic superheavy element in the periodic table that has the symbol Mc and has the atomic number 115. It is an extremely radioactive element; its most stable known isotope, moscovium-289, has a half-life of only 220 milliseconds. It is also known as eka-bismuth or simply element 115.""",29,7,15,7),
            Element("""Livermorium""",116,"""Lv""",None,293,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_116_livermorium/element_116_livermorium.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_116_livermorium/element_116_livermorium_srp_th.png""",1085,"""unknown, probably post-transition metal""",None,12.9,"""Joint Institute for Nuclear Research""",74.9,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14 6d10 7p4""","""*[Rn] 5f14 6d10 7s2 7p4""",None,16,709,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Livermorium""",None,"""Livermorium is a synthetic superheavy element with symbol Lv and atomic number 116. It is an extremely radioactive element that has only been created in the laboratory and has not been observed in nature. The element is named after the Lawrence Livermore National Laboratory in the United States, which collaborated with the Joint Institute for Nuclear Research in Dubna, Russia to discover livermorium in 2000.""",30,7,16,7),
            Element("""Tennessine""",117,"""Ts""",None,294,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_117_tennessine/element_117_tennessine.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_117_tennessine/element_117_tennessine_srp_th.png""",883,"""unknown, probably metalloid""",None,7.17,"""Joint Institute for Nuclear Research""",165.9,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14 6d10 7p5""","""*[Rn] 5f14 6d10 7s2 7p5""",None,17,723,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Tennessine""",None,"""Tennessine is a superheavy artificial chemical element with an atomic number of 117 and a symbol of Ts. Also known as eka-astatine or element 117, it is the second-heaviest known element and penultimate element of the 7th period of the periodic table. As of 2016, fifteen tennessine atoms have been observed:six when it was first synthesized in 2010, seven in 2012, and two in 2014.""",31,7,17,7),
            Element("""Oganesson""",118,"""Og""",None,294,"""p""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_118_oganesson/element_118_oganesson.glb""","""https://storage.googleapis.com/search-ar-edu/periodic-table/element_118_oganesson/element_118_oganesson_srp_th.png""",350,"""unknown, predicted to be noble gas""",None,4.95,"""Joint Institute for Nuclear Research""",5.40318,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14 6d10 7p6""","""*[Rn] 5f14 6d10 7s2 7p6""",None,18,None,None,None,7,"""Solid""","""https://en.wikipedia.org/wiki/Oganesson""",None,"""Oganesson is IUPAC's name for the transactinide element with the atomic number 118 and element symbol Og. It is also known as eka-radon or element 118, and on the periodic table of the elements it is a p-block element and the last one of the 7th period. Oganesson is currently the only synthetic member of group 18.""",32,7,18,7),
            Element("""Ununennium""",119,"""Uue""",None,315,"""s""",None,None,630,"""unknown, but predicted to be an alkali metal""",None,3,"""GSI Helmholtz Centre for Heavy Ion Research""",63.87,"""1s2 2s2 2p6 3s2 3p6 4s2 3d10 4p6 5s2 4d10 5p6 6s2 4f14 5d10 6p6 7s2 5f14 6d10 7p6 8s1""","""*[Uuo] 8s1""",None,1,None,None,None,8,"""Solid""","""https://en.wikipedia.org/wiki/Ununennium""",None,"""Ununennium, also known as eka-francium or simply element 119, is the hypothetical chemical element with symbol Uue and atomic number 119. Ununennium and Uue are the temporary systematic IUPAC name and symbol respectively, until a permanent name is decided upon. In the periodic table of the elements, it is expected to be an s-block element, an alkali metal, and the first element in the eighth period.""",1,8,1,8),
        )
        self.search_number(13).setnames(['aluminium'])
        self.search_number(16).setnames(['sulphur'])
    def search_name(self,name:str)-> Optional[Element]:
        """Case-insensitive British / American search for element name"""
        for e in self.elements:
            if e.is_named(name):
                return e
        return None

    def search_symbol(self,symbol:str)-> Optional[Element]:
        """Case-insensitive search for element symbol"""
        lsymbol = symbol.lower()
        for e in self.elements:
            if lsymbol == e.symbol.lower():
                return e
        return None

    def search_number(self,number:int)-> Optional[Element]:
        """Search by atomic number"""
        for e in self.elements:
            if e.atomic == number:
                return e
        return None

