"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnTeam = exports.CfnTeamPropsPrivacy = exports.toJson_CfnTeamProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnTeamProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnTeamProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Organization': obj.organization,
        'Description': obj.description,
        'Privacy': obj.privacy,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnTeamProps = toJson_CfnTeamProps;
/* eslint-enable max-len, quote-props */
/**
 * The privacy for the team - must be either secret or closed
 *
 * @schema CfnTeamPropsPrivacy
 */
var CfnTeamPropsPrivacy;
(function (CfnTeamPropsPrivacy) {
    /** secret */
    CfnTeamPropsPrivacy["SECRET"] = "secret";
    /** closed */
    CfnTeamPropsPrivacy["CLOSED"] = "closed";
})(CfnTeamPropsPrivacy = exports.CfnTeamPropsPrivacy || (exports.CfnTeamPropsPrivacy = {}));
/**
 * A CloudFormation `GitHub::Teams::Team`
 *
 * @cloudformationResource GitHub::Teams::Team
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
 */
class CfnTeam extends cdk.CfnResource {
    /**
     * Create a new `GitHub::Teams::Team`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnTeam.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnTeamProps(props) });
        this.props = props;
        this.attrSlug = cdk.Token.asString(this.getAtt('Slug'));
    }
}
exports.CfnTeam = CfnTeam;
_a = JSII_RTTI_SYMBOL_1;
CfnTeam[_a] = { fqn: "@cdk-cloudformation/github-teams-team.CfnTeam", version: "1.2.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnTeam.CFN_RESOURCE_TYPE_NAME = "GitHub::Teams::Team";
//# sourceMappingURL=data:application/json;base64,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