import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectMilestoneConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the milestone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_milestone#description ProjectMilestone#description}
    */
    readonly description?: string;
    /**
    * The due date of the milestone. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_milestone#due_date ProjectMilestone#due_date}
    */
    readonly dueDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_milestone#id ProjectMilestone#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID or URL-encoded path of the project owned by the authenticated user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_milestone#project ProjectMilestone#project}
    */
    readonly project: string;
    /**
    * The start date of the milestone. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_milestone#start_date ProjectMilestone#start_date}
    */
    readonly startDate?: string;
    /**
    * The state of the milestone. Valid values are: `active`, `closed`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_milestone#state ProjectMilestone#state}
    */
    readonly state?: string;
    /**
    * The title of a milestone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_milestone#title ProjectMilestone#title}
    */
    readonly title: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_milestone gitlab_project_milestone}
*/
export declare class ProjectMilestone extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_project_milestone";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_milestone gitlab_project_milestone} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectMilestoneConfig
    */
    constructor(scope: Construct, id: string, config: ProjectMilestoneConfig);
    get createdAt(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _dueDate?;
    get dueDate(): string;
    set dueDate(value: string);
    resetDueDate(): void;
    get dueDateInput(): string | undefined;
    get expired(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get iid(): number;
    get milestoneId(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get projectId(): number;
    private _startDate?;
    get startDate(): string;
    set startDate(value: string);
    resetStartDate(): void;
    get startDateInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    get updatedAt(): string;
    get webUrl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
