#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from gql_client.runtime.enum_utils import enum_field_metadata
from ..enum.resource_relationship_types_kind import ResourceRelationshipTypesKind

from ..input.resource_relationship_filter_input import ResourceRelationshipFilterInput
from ..input.resource_relationship_order import ResourceRelationshipOrder


# fmt: off
QUERY: List[str] = ["""
query resourceRelationships(
  $after: Cursor
  $first: Int
  $before: Cursor
  $last: Int
  $orderBy: ResourceRelationshipOrder
  $filterBy: [ResourceRelationshipFilterInput!]
) {
  resourceRelationships(
    after: $after
    first: $first
    before: $before
    last: $last
    orderBy: $orderBy
    filterBy: $filterBy
  ) {
    totalCount
    edges {
      node {
        id
        resourceRelationshipTypes
        location {
          id
          name
        }
        resourceA {
          id
          name
        }
        resourceB {
          id
          name
        }
      }
      cursor
    }
    pageInfo {
      hasNextPage
      hasPreviousPage
      startCursor
      endCursor
    }
  }
}

"""
]


class resourceRelationships:
    @dataclass(frozen=True)
    class resourceRelationshipsData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class ResourceRelationshipConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class ResourceRelationshipEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class ResourceRelationship(DataClassJsonMixin):
                    @dataclass(frozen=True)
                    class Location(DataClassJsonMixin):
                        id: str
                        name: str

                    @dataclass(frozen=True)
                    class Resource(DataClassJsonMixin):
                        id: str
                        name: str

                    id: str
                    resourceRelationshipTypes: ResourceRelationshipTypesKind = _field(metadata=enum_field_metadata(ResourceRelationshipTypesKind))
                    location: Optional[Location]
                    resourceA: Resource
                    resourceB: Optional[Resource]

                node: Optional[ResourceRelationship]
                cursor: str

            @dataclass(frozen=True)
            class PageInfo(DataClassJsonMixin):
                hasNextPage: bool
                hasPreviousPage: bool
                startCursor: Optional[str]
                endCursor: Optional[str]

            totalCount: int
            edges: List[ResourceRelationshipEdge]
            pageInfo: PageInfo

        resourceRelationships: ResourceRelationshipConnection

    # fmt: off
    @classmethod
    def execute(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[ResourceRelationshipOrder] = None, filterBy: List[ResourceRelationshipFilterInput] = []) -> resourceRelationshipsData.ResourceRelationshipConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.resourceRelationshipsData.from_dict(response_text)
        return res.resourceRelationships

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[ResourceRelationshipOrder] = None, filterBy: List[ResourceRelationshipFilterInput] = []) -> resourceRelationshipsData.ResourceRelationshipConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.resourceRelationshipsData.from_dict(response_text)
        return res.resourceRelationships
