#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..input.organization_filter_input import OrganizationFilterInput
from ..input.organization_order import OrganizationOrder


# fmt: off
QUERY: List[str] = ["""
query organizations(
$after: Cursor
$first: Int
$before: Cursor
$last: Int
$orderBy: OrganizationOrder
$filterBy: [OrganizationFilterInput!]
){
organizations(after: $after, first: $first, before: $before, last: $last, orderBy: $orderBy, filterBy: $filterBy){
totalCount
edges{
node{
id
  name
  description
}
      cursor
    }
    pageInfo{
      hasNextPage
      hasPreviousPage
      startCursor
      endCursor
    }
  }
}
"""
]


class organizations:
    @dataclass(frozen=True)
    class organizationsData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class OrganizationConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class OrganizationEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class Organization(DataClassJsonMixin):
                    id: str
                    name: str
                    description: str

                node: Optional[Organization]
                cursor: str

            @dataclass(frozen=True)
            class PageInfo(DataClassJsonMixin):
                hasNextPage: bool
                hasPreviousPage: bool
                startCursor: Optional[str]
                endCursor: Optional[str]

            totalCount: int
            edges: List[OrganizationEdge]
            pageInfo: PageInfo

        organizations: OrganizationConnection

    # fmt: off
    @classmethod
    def execute(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[OrganizationOrder] = None, filterBy: List[OrganizationFilterInput] = []) -> organizationsData.OrganizationConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.organizationsData.from_dict(response_text)
        return res.organizations

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, orderBy: Optional[OrganizationOrder] = None, filterBy: List[OrganizationFilterInput] = []) -> organizationsData.OrganizationConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "orderBy": orderBy, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.organizationsData.from_dict(response_text)
        return res.organizations
