#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from gql_client.runtime.enum_utils import enum_field_metadata
from ..enum.resource_relationship_multiplicity_kind import ResourceRelationshipMultiplicityKind
from ..enum.resource_relationship_type_kind import ResourceRelationshipTypeKind

from ..input.edit_resource_type_relationship_input import EditResourceTypeRelationshipInput


# fmt: off
QUERY: List[str] = ["""
mutation editResourceTypeRelationship($input: EditResourceTypeRelationshipInput!) {
  editResourceTypeRelationship(input: $input) {
    id
    locationType{id}
    resourceTypeA{id}
    resourceTypeB{id}
    resourceRelationshipType
    resourceRelationshipMultiplicity
  }
}
"""
]


class editResourceTypeRelationship:
    @dataclass(frozen=True)
    class editResourceTypeRelationshipData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class ResourceTypeRelationship(DataClassJsonMixin):
            @dataclass(frozen=True)
            class LocationType(DataClassJsonMixin):
                id: str

            @dataclass(frozen=True)
            class ResourceType(DataClassJsonMixin):
                id: str

            id: str
            locationType: Optional[LocationType]
            resourceTypeA: ResourceType
            resourceTypeB: Optional[ResourceType]
            resourceRelationshipType: ResourceRelationshipTypeKind = _field(metadata=enum_field_metadata(ResourceRelationshipTypeKind))
            resourceRelationshipMultiplicity: ResourceRelationshipMultiplicityKind = _field(metadata=enum_field_metadata(ResourceRelationshipMultiplicityKind))

        editResourceTypeRelationship: ResourceTypeRelationship

    # fmt: off
    @classmethod
    def execute(cls, client: Client, input: EditResourceTypeRelationshipInput) -> editResourceTypeRelationshipData.ResourceTypeRelationship:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.editResourceTypeRelationshipData.from_dict(response_text)
        return res.editResourceTypeRelationship

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, input: EditResourceTypeRelationshipInput) -> editResourceTypeRelationshipData.ResourceTypeRelationship:
        variables: Dict[str, Any] = {"input": input}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.editResourceTypeRelationshipData.from_dict(response_text)
        return res.editResourceTypeRelationship
