#!/bin/bash
# DX_APP_WIZARD_NAME DX_APP_WIZARD_VERSION
# Generated by dx-app-wizard.
#
# Parallelized execution pattern: Your app will generate multiple jobs
# to perform some computation in parallel, followed by a final
# "postprocess" stage that will perform any additional computations as
# necessary.
#
# Your job's input variables (if any) will be loaded as environment
# variables before this script runs.  Any array inputs will be loaded
# as bash arrays.
#
# Any code outside of main() or any other entry point is ALWAYS
# executed, followed by running the entry point itself.
#
# See https://wiki.dnanexus.com/Developer-Portal for tutorials on how
# to modify this file.

main() {
DX_APP_WIZARD_INITIALIZE_INPUTDX_APP_WIZARD_DOWNLOAD_ANY_FILES
    # To report any recognized errors in the correct format in
    # $HOME/job_error.json and exit this script, you can use the
    # dx-jobutil-report-error utility as follows:
    #
    #   dx-jobutil-report-error "My error message"
    #
    # Note however that this entire bash script is executed with -e
    # when running in the cloud, so any line which returns a nonzero
    # exit code will prematurely exit the script; if no error was
    # reported in the job_error.json file, then the failure reason
    # will be AppInternalError with a generic error message.
    #
    # Split your work into parallel tasks.  As an example, the
    # following generates 10 subjobs running with the same dummy
    # input.  The utility dx-jobutil-new-job uses the same syntax as
    # dx run for specifying input, and you can explicitly specify the
    # class to enable proper parsing.

    for i in {1..10}
    do
        process_jobs[$i]=$(dx-jobutil-new-job process -iprocess_input:int=42)
    done

    # The following line creates the postprocess job that will only
    # run after all of the 10 "process" subjobs are done.
    postprocess=$(dx-jobutil-new-job postprocess -ipostprocess_input:string=42 --depends-on ${process_jobs[@]})
DX_APP_WIZARD_UPLOAD_ANY_FILES
    # If you would like to include any of the output fields from the
    # postprocess job as the output of your app, you should return it
    # here using a reference.  If the output field in the postprocess
    # function is called "answer", you can set that in the output hash
    # as follows.
    #
    #   dx-jobutil-add-output app_output_field "$postprocess":answer --class=jobref
    #
    # Tip: you can include in your output at this point any open
    # objects (such as gtables) which are closed by another entry
    # point that finishes later.  The system will check to make sure
    # that the output object is closed and will attempt to clone it
    # out as output into the parent container only after all subjobs
    # have finished.
DX_APP_WIZARD_OUTPUT
}

process() {
    # Fill in your process code here
    echo "Value of process_input: '${process_input}'"
    dx-jobutil-add-output output null
}

postprocess() {
    # Fill in your postprocess code here
    echo "Value of postprocess_input: '${postprocess_input}'"
    dx-jobutil-add-output answer null
}
