# Generated by Django 3.1 on 2020-08-27 19:03

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import multiselectfield.db.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='Team',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('name', models.CharField(max_length=30)),
                ('global_team', models.BooleanField()),
                ('categories', multiselectfield.db.fields.MultiSelectField(choices=[(1, 'Comment'), (2, 'Sales'), (3, 'Help'), (4, 'Bug')], max_length=7)),
                ('members', models.ManyToManyField(blank=True, to=settings.AUTH_USER_MODEL)),
                ('sites', models.ManyToManyField(default=1, to='sites.Site')),
            ],
        ),
        migrations.CreateModel(
            name='Ticket',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='date created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='last updated')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('status', models.IntegerField(choices=[(1, 'Open'), (10, 'Active'), (20, 'Hold'), (30, 'Closed'), (40, 'Canceled')], default=1, verbose_name='Status')),
                ('priority', models.IntegerField(choices=[(1, 'Suggestion'), (2, 'Low'), (3, 'Medium'), (4, 'High'), (5, 'Urgent')], default=3, verbose_name='Priority')),
                ('user_meta', models.JSONField(blank=True, default=dict, null=True)),
                ('category', models.IntegerField(choices=[(1, 'Comment'), (2, 'Sales'), (3, 'Help'), (4, 'Bug')], verbose_name='Category')),
                ('subject', models.CharField(max_length=120, verbose_name='Subject')),
                ('description', models.TextField(verbose_name='Description')),
                ('history', models.JSONField(blank=True, default=list, null=True)),
                ('dev_ticket', models.CharField(blank=True, max_length=30, null=True)),
                ('assigned_to', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='assigned_tickets', to=settings.AUTH_USER_MODEL)),
                ('related_to', models.ManyToManyField(blank=True, related_name='_ticket_related_to_+', to='helpme.Ticket')),
                ('site', models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
                ('teams', models.ManyToManyField(blank=True, related_name='support_tickets', to='helpme.Team')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='support_tickets', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'permissions': (('see-support-tickets', 'Access to support-level tickets'), ('see-developer-tickets', 'Access to developer-level tickets'), ('see-all-tickets', 'Access to all tickets')),
            },
        ),
        migrations.CreateModel(
            name='Comment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='date created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='last updated')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('content', models.TextField(verbose_name='Content')),
                ('visibility', models.IntegerField(choices=[(1, 'Reporters'), (10, 'Support Handlers'), (15, 'Developers'), (20, 'Supervisors')], default=1, verbose_name='Visibility')),
                ('ticket', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='comments', to='helpme.ticket')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
