# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['api',
 'api.base',
 'api.shared',
 'common',
 'conditions',
 'core',
 'selene',
 'selene.api',
 'selene.api.base',
 'selene.api.shared',
 'selene.common',
 'selene.core',
 'selene.support',
 'selene.support.conditions',
 'selene.support.shared',
 'shared',
 'support',
 'support.conditions',
 'support.shared']

package_data = \
{'': ['*']}

install_requires = \
['future',
 'selenium==4.4.3',
 'typing-extensions==4.3.0',
 'webdriver-manager==3.8.5']

setup_kwargs = {
    'name': 'selene',
    'version': '2.0.0b16',
    'description': 'User-oriented browser tests in Python (Selenide port)',
    'long_description': '# Selene - User-oriented Web UI browser tests in Python (Selenide port)\n\n[![tests](https://github.com/yashaka/selene/actions/workflows/tests.yml/badge.svg)](https://github.com/yashaka/selene/actions/workflows/tests.yml)\n[![codecov](https://codecov.io/gh/yashaka/selene/branch/master/graph/badge.svg)](https://codecov.io/gh/yashaka/selene)\n![Free](https://img.shields.io/badge/free-open--source-green.svg)\n[![MIT License](http://img.shields.io/badge/license-MIT-green.svg)](https://github.com/yashaka/selene/blob/master/LICENSE)\n[![Project Template](http://img.shields.io/badge/project-template-9cf.svg)](https://github.com/yashaka/python-web-test)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![Downloads](https://pepy.tech/badge/selene)](https://pepy.tech/project/selene)\n\n![GitHub stats in](https://raw.githubusercontent.com/yashaka/selene/traffic/traffic-selene/in_2021.svg)\n![GitHub views](https://raw.githubusercontent.com/yashaka/selene/traffic/traffic-selene/views.svg)\n![GitHub views per week](https://raw.githubusercontent.com/yashaka/selene/traffic/traffic-selene/views_per_week.svg)\n![GitHub clones](https://raw.githubusercontent.com/yashaka/selene/traffic/traffic-selene/clones.svg)\n![GitHub clones per week](https://raw.githubusercontent.com/yashaka/selene/traffic/traffic-selene/clones_per_week.svg)\n\n[![Join telegram chat https://t.me/selene_py](https://img.shields.io/badge/chat-telegram-blue)](https://t.me/selene_py)\n[![Присоединяйся к чату https://t.me/selene_py_ru](https://img.shields.io/badge/%D1%87%D0%B0%D1%82-telegram-red)](https://t.me/selene_py_ru)\n\n[![Sign up for a course http://autotest.how/selene](https://img.shields.io/badge/course-sign_up-blue)](http://autotest.how/selene)\n[![Запишись на курс http://autotest.how/selene-ru](https://img.shields.io/badge/%D0%BD%D0%B0%D0%B1%D0%BE%D1%80-%D0%BD%D0%B0%20%D0%BA%D1%83%D1%80%D1%81-red)](http://autotest.how/selene-ru)\n[![Учи Selene https://leanpub.com/selene-automation-ru](https://img.shields.io/badge/%D0%BA%D0%BD%D0%B8%D0%B3%D0%B0-leanpub-red)](https://leanpub.com/selene-automation-ru)\n[![Реєструйся на курс http://autotest.how/selene-uk](https://img.shields.io/badge/%D0%BD%D0%B0%D0%B1%D1%96%D1%80-%D0%BD%D0%B0_%D0%BA%D1%83%D1%80%D1%81-yellow)](http://autotest.how/selene-uk)\n\n\nMain features:\n\n- **User-oriented API for Selenium Webdriver** (code like speak common English)\n- **Ajax support** (Smart implicit waiting and retry mechanism)\n- **PageObjects support** (all elements are lazy-evaluated objects)\n- **Automatic driver management** (no need to install and setup driver for quick local execution)\n\n\nSelene was inspired by [Selenide](http://selenide.org/) from Java world.\n\nTests with Selene can be built either in a simple straightforward "selenide\' style or with PageObjects composed from Widgets i.e. reusable element components.\n\n## Table of content\n\n* [Versions](#versions)\n    * [Migration Guide](#migration-guide)\n* [Prerequisites](#prerequisites)\n* [Installation](#installation)\n* [Usage](#usage)\n    * [Quick Start](#quick-start)\n    * [Core API](#core-api)\n    * [Automatic Driver and Browser Management](#automatic-driver-and-browser-management)\n    * [Advanced API](#advanced-api)\n* [Tutorials](#tutorials)\n* [Examples](#more-examples)\n* [Contributing](#contributing)\n* [Release Process](#release-process)\n* [Changelog](#changelog)\n\n## Versions\n  \n* Latest recommended version to use is >= [2.0.0b14](https://pypi.org/project/selene/2.0.0b14/)\n  * it\'s a completely new version of selene, with improved API and speed\n  * supports 3.7 <= python <= 3.10,\n  * bundled with Selenium >= 4.1\n  * it\'s incompatible with [1.x](https://github.com/yashaka/selene/tree/1.x)\n  * current master branch is pointed to 2.x\n  * yet in alpha/beta stage, refining API, improving "migratability", and testing\n  * it looks pretty stable, most users already upgraded to 2.0 alpha/beta\n\n* Latest version marked as stable is: [1.0.2](https://pypi.org/project/selene/1.0.2/)\n  * it is main version used by most selene users during last 2 years\n  * it was proven to be stable for production use\n  * its sources and corresponding README version can be found at [1.x](https://github.com/yashaka/selene/tree/1.x) branch.\n  * supports python 2.7, 3.5, 3.6, 3.7\n  \nTHIS README DESCRIBES THE USAGE OF THE PRE-RELEASE version of Selene. For older docs look at [1.x](https://github.com/yashaka/selene/tree/1.x) branch.\n  \n### Migration guide\n\nFrom 1.0.1 to 2.0.0aLATEST:\n* upgrade to python 3.7\n* update selene to 2.0.0aLATEST\n  * find&replace the `collection.first()` method from `.first()` to `.first`\n  * ensure all conditions like `text(\'foo\')` are used via `be.*` or `have.*` syntax\n    * example:\n      * find&replace all\n        * `(text(\'foo\'))` to `(have.text(\'foo\'))`\n        * `(visible)` to `(be.visible)`\n      * smarter find&replace (with some manual refactoring)\n        * `.should(x, timeout=y)` to `.with_(timeout=y).should(x)`\n        * `.should_not(be.*)` to `.should(be.not_.*)` or `.should(be.*.not_)`\n        * `.should_not(have.*)` to `.should(have.no.*)` or `.should(have.*.not_)`\n        * `.should_each(condition)` to `.should(condition.each)`\n      * and add corresponding imports: `from selene import be, have`\n  * fix another broken imports if available\n  * run tests, read deprecation warnings, and refactor to new style recommended in warning messages\n\n## Prerequisites\n\n[Python >= 3.7](https://www.python.org/downloads/release/python-370/)\n\nGiven [pyenv](https://github.com/pyenv/pyenv) installed, installing needed version of Python is pretty simple:\n\n    $ pyenv install 3.7.3\n    $ pyenv global 3.7.3\n    $ python -V\n    Python 3.7.3\n\n## Installation\n\n### via poetry + pyenv (recommended)\n\nGIVEN [poetry](https://poetry.eustace.io/) and [pyenv](https://github.com/pyenv/pyenv) installed ...\n\nAND\n\n    $ poetry new my-tests-with-selene\n    $ cd my-tests-with-selene\n    $ pyenv local 3.7.3\n\nWHEN latest pre-release recommended version:\n\n    $ poetry add selene --allow-prereleases\n\nWHEN latest stable version:\n\n    $ poetry add selene\n\nTHEN\n\n    $ poetry install\n\n### via pip\n\nLatest recommended pre-release alpha version:\n\n    $ pip install selene --pre\n\nLatest stable version:\n\n    $ pip install selene\n\n### from sources\n\nGIVEN webdriver and webdriver_manager are already installed\n\nTHEN\n\n    $ git clone https://github.com/yashaka/selene.git\n    $ python setup.py install\n\nor using pip:\n\n    $ pip install git+https://github.com/yashaka/selene.git\n    \n\n## Usage\n\n### Quick Start\n\nSimply...\n\n```python\nfrom selene.support.shared import browser\nfrom selene import by, be, have\n\nbrowser.open(\'https://google.com/ncr\')\nbrowser.element(by.name(\'q\')).should(be.blank)\\\n    .type(\'selenium\').press_enter()\nbrowser.all(\'.srg .g\').should(have.size(10))\\\n    .first.should(have.text(\'Selenium automates browsers\'))\n```\n\nOR with custom setup\n\n```python\nfrom selene.support.shared import browser\nfrom selene import by, be, have\n\nbrowser.config.browser_name = \'firefox\'\nbrowser.config.base_url = \'https://google.com\'\nbrowser.config.timeout = 2\n# browser.config.* = ...\n\nbrowser.open(\'/ncr\')\nbrowser.element(by.name(\'q\')).should(be.blank)\\\n    .type(\'selenium\').press_enter()\nbrowser.all(\'.srg .g\').should(have.size(10))\\\n    .first.should(have.text(\'Selenium automates browsers\'))\n```\n\nOR more Selenide from java style:\n\n```python\nfrom selene.support.shared import config, browser\nfrom selene import by, be, have\nfrom selene.support.shared.jquery_style import s, ss\n\n\nconfig.browser_name = \'firefox\'\nconfig.base_url = \'https://google.com\'\nconfig.timeout = 2\n# config.* = ...\n\nbrowser.open(\'/ncr\')\ns(by.name(\'q\')).should(be.blank)\\\n    .type(\'selenium\').press_enter()\nss(\'.srg .g\').should(have.size(10))\\\n    .first.should(have.text(\'Selenium automates browsers\'))\n```\n\n### Core Api\n\nGiven:\n\n```python\nfrom selenium.webdriver import Chrome\n```\n\nAND chromedriver executable available in $PATH\n\nWHEN:\n```python\nfrom selene import Browser, Config\n\nbrowser = Browser(Config(\n    driver=Chrome(),\n    base_url=\'https://google.com\',\n    timeout=2))\n```\n\nAND (uncomment if needed):\n\n```python\n# import atexit\n# atexit.register(browser.quit)\n```\n\nAND:\n\n```python\nbrowser.open(\'/ncr\')\n```\n\nAND:\n\n```python\n# browser.element(\'//*[@name="q"]\')).type(\'selenium\').press_enter()\n# OR...\n\n# browser.element(\'[name=q]\')).type(\'selenium\').press_enter()\n# OR...\n\nfrom selene import by\n\n# browser.element(by.name(\'q\')).type(\'selenium\').press_enter()\n# OR...for total readability\n\nquery = browser.element(by.name(\'q\'))  # actual search doesn\'t start here, the element is "lazy"          \n     # here the actual webelement is found\nquery.type(\'selenium\').press_enter()       \n                      # and here it\'s located again, i.e. the element is "dynamic"\n```\n\nAND (in case we need to filter collection of items by some condition like visibility):\n\n```python\nfrom selene import be\n\nresults = browser.all(\'.srg .g\').filtered_by(be.visible)\n```\n\nTHEN:\n\n```python\nfrom selene import have\n\n# results.should(have.size(10))\n# results.first.should(have.text(\'Selenium automates browsers\'))\n# OR...\n\nresults.should(have.size(10))\\\n    .first.should(have.text(\'Selenium automates browsers\'))\n```\n\nFINALLY (if not registered "atexit" before):\n\n```python\nbrowser.quit()\n```\n\n### Automatic Driver and Browser Management\n\nInstead of:\n\n```python\nfrom selene import Browser, Config\n\nbrowser = Browser(Config(\n    driver=Chrome(),\n    base_url=\'https://google.com\',\n    timeout=2))\n```\nYou can simply use the browser and config instance predefined for you in `selene.support.shared` module:\n\n```python\nfrom selene.support.shared import browser, config\n\n# ... do the same with browser.*\n```\nSo you don\'t need to create you driver instance manually. It will be created for you automatically.\n\nYet, if you need some special case, like working with remote driver, etc., you can still use shared browser object, while providing driver to it through:\n\n```python\nconfig.driver = my_remote_driver_instance\n# or\nbrowser.config.driver = my_remote_driver_instance\n```\n\n### Advanced API\n\nSometimes you might need some extra actions on elements, e.g. for workaround something through js:\n\n```python\nfrom selene import command\n\nbrowser.element(\'#not-in-view\').perform(command.js.scroll_into_view)\n```\n\nProbably you think that will need something like:\n\n```python\nfrom selene import query\n\nproduct_text = browser.element(\'#to-assert-something-non-standard\').get(query.text)\nprice = my_int_from(product_text)\nassert price > 100\n```\n\nBut usually it\'s either better to implement your custom condition:\n\n```python\nbrowser.element(\'#to-assert-something-non-standard\').should(have_in_text_the_int_number_more_than(100))\n```\n\nWhere the `have_in_text_the_int_number_more_than` is your defined custom condition. Such condition-based alternative will be less fragile, because python\'s assert does not have "implicit waiting", like selene\'s should ;)\n\n\nFurthermore, the good test is when you totally control your test data, and instead:\n\n```python\nproduct = browser.element(\'#to-remember-for-future\')\n\nproduct_text_before = product.get(query.text)\nprice_before = my_int_from(product_text_before)\n\n# ... do something\n\nproduct_text_after = product.get(query.text)\nprice_after = my_int_from(product_text_after)\n\nassert price_after > price_before\n```\n\nNormally, better would be to refactor to something like:\n\n```python\nproduct = browser.element(\'#to-remember-for-future\')\n\nproduct.should(have.text(\'100$\'))\n\n# ... do something\n\nproduct.should(have.text(\'125$\'))\n```\nYou might think you need something like:\n\n```python\nfrom selene import query\n\nif browser.element(\'#i-might-say-yes-or-no\').get(query.text) == \'yes\':\n    # do something...\n```\n\nOr:\n\n```python\nfrom selene import query\n\nif browser.all(\'.option\').get(query.size) >= 2:\n    # do something...\n```\n\nMaybe one day, you really find a use case:) But for above cases, probably easier would be:\n\n```python\nif browser.element(\'#i-might-say-yes-or-no\').wait_until(have.text(\'yes\')):\n    # do something\n\n# ...\n\nif browser.all(\'.i-will-appear\').wait_until(have.size_greater_than_or_equal(2)):\n    # do something\n```\n\nOr, by using non-waiting versions, if "you are in a rush:)":\n\n```python\nif browser.element(\'#i-might-say-yes-or-no\').matching(have.text(\'yes\')):\n    # do something\n\n# ...\n\nif browser.all(\'.i-will-appear\').matching(have.size_greater_than_or_equal(2)):\n    # do something\n```\n\n\n## Tutorials\n\nTBD\n\n## More examples\n\n* [Project template](https://github.com/yashaka/python-web-test)\n\nTBD\n\n## Contributing\n\n[see CONTRIBUTING.md](https://github.com/yashaka/selene/blob/master/CONTRIBUTING.md)\n\n## Release Process\n\n[see CONTRIBUTING.md#release-process](https://github.com/yashaka/selene/blob/master/CONTRIBUTING.md#release-process)\n\n## Changelog\n\n[see CHANGELOG.md](https://github.com/yashaka/selene/blob/master/CHANGELOG.md)\n',
    'author': 'Iakiv Kramarenko',
    'author_email': 'yashaka@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'http://github.com/yashaka/selene/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
