"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpNlbIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("aws-cdk-lib/aws-elasticloadbalancingv2");
const integration_1 = require("./private/integration");
/**
 * The Network Load Balancer integration resource for HTTP API
 */
class HttpNlbIntegration extends integration_1.HttpPrivateIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param listener the ELB network listener
     * @param props properties to configure the integration
     */
    constructor(id, listener, props = {}) {
        super(id);
        this.listener = listener;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_HttpNlbIntegrationProps(props);
    }
    bind(options) {
        var _b, _c;
        let vpc = (_b = this.props.vpcLink) === null || _b === void 0 ? void 0 : _b.vpc;
        if (!vpc && (this.listener instanceof elbv2.NetworkListener)) {
            vpc = this.listener.loadBalancer.vpc;
        }
        if (!vpc) {
            throw new Error('The vpcLink property must be specified when using an imported Network Listener.');
        }
        const vpcLink = this._configureVpcLink(options, {
            vpcLink: this.props.vpcLink,
            vpc,
        });
        return {
            method: (_c = this.props.method) !== null && _c !== void 0 ? _c : this.httpMethod,
            payloadFormatVersion: this.payloadFormatVersion,
            type: this.integrationType,
            connectionType: this.connectionType,
            connectionId: vpcLink.vpcLinkId,
            uri: this.listener.listenerArn,
            secureServerName: this.props.secureServerName,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
exports.HttpNlbIntegration = HttpNlbIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpNlbIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpNlbIntegration", version: "2.16.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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