"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const s3 = require("@aws-cdk/aws-s3");
const util_1 = require("../lib/util");
describe("bucketsToString", () => {
    it("returns an empty string when no buckets are present", () => {
        expect(util_1.bucketsToString()).toEqual("");
    });
    it("returns the bucket name when one bucket it present", () => {
        const app = new cdk.App();
        const stack = new cdk.Stack(app, "MyStack");
        const bucket = new s3.Bucket(stack, "MyBucket", {
            bucketName: "my-example-bucket-name",
        });
        expect(util_1.bucketsToString([bucket])).toEqual(bucket.bucketName);
    });
    it("concatenates bucket names with commas when multiple buckets are provided", () => {
        const app = new cdk.App();
        const stack = new cdk.Stack(app, "MyStack");
        const bucket1 = new s3.Bucket(stack, "MyFirstBucket", {
            bucketName: "first-bucket",
        });
        const bucket2 = new s3.Bucket(stack, "MySecondBucket", {
            bucketName: "second-bucket",
        });
        expect(util_1.bucketsToString([bucket1, bucket2])).toEqual(`${bucket1.bucketName},${bucket2.bucketName}`);
    });
});
//# sourceMappingURL=data:application/json;base64,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