import re
from codecs import open
from os import path, environ

from setuptools import setup

PACKAGE_NAME = "cookies_discord_components"
HERE = path.abspath(path.dirname(__file__))

with open("README.md", "r", encoding="utf-8") as f:
    README = f.read()

extras = {
    "lint": ["black", "flake8", "isort"],
    "readthedocs": ["sphinx", "sphinx-rtd-theme"],
}
extras["lint"] += extras["readthedocs"]
extras["dev"] = extras["lint"] + extras["readthedocs"]


setup(
    name=PACKAGE_NAME,
    version="3.0.0",
    author="kiki7000",
    author_email="devkiki7000@gmail.com",
    description="An unofficial library for discord components.",
    extras_require=extras,
    include_package_data=True,
    install_requires=["discord.py","aiohttp"],
    license="MIT License",
    long_description=README,
    long_description_content_type="text/markdown",
    url="https://github.com/kiki7000/discord.py-components",
    packages=["cookies_discord_components.ext"],
    python_requires=">=3.6",
    classifiers=[
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Natural Language :: English",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Topic :: Internet",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Software Development :: Libraries",
        "Topic :: Utilities",
    ],
)
