"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VaultUtils = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const environment_1 = require("./environment");
const LOCAL_VAULT_URL = 'http://localhost:3001';
const DEV_VAULT_URL = 'https://vault.dev.affinidi.com';
const PROD_VAULT_URL = 'https://vault.affinidi.com';
const envToWebVaultUrlMap = {
    [environment_1.Environment.LOCAL]: LOCAL_VAULT_URL,
    [environment_1.Environment.DEVELOPMENT]: DEV_VAULT_URL,
    [environment_1.Environment.PRODUCTION]: PROD_VAULT_URL,
};
const SHARE_PATH = '/login';
const CLAIM_PATH = '/claim';
class VaultUtils {
    static buildShareLink(request, client_id) {
        const env = environment_1.EnvironmentUtils.fetchEnvironment();
        const params = new URLSearchParams();
        params.append('request', request);
        params.append('client_id', client_id);
        const queryString = params.toString();
        return `${envToWebVaultUrlMap[env] || PROD_VAULT_URL}${SHARE_PATH}?${queryString}`;
    }
    static buildClaimLink(credentialOfferUri) {
        const env = environment_1.EnvironmentUtils.fetchEnvironment();
        const params = new URLSearchParams();
        params.append('credential_offer_uri', credentialOfferUri);
        const queryString = params.toString();
        return `${envToWebVaultUrlMap[env] || PROD_VAULT_URL}${CLAIM_PATH}?${queryString}`;
    }
}
exports.VaultUtils = VaultUtils;
_a = JSII_RTTI_SYMBOL_1;
VaultUtils[_a] = { fqn: "@affinidi-tdk/common.VaultUtils", version: "1.0.0" };
//# sourceMappingURL=data:application/json;base64,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