"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentUtils = exports.Environment = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
var Environment;
(function (Environment) {
    Environment["LOCAL"] = "local";
    Environment["DEVELOPMENT"] = "dev";
    Environment["PRODUCTION"] = "prod";
})(Environment || (exports.Environment = Environment = {}));
const DEFAULT_REGION = 'ap-southeast-1';
const envToApiGwUrl = {
    [Environment.LOCAL]: 'https://apse1.dev.api.affinidi.io',
    [Environment.DEVELOPMENT]: 'https://apse1.dev.api.affinidi.io',
    [Environment.PRODUCTION]: 'https://apse1.api.affinidi.io',
};
const envToElementsAuthTokenUrl = {
    [Environment.LOCAL]: 'https://apse1.dev.auth.developer.affinidi.io/auth/oauth2/token',
    [Environment.DEVELOPMENT]: 'https://apse1.dev.auth.developer.affinidi.io/auth/oauth2/token',
    [Environment.PRODUCTION]: 'https://apse1.auth.developer.affinidi.io/auth/oauth2/token',
};
const envToIotUrl = {
    [Environment.LOCAL]: 'a3sq1vuw0cw9an-ats.iot.ap-southeast-1.amazonaws.com',
    [Environment.DEVELOPMENT]: 'a3sq1vuw0cw9an-ats.iot.ap-southeast-1.amazonaws.com',
    [Environment.PRODUCTION]: 'a3sq1vuw0cw9an-ats.iot.ap-southeast-1.amazonaws.com',
};
class EnvironmentUtils {
    static fetchEnvironment() {
        const backendEnv = process.env.AFFINIDI_TDK_ENVIRONMENT;
        if (backendEnv) {
            return backendEnv;
        }
        const nextPublicEnv = process.env.NEXT_PUBLIC_AFFINIDI_TDK_ENVIRONMENT;
        if (nextPublicEnv) {
            return nextPublicEnv;
        }
        return Environment.PRODUCTION;
    }
    static fetchApiGwUrl() {
        const env = this.fetchEnvironment();
        return `${envToApiGwUrl[env]}`;
    }
    static fetchElementsAuthTokenUrl() {
        const env = this.fetchEnvironment();
        return `${envToElementsAuthTokenUrl[env]}`;
    }
    static fetchRegion() {
        return DEFAULT_REGION;
    }
    static fetchIotUrl() {
        const env = this.fetchEnvironment();
        return `${envToIotUrl[env]}`;
    }
}
exports.EnvironmentUtils = EnvironmentUtils;
_a = JSII_RTTI_SYMBOL_1;
EnvironmentUtils[_a] = { fqn: "@affinidi-tdk/common.EnvironmentUtils", version: "1.0.0" };
//# sourceMappingURL=data:application/json;base64,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