"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Jwt = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const axios_1 = require("axios");
const jwt = require("jsonwebtoken");
const jose = require("jose");
class Jwt {
    validateToken(token, publicKey) {
        try {
            jwt.verify(token, publicKey);
            return { isValid: true, isExpired: false };
        }
        catch (error) {
            if (error.name === 'TokenExpiredError') {
                return { isValid: false, isExpired: true };
            }
            return { isValid: false, isExpired: false };
        }
    }
    async fetchPublicKey(apiGatewayUrl) {
        const { data } = await (0, axios_1.default)(`${apiGatewayUrl}/iam/.well-known/jwks.json`, {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json',
            },
        });
        const hasKeys = data?.keys?.length > 0;
        if (hasKeys) {
            const jwk = data.keys[0];
            const ecPublicKey = (await jose.importJWK(jwk));
            const publickKeyPem = await jose.exportSPKI(ecPublicKey);
            return publickKeyPem;
        }
        return '';
    }
}
exports.Jwt = Jwt;
_a = JSII_RTTI_SYMBOL_1;
Jwt[_a] = { fqn: "@affinidi-tdk/auth-provider.Jwt", version: "1.17.0" };
//# sourceMappingURL=data:application/json;base64,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