"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Iota = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const uuid_1 = require("uuid");
const jwt = require("jsonwebtoken");
// TODO: export and config against supported values
const ALGORITHM = 'RS256';
class Iota {
    signIotaJwt(projectId, iotaConfigId, iotaSessionId, { tokenId, privateKey, passphrase, keyId, audience }) {
        const issueTimeInSeconds = Math.floor(new Date().getTime() / 1000);
        const payload = {
            iss: tokenId,
            sub: tokenId,
            kid: tokenId,
            aud: audience,
            jti: (0, uuid_1.v4)(),
            exp: issueTimeInSeconds + 5 * 60,
            iat: issueTimeInSeconds,
            project_id: projectId,
            iota_configuration_id: iotaConfigId,
            iota_session_id: iotaSessionId,
            scope: 'iota_channel',
        };
        let secret;
        if (passphrase) {
            secret = {
                key: privateKey,
                passphrase,
            };
        }
        else {
            secret = privateKey;
        }
        const token = jwt.sign(payload, secret, {
            algorithm: ALGORITHM,
            keyid: keyId,
        });
        return token;
    }
}
exports.Iota = Iota;
_a = JSII_RTTI_SYMBOL_1;
Iota[_a] = { fqn: "@affinidi-tdk/auth-provider.Iota", version: "1.17.0" };
//# sourceMappingURL=data:application/json;base64,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