"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectScopedToken = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const axios_1 = require("axios");
const jwt = require("jsonwebtoken");
const qs = require("qs");
// TODO: export and config against supported values
const ALGORITHM = 'RS256';
class ProjectScopedToken {
    async signPayload({ tokenId, audience, privateKey, passphrase, keyId, }) {
        const issueTimeInSeconds = Math.floor(new Date().getTime() / 1000);
        const payload = {
            iss: tokenId,
            sub: tokenId,
            aud: audience,
            jti: new Date().toString() + Math.random(),
            exp: issueTimeInSeconds + 5 * 60,
            iat: issueTimeInSeconds,
        };
        let secret;
        if (passphrase) {
            secret = {
                key: privateKey,
                passphrase,
            };
        }
        else {
            secret = privateKey;
        }
        const token = jwt.sign(payload, secret, {
            algorithm: ALGORITHM,
            keyid: keyId,
        });
        return token;
    }
    async getUserAccessToken({ tokenId, audience, privateKey, passphrase, keyId, }) {
        const token = await this.signPayload({
            tokenId,
            audience,
            privateKey,
            passphrase,
            keyId,
        });
        const input = qs.stringify({
            grant_type: 'client_credentials',
            scope: 'openid',
            client_assertion_type: 'urn:ietf:params:oauth:client-assertion-type:jwt-bearer',
            client_assertion: token,
            client_id: tokenId,
        });
        const { data } = await (0, axios_1.default)(audience, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            data: input,
        });
        return data.access_token;
    }
    async fetchProjectScopedToken({ apiGatewayUrl, projectId, tokenId, audience, privateKey, passphrase, keyId, }) {
        const userAccessToken = await this.getUserAccessToken({
            tokenId,
            audience,
            privateKey,
            passphrase,
            keyId,
        });
        const { data } = await (0, axios_1.default)(`${apiGatewayUrl}/iam/v1/sts/create-project-scoped-token`, {
            method: 'POST',
            headers: {
                Authorization: `Bearer ${userAccessToken}`,
                'Content-Type': 'application/json',
            },
            data: { projectId },
        });
        return data.accessToken;
    }
}
exports.ProjectScopedToken = ProjectScopedToken;
_a = JSII_RTTI_SYMBOL_1;
ProjectScopedToken[_a] = { fqn: "@affinidi-tdk/auth-provider.ProjectScopedToken", version: "1.17.0" };
//# sourceMappingURL=data:application/json;base64,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