"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const uuid_1 = require("uuid");
const helpers_1 = require("./helpers");
const common_1 = require("@affinidi-tdk/common");
class AuthProvider {
    constructor(param) {
        // NOTE: publicKey to validate projectScopedToken generated by Affinidi,
        //       need to fetch from Affinidi service
        this.publicKey = '';
        this.projectScopedToken = '';
        this.apiGatewayUrl = param?.apiGW ?? common_1.EnvironmentUtils.fetchApiGwUrl();
        this.tokenEndpoint =
            param?.tokenEndpoint ?? common_1.EnvironmentUtils.fetchElementsAuthTokenUrl();
        if (!param.privateKey || !param.projectId || !param.tokenId) {
            throw new Error('Missing parameters. Please provide privateKey, projectId and tokenId.');
        }
        this.projectId = param.projectId;
        this.tokenId = param.tokenId;
        this.keyId = param.keyId ?? param.tokenId;
        this.privateKey = param.privateKey;
        this.passphrase = param.passphrase;
        this.projectScopedTokenInstance = new helpers_1.ProjectScopedToken();
        this.jwt = new helpers_1.Jwt();
        this.iotaInstance = new helpers_1.Iota();
    }
    async shouldRefreshToken() {
        if (!this.publicKey) {
            this.publicKey = await this.jwt.fetchPublicKey(this.apiGatewayUrl);
        }
        const itExistsAndExpired = !!this.projectScopedToken &&
            this.jwt.validateToken(this.projectScopedToken, this.publicKey).isExpired;
        return !this.projectScopedToken || itExistsAndExpired;
    }
    async fetchProjectScopedToken() {
        const shouldRefreshToken = await this.shouldRefreshToken();
        if (shouldRefreshToken) {
            this.projectScopedToken =
                await this.projectScopedTokenInstance.fetchProjectScopedToken({
                    apiGatewayUrl: this.apiGatewayUrl,
                    keyId: this.keyId,
                    tokenId: this.tokenId,
                    passphrase: this.passphrase,
                    privateKey: this.privateKey,
                    projectId: this.projectId,
                    audience: this.tokenEndpoint,
                });
        }
        return this.projectScopedToken;
    }
    createIotaToken(iotaConfigId, did, iotaSessionId) {
        const sessionId = iotaSessionId ?? (0, uuid_1.v4)();
        return {
            iotaJwt: this.iotaInstance.signIotaJwt(this.projectId, iotaConfigId, sessionId, {
                keyId: this.keyId,
                tokenId: `token/${this.tokenId}`,
                passphrase: this.passphrase,
                privateKey: this.privateKey,
                audience: did,
            }),
            iotaSessionId: sessionId,
        };
    }
}
exports.AuthProvider = AuthProvider;
_a = JSII_RTTI_SYMBOL_1;
AuthProvider[_a] = { fqn: "@affinidi-tdk/auth-provider.AuthProvider", version: "1.17.0" };
//# sourceMappingURL=data:application/json;base64,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