import { ISignPayload } from './jwt';
export interface IFetchProjectScopedToken extends ISignPayload {
    apiGatewayUrl: string;
    projectId: string;
}
export declare class ProjectScopedToken {
    signPayload({ tokenId, audience, privateKey, passphrase, keyId, }: ISignPayload): Promise<string>;
    getUserAccessToken({ tokenId, audience, privateKey, passphrase, keyId, }: ISignPayload): Promise<any>;
    fetchProjectScopedToken({ apiGatewayUrl, projectId, tokenId, audience, privateKey, passphrase, keyId, }: IFetchProjectScopedToken): Promise<any>;
}
