export interface IotaTokenOutput {
    readonly iotaJwt: string;
    readonly iotaSessionId: string;
}
export interface IAuthProviderParams {
    projectId: string;
    tokenId: string;
    keyId?: string;
    privateKey: string;
    passphrase?: string;
    apiGatewayUrl?: string;
    tokenEndpoint?: string;
}
export declare class AuthProvider {
    private publicKey;
    private projectScopedToken;
    private readonly keyId;
    private readonly tokenId;
    private readonly passphrase;
    private readonly privateKey;
    private readonly projectId;
    private readonly apiGatewayUrl;
    private readonly tokenEndpoint;
    private readonly projectScopedTokenInstance;
    private readonly jwt;
    private readonly iotaInstance;
    constructor(param: {
        [key: string]: string;
    });
    private shouldRefreshToken;
    fetchProjectScopedToken(): Promise<string>;
    createIotaToken(iotaConfigId: string, did: string, iotaSessionId?: string): IotaTokenOutput;
}
