# ajv errors

```json
[
  {
    "instancePath": "/0/args",
    "keyword": "type",
    "message": "must be object",
    "params": {
      "type": "object"
    },
    "schemaPath": "#/oneOf/0/type"
  },
  {
    "instancePath": "/0/args",
    "keyword": "pattern",
    "message": "must match pattern \"^\\{\\{(.|[\r\n])*\\}\\}$\"",
    "params": {
      "pattern": "^\\{\\{(.|[\r\n])*\\}\\}$"
    },
    "schemaPath": "#/$defs/full-jinja/pattern"
  },
  {
    "instancePath": "/0/args",
    "keyword": "oneOf",
    "message": "must match exactly one schema in oneOf",
    "params": {
      "passingSchemas": null
    },
    "schemaPath": "#/oneOf"
  },
  {
    "instancePath": "/0",
    "keyword": "required",
    "message": "must have required property 'block'",
    "params": {
      "missingProperty": "block"
    },
    "schemaPath": "#/required"
  },
  {
    "instancePath": "/0",
    "keyword": "anyOf",
    "message": "must match a schema in anyOf",
    "params": {},
    "schemaPath": "#/items/anyOf"
  }
]
```

# check-jsonschema

stdout:

```json
{
  "status": "fail",
  "errors": [
    {
      "filename": "negative_test/playbooks/tasks/args_string.yml",
      "path": "$[0]",
      "message": "{'action': 'foo', 'args': '{{ }}123'} is not valid under any of the given schemas",
      "has_sub_errors": true,
      "best_match": {
        "path": "$[0]",
        "message": "'block' is a required property"
      },
      "sub_errors": [
        {
          "path": "$[0].args",
          "message": "'{{ }}123' is not valid under any of the given schemas"
        },
        {
          "path": "$[0].args",
          "message": "'{{ }}123' is not of type 'object'"
        },
        {
          "path": "$[0].args",
          "message": "'{{ }}123' does not match '^\\\\{\\\\{(.|[\\r\\n])*\\\\}\\\\}$'"
        },
        {
          "path": "$[0]",
          "message": "'block' is a required property"
        }
      ]
    }
  ],
  "parse_errors": []
}
```
