![PyThia Logo Full](logo/logo_full_transparent.png)

# Uncertainty Quantification Toolbox

The PyThia UQ toolbox uses polynomial chaos surrogates to efficiently generate
a surrogate of any (parametric) forward problem.  The surrogate is fast du
evaluate, allows analytical differentiation and has a built-in global
sensitivity analysis via Sobol indices.  Assembling the surrogate is done
non-intrusive by least-squares regression, hence only training pairs of of
parameter realizations and evaluations of the forward problem are required to
construct the surrogate. No need to compute any nasty interfaces for lagacy
code.

## Why the Name?

Pythia was the title of the high priestess of the temple of Apollo in Delphi.
Hence you could say she used her prophetic abilities to quantify which was
uncertain.  Moreover, the package is written in python, so...

## Installation of PyThia

If using Anaconda, simply clone the repository and create a new environment
called `pythia` with `pip` installed
```shell
conda create --name pythia pip
```
Activate the environment with `conda activate pythia` and run the setup script
to install PyThia to any environment
```shell
cd path/to/pythia
pip install .
```
PyThia can then be imported from any location with `import pythia`.

## Documentation of PyThia

The documentation can be generated automatically using ``sphinx``.
Assuming you have `sphinx` and the `sphinx_rtd_theme` installed, the
documentation can be generated by
```shell
cd docs
make html
```
To view the documentation locally, open `docs/build/html/index.html` in the
browser of your choice.

## Want to contribute?

Check out the [contribution guidelines](CONTRIBUTING.md) on how to create
issues or file bug reports and feature requests.
Or ever better start developping the PyThia project yourself after reading the
[development guidelines](DEVELOPERS.md).

## Roadmap and TODOs

Before the first official release there are several TODOs that need to be dealt
with:
  - [x] add (correct) **LICENSE** file for the package according to PTB regulations
  - [x] add **CODE_OF_CONDUCT** and guides for **CONTRIBUTING** and **DEVELOPERS**
  - [x] add **CHANGELOG** to clarify what and when things were changed
  - [x] fix a ![branching model](https://guides.github.com/introduction/flow/) and update the description of it in **DEVELOPERS**
  - [x] fix a ![release policy](https://docs.github.com/en/repositories/releasing-projects-on-github)
  - [ ] upon release, make the project available at ![PyPI.org](https://pypi.org/) for easy `pip` installation
      - [ ] make it easy to install different versions
  - [ ] make the code citeable
  - [ ] automatically install dependencies (Numpy and SciPy versions)

After making the project public, there are a few necessary user experience
changes that should be done:
  - [ ] create ![stack overflow](https://stackoverflow.com/) hashtag for `PyThia`
  - [ ] create a homepage
  - [ ] add tutorials (jupyter notebook and as downloadable `.py` file) to homepage
  - [x] add docstrings to the code and clean the superficially to make it more readable **without changing any functionality**
  - [x] create an auto-doc with ![Sphinx](https://www.sphinx-doc.org/en/master/)
  - [ ] write unit, mock and integration tests
  - [ ] use CD and CI to test and deploy new releases of pythia
  - [ ] create html-doc automatically when new version is released and upload it to Homepage

Finally, here is a roadmap of features that we plan to add to pythia in the future.
  - [ ] speed up evaluation of basis polynomials
  - [ ] integrate tensor train representations of coefficients
  - [ ] add tensor train regression (VMC)
  - [ ] add exponentiation of tensor trains (expTT)
  - [ ] add efficient posterior rejection sampling for tensor trains posteriors (Dolgov paper)

## References

Here we list the papers that describe concepts implemented in **PyThia** for 
the interested user. In principle **PyThia** uses a (sparse) polynomial chaos
expansion to construct a surrogate of any function via least-squares regression.
We first applied the **PyThia** software package to analyse the sensitivities
of a scatterometry experiment [^pythia-scat-A] using global sensitivity
analysis via Sobol indices [^sobol-indices]. We also solved the inverse problem for the same experiment [^pythia-scat-B]
via Bayesian inversion. To use a minimal but still sufficient amount of random
samples for the regression, we integrated weighted least-squares sampling [^wls-sampling]
into **PyThia**.

[^pythia-scat-A]: [An efficient approach to global sensitivity analysis and parameter estimation for line gratings](https://arxiv.org/abs/1910.14435)
[^pythia-scat-B]: [Efficient Bayesian inversion for shape reconstruction of lithography masks](https://arxiv.org/abs/2005.05164)
[^sobol-indices]: [Global sensitivity analysis using polynomial chaos expansions](https://www.sciencedirect.com/science/article/abs/pii/S0951832007001329)
[^wls-sampling]: [Optimal weighted least-squares methods](https://arxiv.org/abs/1608.00512)
