# coding: utf-8

"""
    xpctl

    This is a sample xpctl  server.  You can find out more about xpctl at [baseline](https://github.com/dpressel/baseline/blob/master/docs/xpctl.md).  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: apiteam@swagger.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from xpctl.xpclient.api_client import ApiClient


class XpctlApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def config2json(self, task, sha1, **kwargs):  # noqa: E501
        """get config for sha1  # noqa: E501

        config for sha1  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config2json(task, sha1, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task: task (required)
        :param str sha1: sha1 (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.config2json_with_http_info(task, sha1, **kwargs)  # noqa: E501
        else:
            (data) = self.config2json_with_http_info(task, sha1, **kwargs)  # noqa: E501
            return data

    def config2json_with_http_info(self, task, sha1, **kwargs):  # noqa: E501
        """get config for sha1  # noqa: E501

        config for sha1  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config2json_with_http_info(task, sha1, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task: task (required)
        :param str sha1: sha1 (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task', 'sha1']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config2json" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task' is set
        if ('task' not in params or
                params['task'] is None):
            raise ValueError("Missing the required parameter `task` when calling `config2json`")  # noqa: E501
        # verify the required parameter 'sha1' is set
        if ('sha1' not in params or
                params['sha1'] is None):
            raise ValueError("Missing the required parameter `sha1` when calling `config2json`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task' in params:
            path_params['task'] = params['task']  # noqa: E501
        if 'sha1' in params:
            path_params['sha1'] = params['sha1']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/config2json/{task}/{sha1}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def experiment_details(self, task, eid, **kwargs):  # noqa: E501
        """Find experiment by id  # noqa: E501

        Returns a single experiment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.experiment_details(task, eid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task: task name (required)
        :param str eid: ID of experiment to return (required)
        :param str event_type: 
        :param list[str] metric: 
        :return: Experiment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.experiment_details_with_http_info(task, eid, **kwargs)  # noqa: E501
        else:
            (data) = self.experiment_details_with_http_info(task, eid, **kwargs)  # noqa: E501
            return data

    def experiment_details_with_http_info(self, task, eid, **kwargs):  # noqa: E501
        """Find experiment by id  # noqa: E501

        Returns a single experiment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.experiment_details_with_http_info(task, eid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task: task name (required)
        :param str eid: ID of experiment to return (required)
        :param str event_type: 
        :param list[str] metric: 
        :return: Experiment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task', 'eid', 'event_type', 'metric']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method experiment_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task' is set
        if ('task' not in params or
                params['task'] is None):
            raise ValueError("Missing the required parameter `task` when calling `experiment_details`")  # noqa: E501
        # verify the required parameter 'eid' is set
        if ('eid' not in params or
                params['eid'] is None):
            raise ValueError("Missing the required parameter `eid` when calling `experiment_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task' in params:
            path_params['task'] = params['task']  # noqa: E501
        if 'eid' in params:
            path_params['eid'] = params['eid']  # noqa: E501

        query_params = []
        if 'event_type' in params:
            query_params.append(('event_type', params['event_type']))  # noqa: E501
        if 'metric' in params:
            query_params.append(('metric', params['metric']))  # noqa: E501
            collection_formats['metric'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/{task}/{eid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Experiment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_model_location(self, task, eid, **kwargs):  # noqa: E501
        """get model loc for experiment  # noqa: E501

        get model loc for experiment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_location(task, eid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task: task (required)
        :param str eid: experiment id (required)
        :return: Response
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_model_location_with_http_info(task, eid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_model_location_with_http_info(task, eid, **kwargs)  # noqa: E501
            return data

    def get_model_location_with_http_info(self, task, eid, **kwargs):  # noqa: E501
        """get model loc for experiment  # noqa: E501

        get model loc for experiment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_model_location_with_http_info(task, eid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task: task (required)
        :param str eid: experiment id (required)
        :return: Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task', 'eid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_model_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task' is set
        if ('task' not in params or
                params['task'] is None):
            raise ValueError("Missing the required parameter `task` when calling `get_model_location`")  # noqa: E501
        # verify the required parameter 'eid' is set
        if ('eid' not in params or
                params['eid'] is None):
            raise ValueError("Missing the required parameter `eid` when calling `get_model_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task' in params:
            path_params['task'] = params['task']  # noqa: E501
        if 'eid' in params:
            path_params['eid'] = params['eid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/getmodelloc/{task}/{eid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Response',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_results_by_prop(self, task, **kwargs):  # noqa: E501
        """Find results by property and value  # noqa: E501

        Find results by property and value  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_results_by_prop(task, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task: task name (required)
        :param str eid: eid
        :param str sha1: sha1
        :param str dataset: dataset, e.g. SST2
        :param str label: label
        :param str reduction_dim: which dimension to reduce on, default=sha1
        :param list[str] metric: metric
        :param str sort: metric to sort results on
        :param int numexp_reduction_dim: max number of experiments in an aggregate group
        :param str event_type: train/dev/test
        :return: list[ExperimentAggregate]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_results_by_prop_with_http_info(task, **kwargs)  # noqa: E501
        else:
            (data) = self.get_results_by_prop_with_http_info(task, **kwargs)  # noqa: E501
            return data

    def get_results_by_prop_with_http_info(self, task, **kwargs):  # noqa: E501
        """Find results by property and value  # noqa: E501

        Find results by property and value  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_results_by_prop_with_http_info(task, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task: task name (required)
        :param str eid: eid
        :param str sha1: sha1
        :param str dataset: dataset, e.g. SST2
        :param str label: label
        :param str reduction_dim: which dimension to reduce on, default=sha1
        :param list[str] metric: metric
        :param str sort: metric to sort results on
        :param int numexp_reduction_dim: max number of experiments in an aggregate group
        :param str event_type: train/dev/test
        :return: list[ExperimentAggregate]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task', 'eid', 'sha1', 'dataset', 'label', 'reduction_dim', 'metric', 'sort', 'numexp_reduction_dim', 'event_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_results_by_prop" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task' is set
        if ('task' not in params or
                params['task'] is None):
            raise ValueError("Missing the required parameter `task` when calling `get_results_by_prop`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task' in params:
            path_params['task'] = params['task']  # noqa: E501

        query_params = []
        if 'eid' in params:
            query_params.append(('eid', params['eid']))  # noqa: E501
        if 'sha1' in params:
            query_params.append(('sha1', params['sha1']))  # noqa: E501
        if 'dataset' in params:
            query_params.append(('dataset', params['dataset']))  # noqa: E501
        if 'label' in params:
            query_params.append(('label', params['label']))  # noqa: E501
        if 'reduction_dim' in params:
            query_params.append(('reduction_dim', params['reduction_dim']))  # noqa: E501
        if 'metric' in params:
            query_params.append(('metric', params['metric']))  # noqa: E501
            collection_formats['metric'] = 'csv'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'numexp_reduction_dim' in params:
            query_params.append(('numexp_reduction_dim', params['numexp_reduction_dim']))  # noqa: E501
        if 'event_type' in params:
            query_params.append(('event_type', params['event_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/results/{task}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ExperimentAggregate]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_experiments_by_prop(self, task, **kwargs):  # noqa: E501
        """list all experiments for this property and value  # noqa: E501

        list all experiments for this property (sha1/ username) and value (1cd21df91770b4dbed64a683558b062e3dee61f0/ dpressel)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_experiments_by_prop(task, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task: task name (required)
        :param str eid: eid
        :param str sha1: sha1
        :param str dataset: dataset, e.g. SST2
        :param str label: label
        :param list[str] user:
        :param list[str] metric:
        :param str sort:
        :param str event_type:
        :return: list[Experiment]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_experiments_by_prop_with_http_info(task, **kwargs)  # noqa: E501
        else:
            (data) = self.list_experiments_by_prop_with_http_info(task, **kwargs)  # noqa: E501
            return data

    def list_experiments_by_prop_with_http_info(self, task, **kwargs):  # noqa: E501
        """list all experiments for this property and value  # noqa: E501

        list all experiments for this property (sha1/ username) and value (1cd21df91770b4dbed64a683558b062e3dee61f0/ dpressel)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_experiments_by_prop_with_http_info(task, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task: task name (required)
        :param str eid: eid
        :param str sha1: sha1
        :param str dataset: dataset, e.g. SST2
        :param str label: label
        :param list[str] user:
        :param list[str] metric:
        :param str sort:
        :param str event_type:
        :return: list[Experiment]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task', 'eid', 'sha1', 'dataset', 'label', 'user', 'metric', 'sort', 'event_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_experiments_by_prop" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task' is set
        if ('task' not in params or
                params['task'] is None):
            raise ValueError("Missing the required parameter `task` when calling `list_experiments_by_prop`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task' in params:
            path_params['task'] = params['task']  # noqa: E501

        query_params = []
        if 'eid' in params:
            query_params.append(('eid', params['eid']))  # noqa: E501
        if 'sha1' in params:
            query_params.append(('sha1', params['sha1']))  # noqa: E501
        if 'dataset' in params:
            query_params.append(('dataset', params['dataset']))  # noqa: E501
        if 'label' in params:
            query_params.append(('label', params['label']))  # noqa: E501
        if 'user' in params:
            query_params.append(('user', params['user']))  # noqa: E501
            collection_formats['user'] = 'csv'  # noqa: E501
        if 'metric' in params:
            query_params.append(('metric', params['metric']))  # noqa: E501
            collection_formats['metric'] = 'csv'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'event_type' in params:
            query_params.append(('event_type', params['event_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/find/{task}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Experiment]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_result(self, task, experiment, **kwargs):  # noqa: E501
        """Add a new experiment in database  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_result(task, experiment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task:  (required)
        :param Experiment experiment: (required)
        :param str user: 
        :param str label: 
        :return: Response
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_result_with_http_info(task, experiment, **kwargs)  # noqa: E501
        else:
            (data) = self.put_result_with_http_info(task, experiment, **kwargs)  # noqa: E501
            return data

    def put_result_with_http_info(self, task, experiment, **kwargs):  # noqa: E501
        """Add a new experiment in database  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_result_with_http_info(task, experiment, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task:  (required)
        :param Experiment experiment: (required)
        :param str user: 
        :param str label: 
        :return: Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task', 'experiment', 'user', 'label']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_result" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task' is set
        if ('task' not in params or
                params['task'] is None):
            raise ValueError("Missing the required parameter `task` when calling `put_result`")  # noqa: E501
        # verify the required parameter 'experiment' is set
        if ('experiment' not in params or
                params['experiment'] is None):
            raise ValueError("Missing the required parameter `experiment` when calling `put_result`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task' in params:
            path_params['task'] = params['task']  # noqa: E501

        query_params = []
        if 'user' in params:
            query_params.append(('user', params['user']))  # noqa: E501
        if 'label' in params:
            query_params.append(('label', params['label']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'experiment' in params:
            body_params = params['experiment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/put/{task}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Response',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_experiment(self, task, eid, **kwargs):  # noqa: E501
        """delete an experiment from the database  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_experiment(task, eid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task:  (required)
        :param str eid:  (required)
        :return: Response
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_experiment_with_http_info(task, eid, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_experiment_with_http_info(task, eid, **kwargs)  # noqa: E501
            return data

    def remove_experiment_with_http_info(self, task, eid, **kwargs):  # noqa: E501
        """delete an experiment from the database  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_experiment_with_http_info(task, eid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task:  (required)
        :param str eid:  (required)
        :return: Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task', 'eid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_experiment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task' is set
        if ('task' not in params or
                params['task'] is None):
            raise ValueError("Missing the required parameter `task` when calling `remove_experiment`")  # noqa: E501
        # verify the required parameter 'eid' is set
        if ('eid' not in params or
                params['eid'] is None):
            raise ValueError("Missing the required parameter `eid` when calling `remove_experiment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task' in params:
            path_params['task'] = params['task']  # noqa: E501
        if 'eid' in params:
            path_params['eid'] = params['eid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/delete/{task}/{eid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Response',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def summary(self, **kwargs):  # noqa: E501
        """get summary for task  # noqa: E501

        summary for task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.summary(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[TaskSummary]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.summary_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.summary_with_http_info(**kwargs)  # noqa: E501
            return data

    def summary_with_http_info(self, **kwargs):  # noqa: E501
        """get summary for task  # noqa: E501

        summary for task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.summary_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[TaskSummary]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method summary" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/summary/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TaskSummary]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def task_summary(self, task, **kwargs):  # noqa: E501
        """get summary for task  # noqa: E501

        summary for task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.task_summary(task, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task: task (required)
        :return: TaskSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.task_summary_with_http_info(task, **kwargs)  # noqa: E501
        else:
            (data) = self.task_summary_with_http_info(task, **kwargs)  # noqa: E501
            return data

    def task_summary_with_http_info(self, task, **kwargs):  # noqa: E501
        """get summary for task  # noqa: E501

        summary for task  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.task_summary_with_http_info(task, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task: task (required)
        :return: TaskSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method task_summary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task' is set
        if ('task' not in params or
                params['task'] is None):
            raise ValueError("Missing the required parameter `task` when calling `task_summary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task' in params:
            path_params['task'] = params['task']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/summary/{task}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_property(self, task, eid, prop, value, **kwargs):  # noqa: E501
        """update property for an experiment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_property(task, eid, prop, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task:  (required)
        :param str eid:  (required)
        :param str prop:  (required)
        :param str value:  (required)
        :return: Response
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_property_with_http_info(task, eid, prop, value, **kwargs)  # noqa: E501
        else:
            (data) = self.update_property_with_http_info(task, eid, prop, value, **kwargs)  # noqa: E501
            return data

    def update_property_with_http_info(self, task, eid, prop, value, **kwargs):  # noqa: E501
        """update property for an experiment  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_property_with_http_info(task, eid, prop, value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task:  (required)
        :param str eid:  (required)
        :param str prop:  (required)
        :param str value:  (required)
        :return: Response
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task', 'eid', 'prop', 'value']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_property" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task' is set
        if ('task' not in params or
                params['task'] is None):
            raise ValueError("Missing the required parameter `task` when calling `update_property`")  # noqa: E501
        # verify the required parameter 'eid' is set
        if ('eid' not in params or
                params['eid'] is None):
            raise ValueError("Missing the required parameter `eid` when calling `update_property`")  # noqa: E501
        # verify the required parameter 'prop' is set
        if ('prop' not in params or
                params['prop'] is None):
            raise ValueError("Missing the required parameter `prop` when calling `update_property`")  # noqa: E501
        # verify the required parameter 'value' is set
        if ('value' not in params or
                params['value'] is None):
            raise ValueError("Missing the required parameter `value` when calling `update_property`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task' in params:
            path_params['task'] = params['task']  # noqa: E501
        if 'eid' in params:
            path_params['eid'] = params['eid']  # noqa: E501

        query_params = []
        if 'prop' in params:
            query_params.append(('prop', params['prop']))  # noqa: E501
        if 'value' in params:
            query_params.append(('value', params['value']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/update/{task}/{eid}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Response',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
