"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PushImageProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codebuild_1 = require("@aws-cdk/aws-codebuild");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const build_spec_generator_1 = require("./build-spec-generator");
class PushImageProject extends aws_codebuild_1.PipelineProject {
    constructor(scope, id, props) {
        const { account, region } = core_1.Stack.of(scope);
        super(scope, id, {
            projectName: props.projectName,
            cache: props.cache || aws_codebuild_1.Cache.local(aws_codebuild_1.LocalCacheMode.DOCKER_LAYER, aws_codebuild_1.LocalCacheMode.CUSTOM),
            buildSpec: props.buildSpec || aws_codebuild_1.BuildSpec.fromObject(build_spec_generator_1.BuildSpecGenerator.default({ account, region }).render()),
            environment: {
                buildImage: aws_codebuild_1.LinuxBuildImage.STANDARD_4_0,
                computeType: props.computeType || aws_codebuild_1.ComputeType.SMALL,
                privileged: true,
                environmentVariables: {
                    AWS_ACCOUNT_ID: {
                        type: aws_codebuild_1.BuildEnvironmentVariableType.PLAINTEXT,
                        value: account,
                    },
                    EXECUTION_ROLE_ARN: {
                        type: aws_codebuild_1.BuildEnvironmentVariableType.PLAINTEXT,
                        value: props.taskDefinition.executionRole.roleArn,
                    },
                    FAMILY: {
                        type: aws_codebuild_1.BuildEnvironmentVariableType.PLAINTEXT,
                        value: props.taskDefinition.family,
                    },
                    REPOSITORY_URI: {
                        type: aws_codebuild_1.BuildEnvironmentVariableType.PLAINTEXT,
                        value: props.imageRepository.repositoryUri,
                    },
                    ...props.environmentVariables,
                },
            },
        });
        this.addToRolePolicy(new aws_iam_1.PolicyStatement({
            actions: ['ecr:GetAuthorizationToken'],
            resources: ['*'],
        }));
        this.addToRolePolicy(new aws_iam_1.PolicyStatement({
            actions: [
                'ecr:GetDownloadUrlForLayer',
                'ecr:BatchGetImage',
                'ecr:BatchCheckLayerAvailability',
                'ecr:PutImage',
                'ecr:InitiateLayerUpload',
                'ecr:UploadLayerPart',
                'ecr:CompleteLayerUpload',
            ],
            resources: [props.imageRepository.repositoryArn],
        }));
    }
}
exports.PushImageProject = PushImageProject;
_a = JSII_RTTI_SYMBOL_1;
PushImageProject[_a] = { fqn: "@cloudcomponents/cdk-blue-green-container-deployment.PushImageProject", version: "1.26.0" };
//# sourceMappingURL=data:application/json;base64,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