"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RollbackEvent = exports.EcsDeploymentGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_codedeploy_1 = require("@aws-cdk/aws-codedeploy");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
class EcsDeploymentGroup extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const { applicationName, deploymentGroupName, deploymentConfig, ecsServices, targetGroupNames, prodTrafficListener, testTrafficListener, terminationWaitTimeInMinutes = 60, autoRollbackOnEvents, } = props;
        if (terminationWaitTimeInMinutes > 2880) {
            throw new Error('Invalid TerminationWaitTimeInMinutes: The maximum setting is 2880 minutes (2 days).');
        }
        const codeDeployEcsRole = new aws_iam_1.Role(this, 'EcsCodeDeployRole', {
            assumedBy: new aws_iam_1.ServicePrincipal('codedeploy.amazonaws.com'),
            managedPolicies: [aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AWSCodeDeployRoleForECS')],
        });
        this.application = new aws_codedeploy_1.EcsApplication(this, 'EcsApplication', {
            applicationName,
        });
        const serviceToken = core_1.CustomResourceProvider.getOrCreate(this, 'Custom::EcsDeploymentGroup', {
            codeDirectory: path.join(__dirname, 'lambdas', 'ecs-deployment-group'),
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_12,
            policyStatements: [
                {
                    Effect: aws_iam_1.Effect.ALLOW,
                    Action: ['codeDeploy:CreateDeploymentGroup', 'codeDeploy:UpdateDeploymentGroup', 'codeDeploy:DeleteDeploymentGroup'],
                    Resource: '*',
                },
                {
                    Effect: aws_iam_1.Effect.ALLOW,
                    Action: ['iam:PassRole'],
                    Resource: codeDeployEcsRole.roleArn,
                },
            ],
        });
        const ecsDeploymentGroup = new core_1.CustomResource(this, 'CustomResource', {
            serviceToken,
            resourceType: 'Custom::EcsDeploymentGroup',
            properties: {
                ApplicationName: this.application.applicationName,
                DeploymentGroupName: deploymentGroupName,
                ServiceRoleArn: codeDeployEcsRole.roleArn,
                TargetGroupNames: targetGroupNames,
                EcsServices: ecsServices.map((service) => ({
                    ClusterName: service.clusterName,
                    ServiceName: service.serviceName,
                })),
                ProdTrafficListenerArn: prodTrafficListener.listenerArn,
                TestTrafficListenerArn: testTrafficListener.listenerArn,
                TerminationWaitTimeInMinutes: terminationWaitTimeInMinutes,
                AutoRollbackOnEvents: autoRollbackOnEvents,
            },
        });
        this.deploymentGroupName = ecsDeploymentGroup.ref;
        this.deploymentGroupArn = this.arnForDeploymentGroup(this.application.applicationName, this.deploymentGroupName);
        this.deploymentConfig = deploymentConfig || aws_codedeploy_1.EcsDeploymentConfig.ALL_AT_ONCE;
    }
    arnForDeploymentGroup(applicationName, deploymentGroupName) {
        return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentgroup:${applicationName}/${deploymentGroupName}`;
    }
}
exports.EcsDeploymentGroup = EcsDeploymentGroup;
_a = JSII_RTTI_SYMBOL_1;
EcsDeploymentGroup[_a] = { fqn: "@cloudcomponents/cdk-blue-green-container-deployment.EcsDeploymentGroup", version: "1.26.0" };
var RollbackEvent;
(function (RollbackEvent) {
    RollbackEvent["DEPLOYMENT_FAILURE"] = "DEPLOYMENT_FAILURE";
    RollbackEvent["DEPLOYMENT_STOP_ON_ALARM"] = "DEPLOYMENT_STOP_ON_ALARM";
    RollbackEvent["DEPLOYMENT_STOP_ON_REQUEST"] = "DEPLOYMENT_STOP_ON_REQUEST";
})(RollbackEvent = exports.RollbackEvent || (exports.RollbackEvent = {}));
//# sourceMappingURL=data:application/json;base64,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