# coding: utf-8

"""
    LogicMonitor API-Ingest Rest API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. API-Ingest provides the entry point in the form of public rest APIs for ingesting metrics into LogicMonitor. For using this application users have to create LMAuth token using access id and key from santaba.  # noqa: E501

    OpenAPI spec version: 3.0.0

"""

import pprint
import re  # noqa: F401

import six

from logicmonitor_data_sdk.models.list_rest_data_point_v1 import \
  ListRestDataPointV1  # noqa: F401,E501
from logicmonitor_data_sdk.models.map_string_string import \
  MapStringString  # noqa: F401,E501


class RestDataSourceInstanceV1(object):
  """NOTE: This class is auto generated by the swagger code generator program.

  Do not edit the class manually.
  """

  """
  Attributes:
    swagger_types (dict): The key is attribute name
                          and the value is attribute type.
    attribute_map (dict): The key is attribute name
                          and the value is json key in definition.
  """
  swagger_types = {
    'data_points': 'ListRestDataPointV1',
    'instance_description': 'str',
    'instance_display_name': 'str',
    'instance_group': 'str',
    'instance_name': 'str',
    'instance_properties': 'MapStringString'
  }

  attribute_map = {
    'data_points': 'dataPoints',
    'instance_description': 'instanceDescription',
    'instance_display_name': 'instanceDisplayName',
    'instance_group': 'instanceGroup',
    'instance_name': 'instanceName',
    'instance_properties': 'instanceProperties'
  }

  def __init__(self, data_points=None, instance_description=None,
      instance_display_name=None, instance_group=None, instance_name=None,
      instance_properties=None):  # noqa: E501
    """RestDataSourceInstanceV1 - a model defined in Swagger"""  # noqa: E501

    self._data_points = None
    self._instance_description = None
    self._instance_display_name = None
    self._instance_group = None
    self._instance_name = None
    self._instance_properties = None
    self.discriminator = None

    if data_points is not None:
      self.data_points = data_points
    if instance_description is not None:
      self.instance_description = instance_description
    if instance_display_name is not None:
      self.instance_display_name = instance_display_name
    if instance_group is not None:
      self.instance_group = instance_group
    if instance_name is not None:
      self.instance_name = instance_name
    if instance_properties is not None:
      self.instance_properties = instance_properties

  @property
  def data_points(self):
    """Gets the data_points of this RestDataSourceInstanceV1.  # noqa: E501


    :return: The data_points of this RestDataSourceInstanceV1.  # noqa: E501
    :rtype: ListRestDataPointV1
    """
    return self._data_points

  @data_points.setter
  def data_points(self, data_points):
    """Sets the data_points of this RestDataSourceInstanceV1.


    :param data_points: The data_points of this RestDataSourceInstanceV1.  # noqa: E501
    :type: ListRestDataPointV1
    """

    self._data_points = data_points

  @property
  def instance_description(self):
    """Gets the instance_description of this RestDataSourceInstanceV1.  # noqa: E501


    :return: The instance_description of this RestDataSourceInstanceV1.  # noqa: E501
    :rtype: str
    """
    return self._instance_description

  @instance_description.setter
  def instance_description(self, instance_description):
    """Sets the instance_description of this RestDataSourceInstanceV1.


    :param instance_description: The instance_description of this RestDataSourceInstanceV1.  # noqa: E501
    :type: str
    """

    self._instance_description = instance_description

  @property
  def instance_display_name(self):
    """Gets the instance_display_name of this RestDataSourceInstanceV1.  # noqa: E501


    :return: The instance_display_name of this RestDataSourceInstanceV1.  # noqa: E501
    :rtype: str
    """
    return self._instance_display_name

  @instance_display_name.setter
  def instance_display_name(self, instance_display_name):
    """Sets the instance_display_name of this RestDataSourceInstanceV1.


    :param instance_display_name: The instance_display_name of this RestDataSourceInstanceV1.  # noqa: E501
    :type: str
    """

    self._instance_display_name = instance_display_name

  @property
  def instance_group(self):
    """Gets the instance_group of this RestDataSourceInstanceV1.  # noqa: E501


    :return: The instance_group of this RestDataSourceInstanceV1.  # noqa: E501
    :rtype: str
    """
    return self._instance_group

  @instance_group.setter
  def instance_group(self, instance_group):
    """Sets the instance_group of this RestDataSourceInstanceV1.


    :param instance_group: The instance_group of this RestDataSourceInstanceV1.  # noqa: E501
    :type: str
    """

    self._instance_group = instance_group

  @property
  def instance_name(self):
    """Gets the instance_name of this RestDataSourceInstanceV1.  # noqa: E501


    :return: The instance_name of this RestDataSourceInstanceV1.  # noqa: E501
    :rtype: str
    """
    return self._instance_name

  @instance_name.setter
  def instance_name(self, instance_name):
    """Sets the instance_name of this RestDataSourceInstanceV1.


    :param instance_name: The instance_name of this RestDataSourceInstanceV1.  # noqa: E501
    :type: str
    """

    self._instance_name = instance_name

  @property
  def instance_properties(self):
    """Gets the instance_properties of this RestDataSourceInstanceV1.  # noqa: E501


    :return: The instance_properties of this RestDataSourceInstanceV1.  # noqa: E501
    :rtype: MapStringString
    """
    return self._instance_properties

  @instance_properties.setter
  def instance_properties(self, instance_properties):
    """Sets the instance_properties of this RestDataSourceInstanceV1.


    :param instance_properties: The instance_properties of this RestDataSourceInstanceV1.  # noqa: E501
    :type: MapStringString
    """

    self._instance_properties = instance_properties

  def to_dict(self):
    """Returns the model properties as a dict"""
    result = {}

    for attr, _ in six.iteritems(self.swagger_types):
      value = getattr(self, attr)
      if isinstance(value, list):
        result[attr] = list(map(
            lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
            value
        ))
      elif hasattr(value, "to_dict"):
        result[attr] = value.to_dict()
      elif isinstance(value, dict):
        result[attr] = dict(map(
            lambda item: (item[0], item[1].to_dict())
            if hasattr(item[1], "to_dict") else item,
            value.items()
        ))
      else:
        result[attr] = value
    if issubclass(RestDataSourceInstanceV1, dict):
      for key, value in self.items():
        result[key] = value

    return result

  def to_str(self):
    """Returns the string representation of the model"""
    return pprint.pformat(self.to_dict())

  def __repr__(self):
    """For `print` and `pprint`"""
    return self.to_str()

  def __eq__(self, other):
    """Returns true if both objects are equal"""
    if not isinstance(other, RestDataSourceInstanceV1):
      return False

    return self.__dict__ == other.__dict__

  def __ne__(self, other):
    """Returns true if both objects are not equal"""
    return not self == other
