/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.base.data.ILiteratureEntry;
import ambit2.base.data.LiteratureEntry;
import ambit2.base.data.Property;
import ambit2.base.data.StructureRecord;
import ambit2.base.interfaces.IStructureRecord;
import ambit2.base.processors.CASProcessor;
import ambit2.core.io.IRawReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;

public class ECHAPreregistrationListReader
extends DefaultIteratingChemObjectReader
implements IRawReader<IStructureRecord> {
    protected XMLStreamReader reader;
    protected static String ECHA_URL = "http://apps.echa.europa.eu/preregistered/prsDownload.aspx";
    protected static String ECHA_REFERENCE = "ECHA";
    protected ArrayList<String> synonyms = new ArrayList();
    protected IStructureRecord record;
    protected String tmpValue = "";
    protected CASProcessor casProcessor = new CASProcessor();
    protected Property casProperty = Property.getInstance((String)"CasRN", (ILiteratureEntry)LiteratureEntry.getInstance((String)ECHA_REFERENCE, (String)ECHA_URL));
    protected Property ecProperty = Property.getInstance((String)"EC", (ILiteratureEntry)LiteratureEntry.getInstance((String)ECHA_REFERENCE, (String)ECHA_URL));
    protected Property nameProperty = Property.getInstance((String)"Names", (ILiteratureEntry)LiteratureEntry.getInstance((String)ECHA_REFERENCE, (String)ECHA_URL));
    protected Property registrationProperty = Property.getInstance((String)echa_tags.REGISTRATION_DATE.toString(), (ILiteratureEntry)LiteratureEntry.getInstance((String)ECHA_REFERENCE, (String)ECHA_URL));

    public ECHAPreregistrationListReader(InputStream inputStream) throws CDKException {
        this.record = new StructureRecord();
        this.record.setFormat(IStructureRecord.MOL_TYPE.SDF.toString());
        this.record.setContent("");
        this.setReader(inputStream);
    }

    public void setReader(InputStream inputStream) throws CDKException {
        try {
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            xMLInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
            this.reader = xMLInputFactory.createXMLStreamReader(inputStream, "UTF-8");
        }
        catch (Exception exception) {
            this.reader = null;
            throw new CDKException(exception.getMessage(), (Throwable)exception);
        }
    }

    public void setReader(Reader reader) throws CDKException {
        try {
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            xMLInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
            this.reader = xMLInputFactory.createXMLStreamReader(reader);
        }
        catch (Exception exception) {
            this.reader = null;
            throw new CDKException(exception.getMessage(), (Throwable)exception);
        }
    }

    public void close() throws IOException {
        try {
            this.reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IOException(xMLStreamException.getMessage());
        }
    }

    public IResourceFormat getFormat() {
        return null;
    }

    public boolean hasNext() {
        try {
            while (this.reader.hasNext()) {
                int n = this.reader.next();
                block2 : switch (n) {
                    case 1: {
                        Object object = echa_tags.valueOf(this.reader.getName().getLocalPart());
                        this.tmpValue = "";
                        switch (1.$SwitchMap$ambit2$core$io$ECHAPreregistrationListReader$echa_tags[((Enum)object).ordinal()]) {
                            case 1: {
                                this.record.clear();
                                this.synonyms.clear();
                                break block2;
                            }
                        }
                        break;
                    }
                    case 8: {
                        return false;
                    }
                    case 2: {
                        Object object = echa_tags.valueOf(this.reader.getName().getLocalPart());
                        switch (1.$SwitchMap$ambit2$core$io$ECHAPreregistrationListReader$echa_tags[((Enum)object).ordinal()]) {
                            case 1: {
                                for (int i = 0; i < this.synonyms.size(); ++i) {
                                    this.record.setProperty(Property.getInstance((String)"Names", (ILiteratureEntry)LiteratureEntry.getInstance((String)String.format("%s %s#%d", ECHA_REFERENCE, echa_tags.SYNONYM.toString(), i + 1, ECHA_URL), (String)ECHA_URL)), (Object)this.synonyms.get(i));
                                }
                                return true;
                            }
                            case 2: {
                                this.record.setProperty(this.nameProperty, (Object)this.tmpValue);
                                break block2;
                            }
                            case 4: {
                                this.record.setProperty(this.ecProperty, (Object)this.tmpValue);
                                break block2;
                            }
                            case 3: {
                                try {
                                    this.record.setProperty(this.casProperty, (Object)this.casProcessor.process(this.tmpValue));
                                }
                                catch (Exception exception) {
                                    this.record.setProperty(this.casProperty, (Object)this.tmpValue);
                                }
                                break block2;
                            }
                            case 5: {
                                this.record.setProperty(this.registrationProperty, (Object)this.tmpValue);
                                break block2;
                            }
                            case 7: {
                                this.synonyms.add(this.tmpValue);
                                break block2;
                            }
                        }
                        this.tmpValue = null;
                        break;
                    }
                    case 4: {
                        Object object = this.reader.getText();
                        if (object == null || "".equals(object)) break;
                        this.tmpValue = this.tmpValue + (String)object;
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
        return false;
    }

    public Object next() {
        return this.record;
    }

    @Override
    public IStructureRecord nextRecord() {
        return this.record;
    }

    public void parseDocument() throws Exception {
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$ambit2$core$io$ECHAPreregistrationListReader$echa_tags;

        static {
            $SwitchMap$ambit2$core$io$ECHAPreregistrationListReader$echa_tags = new int[echa_tags.values().length];
            try {
                1.$SwitchMap$ambit2$core$io$ECHAPreregistrationListReader$echa_tags[echa_tags.PRE_REGISTERED_SUBSTANCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$ambit2$core$io$ECHAPreregistrationListReader$echa_tags[echa_tags.NAME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$ambit2$core$io$ECHAPreregistrationListReader$echa_tags[echa_tags.CAS_NUMBER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$ambit2$core$io$ECHAPreregistrationListReader$echa_tags[echa_tags.EC_NUMBER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$ambit2$core$io$ECHAPreregistrationListReader$echa_tags[echa_tags.REGISTRATION_DATE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$ambit2$core$io$ECHAPreregistrationListReader$echa_tags[echa_tags.SYNONYM.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$ambit2$core$io$ECHAPreregistrationListReader$echa_tags[echa_tags.SYNONYM_NAME.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    protected static enum echa_tags {
        dataroot,
        PRE_REGISTERED_SUBSTANCE,
        EC_NUMBER,
        CAS_NUMBER,
        NAME,
        REGISTRATION_DATE,
        RELATED_SUBSTANCE,
        RELATED_CAS_NUMBER,
        RELATED_EC_NUMBER,
        RELATED_NAME,
        SYNONYM,
        SYNONYM_NAME,
        SYNONYM_LANGUAGE,
        NONE;

    }
}

