/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import libpadeldescriptor.AtomConstants;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public class ConstitutionalDescriptor
implements IMolecularDescriptor {
    public String[] names = new String[wtypes.length * 2];
    private static final String[] wtypes = new String[]{"v", "se", "pe", "are", "p", "i"};

    public ConstitutionalDescriptor() {
        int n = 0;
        for (String string : wtypes) {
            this.names[n++] = "S" + string;
        }
        for (String string : wtypes) {
            this.names[n++] = "M" + string;
        }
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("constitutional", this.getClass().getName(), "$Id: ConstitutionalDescriptor.java 1 2014-06-09 17:40:00Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return this.names;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n;
        int n2;
        int n3 = iAtomContainer.getAtomCount();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        double[] dArray5 = new double[n3];
        double[] dArray6 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            n2 = iAtomContainer.getAtom(i).getAtomicNumber();
            dArray[i] = n2 < AtomConstants.volumes.length ? AtomConstants.volumes[n2] / AtomConstants.volumes[6] : Double.NaN;
            dArray2[i] = n2 < AtomConstants.sandersonelnegativities.length ? AtomConstants.sandersonelnegativities[n2] / AtomConstants.sandersonelnegativities[6] : Double.NaN;
            dArray3[i] = n2 < AtomConstants.paulingelnegativities.length ? AtomConstants.paulingelnegativities[n2] / AtomConstants.paulingelnegativities[6] : Double.NaN;
            dArray4[i] = n2 < AtomConstants.allredrochowelnegativities.length ? AtomConstants.allredrochowelnegativities[n2] / AtomConstants.allredrochowelnegativities[6] : Double.NaN;
            dArray5[i] = n2 < AtomConstants.polarizabilities.length ? AtomConstants.polarizabilities[n2] / AtomConstants.polarizabilities[6] : Double.NaN;
            dArray6[i] = n2 < AtomConstants.ionpotentials.length ? AtomConstants.ionpotentials[n2] / AtomConstants.polarizabilities[6] : Double.NaN;
        }
        double[] dArray7 = new double[wtypes.length];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray7[0] = dArray7[0] + dArray[n2];
            dArray7[1] = dArray7[1] + dArray2[n2];
            dArray7[2] = dArray7[2] + dArray3[n2];
            dArray7[3] = dArray7[3] + dArray4[n2];
            dArray7[4] = dArray7[4] + dArray5[n2];
            dArray7[5] = dArray7[5] + dArray6[n2];
        }
        double[] dArray8 = new double[wtypes.length];
        for (int i = 0; i < wtypes.length; ++i) {
            dArray8[i] = dArray7[i] / (double)n3;
        }
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        for (n = 0; n < wtypes.length; ++n) {
            doubleArrayResult.add(dArray7[n]);
        }
        for (n = 0; n < wtypes.length; ++n) {
            doubleArrayResult.add(dArray8[n]);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames());
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(this.names.length);
    }
}

