"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegManifestWriter = void 0;
const fs = require("fs");
const path = require("path");
const cloud_assembly_schema_1 = require("@aws-cdk/cloud-assembly-schema");
class IntegManifestWriter {
    static write(manifest, filePath) {
        cloud_assembly_schema_1.Manifest.saveIntegManifest(manifest, getFinalLocation(filePath));
    }
}
exports.IntegManifestWriter = IntegManifestWriter;
IntegManifestWriter.DEFAULT_FILENAME = 'integ.json';
function getFinalLocation(filePath) {
    try {
        const st = fs.statSync(filePath);
        return st.isDirectory()
            ? path.join(filePath, IntegManifestWriter.DEFAULT_FILENAME)
            : filePath;
    }
    catch (e) {
        if (e.code === 'ENOENT') {
            return filePath;
        }
        throw new Error(`Cannot write integ manifest to '${filePath}': ${e.message}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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