/*
 * Decompiled with CFR 0.152.
 */
package no.ntnu.ihb.fmi4j.importer;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import no.ntnu.ihb.fmi4j.CoSimulationModel;
import no.ntnu.ihb.fmi4j.ModelExchangeModel;
import no.ntnu.ihb.fmi4j.importer.AbstractFmu;
import no.ntnu.ihb.fmi4j.importer.fmi1.Fmu;
import no.ntnu.ihb.fmi4j.modeldescription.ModelDescriptionParser;
import no.ntnu.ihb.fmi4j.modeldescription.ModelDescriptionProvider;
import no.ntnu.ihb.fmi4j.util.UnzipperKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001f\u001a\u00020 H&J\b\u0010!\u001a\u00020\"H&J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u001aH\u0002J\b\u0010&\u001a\u00020$H$J\b\u0010'\u001a\u00020$H$J\b\u0010(\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u0011\u0010\u0016\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000bR\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006*"}, d2={"Lno/ntnu/ihb/fmi4j/importer/AbstractFmu;", "Ljava/io/Closeable;", "name", "", "extractedFmu", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "getExtractedFmu", "()Ljava/io/File;", "guid", "getGuid", "()Ljava/lang/String;", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "modelDescription", "Lno/ntnu/ihb/fmi4j/modeldescription/ModelDescriptionProvider;", "getModelDescription", "()Lno/ntnu/ihb/fmi4j/modeldescription/ModelDescriptionProvider;", "modelDescriptionFile", "getModelDescriptionFile", "modelDescriptionXml", "getModelDescriptionXml", "modelName", "getModelName", "getName", "supportsCoSimulation", "", "getSupportsCoSimulation", "()Z", "supportsModelExchange", "getSupportsModelExchange", "asCoSimulationFmu", "Lno/ntnu/ihb/fmi4j/CoSimulationModel;", "asModelExchangeFmu", "Lno/ntnu/ihb/fmi4j/ModelExchangeModel;", "close", "", "deleteExtractedFmuFolder", "disposeNativeLibraries", "terminateInstances", "toString", "Companion", "fmi-import"})
public abstract class AbstractFmu
implements Closeable {
    private AtomicBoolean isClosed;
    @NotNull
    private final String name;
    @NotNull
    private final File extractedFmu;
    private static final Logger LOG;
    private static final String FMU_EXTENSION = "fmu";
    private static final String FMI4J_FILE_PREFIX = "fmi4j_";
    @NotNull
    public static final String BINARIES_FOLDER = "binaries";
    @NotNull
    public static final String MODEL_DESC = "modelDescription.xml";
    @NotNull
    private static final List<AbstractFmu> fmus;
    public static final Companion Companion;

    @NotNull
    public final String getGuid() {
        return this.getModelDescription().getGuid();
    }

    @NotNull
    public final String getModelName() {
        return this.getModelDescription().getModelName();
    }

    @NotNull
    public abstract ModelDescriptionProvider getModelDescription();

    @NotNull
    public final String getModelDescriptionXml() {
        return FilesKt.readText$default(this.getModelDescriptionFile(), null, 1, null);
    }

    public final boolean getSupportsCoSimulation() {
        return this.getModelDescription().getSupportsCoSimulation();
    }

    public final boolean getSupportsModelExchange() {
        return this.getModelDescription().getSupportsModelExchange();
    }

    private final File getModelDescriptionFile() {
        return new File(this.extractedFmu, MODEL_DESC);
    }

    @NotNull
    public abstract CoSimulationModel asCoSimulationFmu();

    @NotNull
    public abstract ModelExchangeModel asModelExchangeFmu();

    protected abstract void terminateInstances();

    protected abstract void disposeNativeLibraries();

    private final boolean deleteExtractedFmuFolder() {
        if (this.extractedFmu.exists()) {
            boolean bl = FilesKt.deleteRecursively(this.extractedFmu);
            boolean bl2 = false;
            boolean bl3 = false;
            boolean success = bl;
            boolean bl4 = false;
            if (success) {
                LOG.debug("Deleted extracted FMU contents: " + this.extractedFmu);
            } else {
                LOG.debug("Failed to delete extracted FMU contents: " + this.extractedFmu);
            }
            return bl;
        }
        return true;
    }

    @Override
    public void close() {
        if (!this.isClosed.getAndSet(true)) {
            LOG.debug("Closing FMU '" + this.extractedFmu + "'..");
            this.terminateInstances();
            this.disposeNativeLibraries();
            this.deleteExtractedFmuFolder();
            fmus.remove(this);
        }
    }

    @NotNull
    public String toString() {
        return "Fmu(fmu=" + this.extractedFmu.getAbsolutePath() + ')';
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    protected final File getExtractedFmu() {
        return this.extractedFmu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFmu(@NotNull String name, @NotNull File extractedFmu) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(extractedFmu, "extractedFmu");
        this.name = name;
        this.extractedFmu = extractedFmu;
        this.isClosed = new AtomicBoolean(false);
        if (!new File(this.extractedFmu, MODEL_DESC).exists()) {
            boolean bl = this.deleteExtractedFmuFolder();
            boolean bl2 = false;
            boolean bl3 = false;
            boolean it = bl;
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException("FMU is invalid, no modelDescription.xml present!");
        }
        List<AbstractFmu> list = fmus;
        boolean bl = false;
        boolean bl5 = false;
        synchronized (list) {
            boolean bl6 = false;
            bl5 = fmus.add(this);
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(AbstractFmu.class);
        Intrinsics.checkExpressionValueIsNotNull(logger, "LoggerFactory.getLogger(AbstractFmu::class.java)");
        LOG = logger;
        boolean bl = false;
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkExpressionValueIsNotNull(list, "Collections.synchronized\u2026bleListOf<AbstractFmu>())");
        fmus = list;
        Runtime.getRuntime().addShutdownHook(new Thread(Companion.1.INSTANCE));
    }

    @JvmStatic
    @NotNull
    public static final AbstractFmu from(@NotNull File file) throws IOException, FileNotFoundException {
        return Companion.from(file);
    }

    @JvmStatic
    @NotNull
    public static final AbstractFmu from(@NotNull URL url) throws IOException {
        return Companion.from(url);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0010H\u0007J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0016\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lno/ntnu/ihb/fmi4j/importer/AbstractFmu$Companion;", "", "()V", "BINARIES_FOLDER", "", "FMI4J_FILE_PREFIX", "FMU_EXTENSION", "LOG", "Lorg/slf4j/Logger;", "MODEL_DESC", "fmus", "", "Lno/ntnu/ihb/fmi4j/importer/AbstractFmu;", "getFmus$fmi_import", "()Ljava/util/List;", "createTempDir", "Ljava/io/File;", "fmuName", "from", "file", "url", "Ljava/net/URL;", "name", "data", "", "getModelDescriptionFileFromExtractedFmuDir", "folder", "fmi-import"})
    public static final class Companion {
        @NotNull
        public final List<AbstractFmu> getFmus$fmi_import() {
            return fmus;
        }

        private final File createTempDir(String fmuName) {
            File file = Files.createTempDirectory(AbstractFmu.FMI4J_FILE_PREFIX + fmuName, new FileAttribute[0]).toFile();
            Intrinsics.checkExpressionValueIsNotNull(file, "Files.createTempDirector\u2026REFIX + fmuName).toFile()");
            return file;
        }

        private final File getModelDescriptionFileFromExtractedFmuDir(File folder) {
            File[] fileArray;
            block5: {
                block4: {
                    File[] fileArray2;
                    block3: {
                        fileArray = folder.listFiles();
                        if (fileArray == null) break block4;
                        File[] fileArray3 = fileArray;
                        boolean bl = false;
                        File[] fileArray4 = fileArray3;
                        boolean bl2 = false;
                        File[] fileArray5 = fileArray4;
                        int n = fileArray5.length;
                        for (int i = 0; i < n; ++i) {
                            File[] fileArray6;
                            File[] it = fileArray6 = fileArray5[i];
                            boolean bl3 = false;
                            File[] fileArray7 = it;
                            Intrinsics.checkExpressionValueIsNotNull(fileArray7, "it");
                            if (!Intrinsics.areEqual(fileArray7.getName(), AbstractFmu.MODEL_DESC)) continue;
                            fileArray2 = fileArray6;
                            break block3;
                        }
                        fileArray2 = fileArray = null;
                    }
                    if (fileArray2 != null) break block5;
                }
                throw (Throwable)new IllegalArgumentException("Folder '" + folder + "' does not contain a file named 'modelDescription.xml'!");
            }
            return fileArray;
        }

        @JvmStatic
        @NotNull
        public final AbstractFmu from(@NotNull File file) throws IOException, FileNotFoundException {
            AbstractFmu abstractFmu;
            Intrinsics.checkParameterIsNotNull(file, "file");
            String string = FilesKt.getExtension(file);
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).toLowerCase()");
            String extension = string3;
            boolean bl2 = Intrinsics.areEqual(extension, AbstractFmu.FMU_EXTENSION);
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                boolean bl4 = false;
                String string4 = "File '" + file.getAbsolutePath() + "' is not an FMU! Invalid extension found: ." + extension;
                throw (Throwable)new IllegalArgumentException(string4.toString());
            }
            if (!file.exists()) {
                throw (Throwable)new FileNotFoundException("No such file: '" + file + "'!");
            }
            File file2 = this.createTempDir(FilesKt.getNameWithoutExtension(file));
            bl = false;
            bl3 = false;
            File temp = file2;
            boolean bl5 = false;
            UnzipperKt.extractContentTo(file, temp);
            String version = ModelDescriptionParser.Companion.extractVersion(FilesKt.readText$default(Companion.getModelDescriptionFileFromExtractedFmuDir(temp), null, 1, null));
            if (Intrinsics.areEqual(version, "1.0")) {
                abstractFmu = new Fmu(FilesKt.getNameWithoutExtension(file), temp);
            } else if (Intrinsics.areEqual(version, "2.0")) {
                abstractFmu = new no.ntnu.ihb.fmi4j.importer.fmi2.Fmu(FilesKt.getNameWithoutExtension(file), temp);
            } else {
                throw (Throwable)new UnsupportedOperationException("Unsupported FMI version: '" + version + '\'');
            }
            return abstractFmu;
        }

        @JvmStatic
        @NotNull
        public final AbstractFmu from(@NotNull URL url) throws IOException {
            AbstractFmu abstractFmu;
            Intrinsics.checkParameterIsNotNull(url, "url");
            String extension = FilesKt.getExtension(new File(url.getFile()));
            boolean bl = Intrinsics.areEqual(extension, AbstractFmu.FMU_EXTENSION);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "URL '" + url + "' does not point to an FMU! Invalid extension found: ." + extension;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            String fmuName = FilesKt.getNameWithoutExtension(new File(url.getFile()));
            File file = this.createTempDir(fmuName);
            bl3 = false;
            boolean bl5 = false;
            File temp = file;
            boolean bl6 = false;
            UnzipperKt.extractContentTo(url, temp);
            String version = ModelDescriptionParser.Companion.extractVersion(FilesKt.readText$default(Companion.getModelDescriptionFileFromExtractedFmuDir(temp), null, 1, null));
            if (Intrinsics.areEqual(version, "1.0")) {
                abstractFmu = new Fmu(fmuName, temp);
            } else if (Intrinsics.areEqual(version, "2.0")) {
                abstractFmu = new no.ntnu.ihb.fmi4j.importer.fmi2.Fmu(fmuName, temp);
            } else {
                throw (Throwable)new UnsupportedOperationException("Unsupported FMI version: '" + version + '\'');
            }
            return abstractFmu;
        }

        @NotNull
        public final AbstractFmu from(@NotNull String name, @NotNull byte[] data2) throws IOException {
            AbstractFmu abstractFmu;
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(data2, "data");
            File file = this.createTempDir(name);
            boolean bl = false;
            boolean bl2 = false;
            File temp = file;
            boolean bl3 = false;
            UnzipperKt.extractContentTo(new ByteArrayInputStream(data2), temp);
            String version = ModelDescriptionParser.Companion.extractVersion(FilesKt.readText$default(Companion.getModelDescriptionFileFromExtractedFmuDir(temp), null, 1, null));
            if (Intrinsics.areEqual(version, "1.0")) {
                abstractFmu = new Fmu(name, temp);
            } else if (Intrinsics.areEqual(version, "2.0")) {
                abstractFmu = new no.ntnu.ihb.fmi4j.importer.fmi2.Fmu(name, temp);
            } else {
                throw (Throwable)new UnsupportedOperationException("Unsupported FMI version: '" + version + '\'');
            }
            return abstractFmu;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

