/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace.internal;

import io.opencensus.internal.Utils;
import io.opencensus.trace.BaseMessageEvent;
import io.opencensus.trace.MessageEvent;
import io.opencensus.trace.NetworkEvent;

public final class BaseMessageEventUtils {
    public static MessageEvent asMessageEvent(BaseMessageEvent event) {
        Utils.checkNotNull(event, "event");
        if (event instanceof MessageEvent) {
            return (MessageEvent)event;
        }
        NetworkEvent networkEvent = (NetworkEvent)event;
        MessageEvent.Type type2 = networkEvent.getType() == NetworkEvent.Type.RECV ? MessageEvent.Type.RECEIVED : MessageEvent.Type.SENT;
        return MessageEvent.builder(type2, networkEvent.getMessageId()).setUncompressedMessageSize(networkEvent.getUncompressedMessageSize()).setCompressedMessageSize(networkEvent.getCompressedMessageSize()).build();
    }

    public static NetworkEvent asNetworkEvent(BaseMessageEvent event) {
        Utils.checkNotNull(event, "event");
        if (event instanceof NetworkEvent) {
            return (NetworkEvent)event;
        }
        MessageEvent messageEvent = (MessageEvent)event;
        NetworkEvent.Type type2 = messageEvent.getType() == MessageEvent.Type.RECEIVED ? NetworkEvent.Type.RECV : NetworkEvent.Type.SENT;
        return NetworkEvent.builder(type2, messageEvent.getMessageId()).setUncompressedMessageSize(messageEvent.getUncompressedMessageSize()).setCompressedMessageSize(messageEvent.getCompressedMessageSize()).build();
    }

    private BaseMessageEventUtils() {
    }
}

