/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.ExperimentalApi;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.Status;
import io.grpc.util.ForwardingLoadBalancer;
import io.grpc.util.ForwardingLoadBalancerHelper;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/5999")
@NotThreadSafe
public final class GracefulSwitchLoadBalancer
extends ForwardingLoadBalancer {
    private static final LoadBalancer NOOP_BALANCER = new LoadBalancer(){

        @Override
        public void handleNameResolutionError(Status error) {
        }

        @Override
        public void shutdown() {
        }
    };
    @VisibleForTesting
    static final LoadBalancer.SubchannelPicker BUFFER_PICKER = new LoadBalancer.SubchannelPicker(){

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args2) {
            return LoadBalancer.PickResult.withNoResult();
        }

        public String toString() {
            return "BUFFER_PICKER";
        }
    };
    private final LoadBalancer.Helper helper;
    @Nullable
    private String currentPolicyName;
    private LoadBalancer currentLb = NOOP_BALANCER;
    @Nullable
    private String pendingPolicyName;
    private LoadBalancer pendingLb = NOOP_BALANCER;
    private ConnectivityState pendingState;
    private LoadBalancer.SubchannelPicker pendingPicker;
    private boolean currentLbIsReady;

    public GracefulSwitchLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
    }

    public void switchTo(LoadBalancerProvider newLbProvider) {
        Preconditions.checkNotNull(newLbProvider, "newLbProvider");
        String newPolicyName = newLbProvider.getPolicyName();
        if (newPolicyName.equals(this.pendingPolicyName)) {
            return;
        }
        this.pendingLb.shutdown();
        this.pendingLb = NOOP_BALANCER;
        this.pendingPolicyName = null;
        this.pendingState = ConnectivityState.CONNECTING;
        this.pendingPicker = BUFFER_PICKER;
        if (newPolicyName.equals(this.currentPolicyName)) {
            return;
        }
        class PendingHelper
        extends ForwardingLoadBalancerHelper {
            LoadBalancer lb;

            PendingHelper() {
            }

            @Override
            protected LoadBalancer.Helper delegate() {
                return GracefulSwitchLoadBalancer.this.helper;
            }

            @Override
            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                if (this.lb == GracefulSwitchLoadBalancer.this.pendingLb) {
                    Preconditions.checkState(GracefulSwitchLoadBalancer.this.currentLbIsReady, "there's pending lb while current lb has been out of READY");
                    GracefulSwitchLoadBalancer.this.pendingState = newState;
                    GracefulSwitchLoadBalancer.this.pendingPicker = newPicker;
                    if (newState == ConnectivityState.READY) {
                        GracefulSwitchLoadBalancer.this.swap();
                    }
                } else if (this.lb == GracefulSwitchLoadBalancer.this.currentLb) {
                    GracefulSwitchLoadBalancer.this.currentLbIsReady = newState == ConnectivityState.READY;
                    if (!GracefulSwitchLoadBalancer.this.currentLbIsReady && GracefulSwitchLoadBalancer.this.pendingLb != NOOP_BALANCER) {
                        GracefulSwitchLoadBalancer.this.swap();
                    } else {
                        GracefulSwitchLoadBalancer.this.helper.updateBalancingState(newState, newPicker);
                    }
                }
            }
        }
        PendingHelper pendingHelper = new PendingHelper();
        this.pendingLb = pendingHelper.lb = newLbProvider.newLoadBalancer(pendingHelper);
        this.pendingPolicyName = newPolicyName;
        if (!this.currentLbIsReady) {
            this.swap();
        }
    }

    private void swap() {
        this.helper.updateBalancingState(this.pendingState, this.pendingPicker);
        this.currentLb.shutdown();
        this.currentLb = this.pendingLb;
        this.currentPolicyName = this.pendingPolicyName;
        this.pendingLb = NOOP_BALANCER;
        this.pendingPolicyName = null;
    }

    @Override
    protected LoadBalancer delegate() {
        return this.pendingLb == NOOP_BALANCER ? this.currentLb : this.pendingLb;
    }

    @Override
    @Deprecated
    public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
        throw new UnsupportedOperationException("handleSubchannelState() is not supported by " + this.getClass().getName());
    }

    @Override
    public void shutdown() {
        this.pendingLb.shutdown();
        this.currentLb.shutdown();
    }
}

