/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.ExperimentalApi;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public final class ServiceDescriptor {
    private final String name;
    private final Collection<MethodDescriptor<?, ?>> methods;
    private final Object schemaDescriptor;

    public ServiceDescriptor(String name, MethodDescriptor<?, ?> ... methods2) {
        this(name, Arrays.asList(methods2));
    }

    public ServiceDescriptor(String name, Collection<MethodDescriptor<?, ?>> methods2) {
        this(ServiceDescriptor.newBuilder(name).addAllMethods(Preconditions.checkNotNull(methods2, "methods")));
    }

    private ServiceDescriptor(Builder b) {
        this.name = b.name;
        ServiceDescriptor.validateMethodNames(this.name, b.methods);
        this.methods = Collections.unmodifiableList(new ArrayList(b.methods));
        this.schemaDescriptor = b.schemaDescriptor;
    }

    public String getName() {
        return this.name;
    }

    public Collection<MethodDescriptor<?, ?>> getMethods() {
        return this.methods;
    }

    @Nullable
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2222")
    public Object getSchemaDescriptor() {
        return this.schemaDescriptor;
    }

    static void validateMethodNames(String serviceName, Collection<MethodDescriptor<?, ?>> methods2) {
        HashSet<String> allNames = new HashSet<String>(methods2.size());
        for (MethodDescriptor<?, ?> method : methods2) {
            Preconditions.checkNotNull(method, "method");
            String methodServiceName = method.getServiceName();
            Preconditions.checkArgument(serviceName.equals(methodServiceName), "service names %s != %s", (Object)methodServiceName, (Object)serviceName);
            Preconditions.checkArgument(allNames.add(method.getFullMethodName()), "duplicate name %s", (Object)method.getFullMethodName());
        }
    }

    public static Builder newBuilder(String name) {
        return new Builder(name);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("schemaDescriptor", this.schemaDescriptor).add("methods", this.methods).omitNullValues().toString();
    }

    public static final class Builder {
        private String name;
        private List<MethodDescriptor<?, ?>> methods = new ArrayList();
        private Object schemaDescriptor;

        private Builder(String name) {
            this.setName(name);
        }

        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2666")
        public Builder setName(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            return this;
        }

        public Builder addMethod(MethodDescriptor<?, ?> method) {
            this.methods.add(Preconditions.checkNotNull(method, "method"));
            return this;
        }

        private Builder addAllMethods(Collection<MethodDescriptor<?, ?>> methods2) {
            this.methods.addAll(methods2);
            return this;
        }

        public Builder setSchemaDescriptor(@Nullable Object schemaDescriptor) {
            this.schemaDescriptor = schemaDescriptor;
            return this;
        }

        public ServiceDescriptor build() {
            return new ServiceDescriptor(this);
        }
    }
}

