"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const iam = require("@aws-cdk/aws-iam");
const ec2 = require("@aws-cdk/aws-ec2");
class GitlabContainerRunner extends cdk.Construct {
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        const vpc = new ec2.Vpc(this, 'VPC', {
            cidr: '10.0.0.0/16',
            maxAzs: 2,
            subnetConfiguration: [{
                    cidrMask: 26,
                    name: 'RunnerVPC',
                    subnetType: ec2.SubnetType.PUBLIC,
                }],
            natGateways: 0,
        });
        var token = (_a = props.gitlabtoken) !== null && _a !== void 0 ? _a : 'gitlab-token';
        const shell = ec2.UserData.forLinux();
        shell.addCommands('yum update -y');
        shell.addCommands('yum install docker -y');
        shell.addCommands('service docker start');
        shell.addCommands('usermod -aG docker ec2-user');
        shell.addCommands('chmod +x /var/run/docker.sock');
        shell.addCommands('service docker restart &&  chkconfig docker on');
        shell.addCommands('docker run -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock --name gitlab-runner-register gitlab/gitlab-runner:alpine register --non-interactive --url https://gitlab.com./ --registration-token ' + token + '  --docker-volumes \"/var/run/docker.sock:/var/run/docker.sock\" --executor docker --docker-image \"alpine:latest\" --description \"Docker Runner\" --tag-list \"gitlab,runner,awscdk\" --docker-privileged');
        shell.addCommands('sleep 2 && docker run --restart always -d -v /home/ec2-user/.gitlab-runner:/etc/gitlab-runner -v /var/run/docker.sock:/var/run/docker.sock --name gitlab-runner gitlab/gitlab-runner:alpine');
        shell.addCommands('usermod -aG docker ssm-user');
        const runner = new ec2.Instance(this, 'GitlabRunner', {
            instanceType: (_b = props.ec2type) !== null && _b !== void 0 ? _b : ec2.InstanceType.of(ec2.InstanceClass.T3, ec2.InstanceSize.LARGE),
            instanceName: 'Gitlab-Runner',
            vpc,
            machineImage: new ec2.AmazonLinuxImage,
            userData: shell,
            blockDevices: [({ deviceName: '/dev/xvda', volume: ec2.BlockDeviceVolume.ebs(60) })],
        });
        runner.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        new cdk.CfnOutput(this, 'Runner-ID', { value: runner.instanceId });
    }
}
exports.GitlabContainerRunner = GitlabContainerRunner;
//# sourceMappingURL=data:application/json;base64,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