# 百度智能云 API调用PythonSDK

这是一个用于百度云部分开放AI功能的Python库。主要为ORC功能，可以对各种图像文件进行文字识别，包括车牌、手写文字、通用文字、人脸发现、人脸比对和人流量统计等。

更多的功能大家可以提出，后续会慢慢开发这个库。

使用这个库，你可以很方便地调用百度云OCR API，并将识别结果以json的形式返回。你可以根据自己的需要来使用不同的API，以获得更精确或更快速的识别结果。

此外，这个库还提供了URL版本的文字识别功能，可以直接对网络图片进行识别。

# 使用方法

## 1.安装库

使用pip安装：

```bash
pip install baiducloud
```

1. 准备API Key和Secret Key

## 2.准备API Key和Secret Key

在使用百度云OCR API之前，你需要去百度云控制台申请API Key和Secret Key。

## 3.初始化baiducloud类

在你的代码中导入baiducloud类，并使用API Key和Secret Key初始化它：

```python
from baiducloud import baiducloud

api_key = "your_api_key"
secret_key = "your_secret_key"

bc = baiducloud(api_key, secret_key)
```

## 4.使用Python开发你的程序

### 例子1.车牌识别

```python
result = bc.orc_license_plate("image.jpg")
print(result)
```

返回结果是一个json

### 例子2.使用URL版本的文字识别

```python
result = bc.orc_license_plate_url("https://example.com/image.jpg")
print(result)
```

**注意：使用URL版本的文字识别方法时，你需要确保图片URL是可以公开访问的。**

### 例子3.使用人脸比对

```python
result = bc.face_compare("https://example.com/image.jpg"，"https://example.com/image1.jpg")
print(result)
```

当然，还有更多的使用方法，具体可以参考`baiducloud > main.py`，使用方法大同小异，文档就后续再更新。

# 生成环境

下面是我的机器人的真实使用环境，大家可以进行一个参考：

```python
#百度云 车牌识别
def baiduyun_orc_traffic_plate(img_path):
    bc = baiducloud.baiducloud(sqlite.search_API("百度云应用API_Key"), sqlite.search_API("百度云应用Secret_Key"))
    response_data = bc.orc_license_plate(img_path)
    number = response_data['words_result']['number']
    color = response_data['words_result']['color']
    return "车牌号："+number+"\n颜色："+color

#百度云 车牌识别——URL版
def baiduyun_orc_traffic_plate_url(img_url):
    bc = baiducloud.baiducloud(sqlite.search_API("百度云应用API_Key"), sqlite.search_API("百度云应用Secret_Key"))
    response_data = bc.orc_license_plate_url(img_url)
    number = response_data['words_result']['number']
    color = response_data['words_result']['color']
    return "车牌号："+number+"\n颜色："+color

#百度云 手写文字识别
def baiduyun_orc_handwriting(img_url):
    bc = baiducloud.baiducloud(sqlite.search_API("百度云应用API_Key"), sqlite.search_API("百度云应用Secret_Key"))
    response_data = bc.orc_handwriting_url(img_url)
    words_result = response_data['words_result']
    words = ""
    for i in words_result:
        words += i['words']+"\n"
    return words[:-1]

#百度云 通用文字识别 高精度
def baiduyun_orc_accurate_basic(img_url):
    bc = baiducloud.baiducloud(sqlite.search_API("百度云应用API_Key"), sqlite.search_API("百度云应用Secret_Key"))
    response_data = bc.orc_accurate_basic_url(img_url)
    words_result = response_data['words_result']
    words = ""
    for i in words_result:
        words += i['words']+"\n"
    return words[:-1]

#百度云 通用文字识别
def baiduyun_orc_general_basic(img_url):
    bc = baiducloud.baiducloud(sqlite.search_API("百度云应用API_Key"), sqlite.search_API("百度云应用Secret_Key"))
    response_data = bc.orc_general_basic_url()
    words_result = response_data['words_result']
    words = ""
    for i in words_result:
        words += i['words'] + "\n"
    return words[:-1]
#百度云 人脸检测
def baiduyun_face_check(img_path):
    bc = baiducloud.baiducloud(sqlite.search_API("百度云应用API_Key"), sqlite.search_API("百度云应用Secret_Key"))
    response_data = bc.face_detect(img_path)
    if response_data['error_code'] != 0:
        return response_data['error_msg']
    else:
        return "检测到"+str(response_data['result']['face_num'])+"张人脸"
#百度云 人脸对比
def baiduyun_face_contrast(img_path,img_path1):
    bc = baiducloud.baiducloud(sqlite.search_API("百度云应用API_Key"), sqlite.search_API("百度云应用Secret_Key"))
    response_data = bc.face_compare(img_path,img_path1)
    if response_data['error_code'] != 0:
        return response_data['error_msg']
    else:
        return "两张人脸相似度为："+str(response_data['result']['score'])+"%"

#百度云 人流量
def baiduyun_person_num(img_path):
    bc = baiducloud.baiducloud(sqlite.search_API("百度云应用API_Key"), sqlite.search_API("百度云应用Secret_Key"))
    response_data = bc.person_num(img_path)
    return "图片中人流量为："+str(response_data['person_num'])
```

当然，写的有些乱，但是应该可以看懂。
