import { DirectiveNode } from 'graphql';
export interface QueryNameMap {
    get?: string;
    list?: string;
    query?: string;
}
export interface MutationNameMap {
    create?: string;
    update?: string;
    delete?: string;
}
export declare type ModelSubscriptionLevel = 'off' | 'public' | 'on';
export interface SubscriptionNameMap {
    onCreate?: string[];
    onUpdate?: string[];
    onDelete?: string[];
    level?: ModelSubscriptionLevel;
}
export interface ModelDirectiveTimestampConfiguration {
    createdAt?: string;
    updatedAt?: string;
}
export interface ModelDirectiveArgs {
    queries?: QueryNameMap;
    mutations?: MutationNameMap;
    subscriptions?: SubscriptionNameMap;
    timestamps?: ModelDirectiveTimestampConfiguration;
}
export declare function getCreatedAtFieldName(directive: DirectiveNode): string | undefined;
export declare function getUpdatedAtFieldName(directive: DirectiveNode): string | undefined;
export declare function getTimestampFieldName(directive: DirectiveNode, fieldName: string, defaultFiledValue: string): string | undefined;
//# sourceMappingURL=ModelDirectiveArgs.d.ts.map