import Table, { KeySchema } from 'cloudform-types/types/dynamoDb/table';
import Resolver from 'cloudform-types/types/appSync/resolver';
import Template from 'cloudform-types/types/template';
import { ObjectTypeDefinitionNode, InterfaceTypeDefinitionNode } from 'graphql';
import { ObjectNode } from 'graphql-mapping-template';
export declare class ResourceFactory {
    makeParams(): {};
    initTemplate(): Template;
    updateTableForConnection(table: Table, connectionName: string, connectionAttributeName: string, sortField?: {
        name: string;
        type: string;
    }): Table;
    makeGetItemConnectionResolver(type: string, field: string, relatedType: string, connectionAttribute: string, idFieldName: string, sortFieldInfo?: {
        primarySortFieldName: string;
        sortFieldName: string;
        sortFieldIsStringLike: boolean;
    }): Resolver;
    makeQueryConnectionResolver(type: string, field: string, relatedType: string, connectionAttribute: string, connectionName: string, idFieldName: string, sortKeyInfo?: {
        fieldName: string;
        attributeType: 'S' | 'B' | 'N';
    }, limit?: number): Resolver;
    makeGetItemConnectionWithKeyResolver(type: string, field: string, relatedType: string, connectionAttributes: string[], keySchema: KeySchema[]): Resolver;
    makeQueryConnectionWithKeyResolver(type: string, field: string, relatedType: ObjectTypeDefinitionNode | InterfaceTypeDefinitionNode, connectionAttributes: string[], keySchema: KeySchema[], indexName: string, limit?: number): Resolver;
    makeExpression(keySchema: KeySchema[], connectionAttributes: string[]): ObjectNode;
    private condenseRangeKey;
    makeCompositeSortKeyName(sortKeyName: string): string;
    private getSortKeyNames;
}
//# sourceMappingURL=resources.d.ts.map