"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validate = exports.ReadValidateTags = void 0;
const jsonUtilities_1 = require("../jsonUtilities");
const lodash_1 = __importDefault(require("lodash"));
function ReadValidateTags(tagsFilePath) {
    const tags = jsonUtilities_1.JSONUtilities.readJson(tagsFilePath, {
        throwIfNotExist: false,
        preserveComments: false,
    });
    if (!tags)
        return [];
    validate(tags);
    return tags;
}
exports.ReadValidateTags = ReadValidateTags;
function validate(tags) {
    const allowedKeySet = new Set(['Key', 'Value']);
    lodash_1.default.each(tags, tags => {
        if (lodash_1.default.some(Object.keys(tags), r => !allowedKeySet.has(r)))
            throw new Error('Tag thould be of type Key: string, Value: string');
    });
    if (lodash_1.default.uniq(tags.map(r => r.Key)).length !== tags.length)
        throw new Error("'Key' should be unique");
    if (tags.length > 50)
        throw new Error('No. of tags cannot exceed 50');
}
exports.validate = validate;
//# sourceMappingURL=Tags.js.map