# Twitch Plays hackRU
twitch_plays_hackru is a Python library for twitch chatters to be able to vote on commands in a game.

## Installation

Use the package manager to install twitch_plays_hackru.

## Usage

### Importing the classes:
```python
from twitch_plays_hackru import TwitchPlaysOnline, TwitchPlaysOffline
```

### Initializing the TwitchPlaysOnline or TwitchPlaysOffline object: 
```python
voteingOptions = ["1","2","3","hi","bye"]
tPlays = TwitchPlaysOffline("irc.twitch.tv", 6667, "oauth:YOUR_OATH_CODE_HERE", "TwitchBot", "YOUR_CHANNEL_NAME_HERE", "YOUR_CHANNEL_NAME_HERE", voteingOptions)
```

The object will take in **7 parameters**:\
SERVER: the server that the bot will be interacting with. In this case it will always be "irc.twitch.tv"\
PORT: the port you would like use.\
PASS: the OAuth code for the twitch channel you would like this bot to listen on. Use [twitchapp.com/tmi/](https://twitchapps.com/tmi/) to generate the OAuth code for your twitch channel.\
BOT: the nickname of the bot.\
CHANNEL: the name of the channel you would like this bot to listen on.\
OWNER: the username of the owner of the channel you would like this bot to listen on.\
OPTIONS = []: an array of options that you would like the bot to keep track of.

### Chatters voting:
The initialization of the bot will also startup the bot. This means that the bot will send a "Hello World" message in the chat and then begin to listen to all of the chat responses.\
Chatters will preface their vote option by using **play_**
. For example, a vote for **hi** from the code above must be typed **play_hi**. It is not case sensitive.

## Functions:
### vote_results():
```python
result = tPlays.vote_results()
```
vote_results() returns the majority vote since the last call of vote_results(). The number of votes for all options are reset to 0 after the call. If there are no votes since the last call of vote_results(), None is returned.

## License
[GNU](https://choosealicense.com/licenses/agpl-3.0/)