"""Homographs in Chinese

This template uses one character with the same font but different 
Unicode encoding to replace another character. The naked eye cannot 
see the difference before and after inserting the watermark
"""
# pylint: disable=too-many-lines

from ..defines import WMMethod

# 同形异义-中文
# http://www.unicode.org/Public/security/revision-03/confusablesSummary.txt
CONFUSABLES_CHARS: dict = {
    "°": "゜",
    "″": "゛",
    "，": "٫",
    "。": "˳",
    "：": "⁚",
    "！": "!",
    "？": "?",
    "、": "˴",
    "；": ";",
    "—": "-",
    "·": "‧",
    "敖": "敖",
    "廒": "廒",
    "翺": "翺",
    "慠": "慠",
    "八": "⼋",
    "拔": "拔",
    "跋": "跋",
    "白": "⽩",
    "韛": "韛",
    "䬳": "䬳",
    "勹": "⼓",
    "包": "包",
    "宀": "⼧",
    "駂": "駂",
    "寳": "寳",
    "抱": "抱",
    "報": "報",
    "暴": "暴",
    "卑": "卑",
    "碑": "碑",
    "北": "北",
    "贝": "⻉",
    "貝": "⾙",
    "備": "備",
    "犕": "犕",
    "糒": "糒",
    "奔": "奔",
    "泍": "泍",
    "賁": "賁",
    "䑫": "䑫",
    "絣": "絣",
    "跰": "跰",
    "鼻": "⿐",
    "匕": "⼔",
    "比": "⽐",
    "庳": "庳",
    "婢": "婢",
    "韠": "韠",
    "釆": "⾤",
    "便": "便",
    "變": "變",
    "髟": "⾽",
    "賓": "賓",
    "仌": "仌",
    "栟": "栟",
    "鉼": "鉼",
    "疒": "⽧",
    "併": "倂",
    "並": "並",
    "庰": "庰",
    "摒": "摒",
    "癶": "⽨",
    "磻": "磻",
    "博": "博",
    "鈸": "鈸",
    "卜": "⼘",
    "不": "不",
    "彩": "彩",
    "菜": "菜",
    "参": "參",
    "憯": "憯",
    "艹": "⺾",
    "艸": "⾋",
    "刂": "⺉",
    "層": "層",
    "㛼": "㛼",
    "茶": "茶",
    "剷": "剷",
    "嵼": "嵼",
    "䩶": "䩶",
    "镸": "⻒",
    "長": "⻑",
    "厂": "⼚",
    "㫤": "㫤",
    "鬯": "⾿",
    "巢": "巢",
    "鄛": "鄛",
    "潮": "潮",
    "罺": "罺",
    "车": "⻋",
    "車": "⾞",
    "屮": "⼬",
    "瞋": "瞋",
    "臣": "⾂",
    "辰": "⾠",
    "䕝": "䕝",
    "成": "成",
    "呈": "呈",
    "城": "城",
    "誠": "誠",
    "懲": "懲",
    "蚩": "蚩",
    "喫": "喫",
    "遲": "遲",
    "齿": "⻮",
    "歯": "⻭",
    "齒": "⿒",
    "彳": "⼻",
    "叱": "叱",
    "赤": "⾚",
    "充": "充",
    "虫": "⾍",
    "臭": "臭",
    "巛": "⼮",
    "舛": "⾇",
    "串": "串",
    "辵": "⾡",
    "慈": "慈",
    "堲": "堲",
    "辞": "辞",
    "甆": "甆",
    "嬨": "嬨",
    "次": "次",
    "刺": "刺",
    "螆": "螆",
    "䗹": "䗹",
    "匆": "匆",
    "䐋": "䐋",
    "熜": "熜",
    "聰": "聰",
    "爨": "爨",
    "脃": "脃",
    "寸": "⼨",
    "蔖": "蔖",
    "大": "⼤",
    "歹": "⽍",
    "瑇": "瑇",
    "戴": "戴",
    "亻": "⺅",
    "卩": "⼙",
    "丹": "丹",
    "当": "当",
    "刀": "⼑",
    "菧": "菧",
    "墬": "墬",
    "嵮": "嵮",
    "滇": "滇",
    "㒹": "㒹",
    "彫": "彫",
    "調": "調",
    "蜨": "蜨",
    "鼎": "⿍",
    "冬": "冬",
    "徚": "徚",
    "洞": "洞",
    "都": "都",
    "㨮": "㨮",
    "斗": "⽃",
    "豆": "⾖",
    "鬥": "⾾",
    "讀": "讀",
    "度": "度",
    "煅": "煅",
    "惇": "惇",
    "多": "多",
    "歺": "⺞",
    "咢": "咢",
    "恶": "惡",
    "餩": "餩",
    "儿": "⼉",
    "而": "⽽",
    "耳": "⽿",
    "二": "⼆",
    "繁": "繁",
    "犭": "⺨",
    "攵": "⺙",
    "犯": "犯",
    "汎": "汎",
    "飯": "飯",
    "匚": "⼕",
    "方": "⽅",
    "飞": "⻜",
    "非": "⾮",
    "飛": "⾶",
    "鼖": "鼖",
    "墳": "墳",
    "幩": "幩",
    "憤": "憤",
    "风": "⻛",
    "風": "⾵",
    "夆": "夆",
    "缶": "⽸",
    "父": "⽗",
    "福": "福",
    "輻": "輻",
    "阜": "⾩",
    "婦": "婦",
    "復": "復",
    "覆": "覆",
    "槪": "槪",
    "甘": "⽢",
    "干": "⼲",
    "䯎": "䯎",
    "贛": "贛",
    "罓": "⺱",
    "港": "港",
    "高": "⾼",
    "戈": "⼽",
    "割": "割",
    "革": "⾰",
    "鬲": "⿀",
    "艮": "⾉",
    "更": "更",
    "工": "⼯",
    "弓": "⼸",
    "廾": "⼶",
    "㺬": "㺬",
    "谷": "⾕",
    "骨": "⻣",
    "鼓": "⿎",
    "穀": "穀",
    "頋": "頋",
    "瓜": "⽠",
    "柺": "柺",
    "瘝": "瘝",
    "舘": "舘",
    "館": "館",
    "卝": "⻀",
    "毋": "⽏",
    "广": "⼴",
    "龟": "⻳",
    "亀": "⻲",
    "嶲": "嶲",
    "龜": "龜",
    "鬼": "⻤",
    "海": "海",
    "漢": "漢",
    "行": "⾏",
    "噑": "噑",
    "浩": "浩",
    "喝": "喝",
    "禾": "⽲",
    "㮝": "㮝",
    "褐": "褐",
    "鶴": "鶴",
    "齃": "齃",
    "黑": "⿊",
    "壷": "壷",
    "虍": "⾌",
    "虎": "⻁",
    "户": "⼾",
    "花": "花",
    "㭉": "㭉",
    "華": "華",
    "滑": "滑",
    "鋘": "鋘",
    "画": "画",
    "荒": "荒",
    "慌": "慌",
    "黄": "⻩",
    "黃": "⿈",
    "㤺": "㤺",
    "兤": "兤",
    "灰": "灰",
    "悔": "悔",
    "卉": "卉",
    "惠": "恵",
    "喙": "喙",
    "㒞": "㒞",
    "火": "⽕",
    "灬": "⺣",
    "禍": "禍",
    "枅": "枅",
    "飢": "飢",
    "姬": "姬",
    "及": "及",
    "㔕": "㔕",
    "即": "即",
    "卽": "卽",
    "揤": "揤",
    "䳭": "䳭",
    "几": "⼏",
    "己": "⼰",
    "彐": "⺕",
    "彑": "⺔",
    "旡": "⺛",
    "紀": "紀",
    "旣": "既",
    "穊": "穊",
    "䀈": "䀈",
    "冀": "冀",
    "鱀": "鱀",
    "戛": "戛",
    "賈": "賈",
    "駱": "駱",
    "䄯": "䄯",
    "趼": "趼",
    "见": "⻅",
    "見": "⾒",
    "将": "将",
    "降": "降",
    "摾": "摾",
    "糨": "糨",
    "纟": "⺰",
    "糹": "⺯",
    "角": "⻆",
    "摷": "摷",
    "叫": "叫",
    "莭": "莭",
    "䀹": "䀹",
    "節": "節",
    "巾": "⼱",
    "斤": "⽄",
    "钅": "⻐",
    "金": "⾦",
    "蓳": "蓳",
    "謹": "謹",
    "晋": "晉",
    "浸": "浸",
    "搢": "搢",
    "縉": "縉",
    "精": "精",
    "敬": "敬",
    "靖": "靖",
    "瀞": "瀞",
    "韭": "⾲",
    "臼": "⾅",
    "䳎": "䳎",
    "菊": "菊",
    "句": "句",
    "具": "具",
    "捐": "捐",
    "鋗": "鋗",
    "悁": "悁",
    "睊": "睊",
    "爵": "爵",
    "菌": "菌",
    "開": "開",
    "慨": "慨",
    "殻": "殻",
    "刻": "刻",
    "口": "⼝",
    "扝": "扝",
    "苦": "苦",
    "况": "况",
    "虧": "虧",
    "夔": "䕫",
    "䪲": "䪲",
    "㱎": "㱎",
    "廓": "廓",
    "拉": "拉",
    "喇": "喇",
    "臘": "臘",
    "蠟": "蠟",
    "来": "來",
    "癩": "癩",
    "嵐": "嵐",
    "藍": "藍",
    "襤": "襤",
    "蘭": "蘭",
    "欄": "欄",
    "懶": "懶",
    "嬾": "嬾",
    "濫": "濫",
    "爛": "爛",
    "郎": "郎",
    "狼": "狼",
    "廊": "廊",
    "朗": "朗",
    "浪": "浪",
    "劳": "劳",
    "牢": "牢",
    "勞": "勞",
    "耂": "⺹",
    "老": "⽼",
    "烙": "烙",
    "酪": "酪",
    "勒": "勒",
    "了": "了",
    "雷": "雷",
    "耒": "⽾",
    "磊": "磊",
    "壘": "壘",
    "肋": "肋",
    "类": "类",
    "累": "累",
    "淚": "淚",
    "類": "類",
    "稜": "稜",
    "冷": "冷",
    "梨": "梨",
    "黎": "黎",
    "罹": "罹",
    "離": "離",
    "驪": "驪",
    "李": "李",
    "里": "⾥",
    "理": "理",
    "裡": "裡",
    "裏": "裏",
    "禮": "禮",
    "醴": "醴",
    "力": "⼒",
    "立": "⽴",
    "吏": "吏",
    "丽": "丽",
    "利": "利",
    "例": "例",
    "隶": "⾪",
    "栗": "栗",
    "笠": "笠",
    "粒": "粒",
    "痢": "痢",
    "慄": "慄",
    "隷": "隸",
    "勵": "勵",
    "歷": "歷",
    "曆": "曆",
    "麗": "麗",
    "礪": "礪",
    "轢": "轢",
    "怜": "怜",
    "連": "連",
    "蓮": "蓮",
    "廉": "廉",
    "漣": "漣",
    "憐": "憐",
    "聯": "聯",
    "簾": "簾",
    "璉": "璉",
    "煉": "煉",
    "練": "練",
    "殮": "殮",
    "鍊": "鍊",
    "戀": "戀",
    "良": "良",
    "凉": "凉",
    "梁": "梁",
    "糧": "糧",
    "冫": "⼎",
    "两": "兩",
    "亮": "亮",
    "量": "量",
    "諒": "諒",
    "僚": "僚",
    "遼": "遼",
    "寮": "寮",
    "燎": "燎",
    "療": "療",
    "蓼": "蓼",
    "料": "料",
    "列": "列",
    "劣": "劣",
    "烈": "烈",
    "裂": "裂",
    "獵": "獵",
    "林": "林",
    "淋": "淋",
    "隣": "隣",
    "璘": "璘",
    "燐": "燐",
    "臨": "臨",
    "鱗": "鱗",
    "麟": "麟",
    "凛": "凜",
    "吝": "吝",
    "藺": "藺",
    "囹": "囹",
    "玲": "玲",
    "凌": "凌",
    "陵": "陵",
    "聆": "聆",
    "菱": "菱",
    "羚": "羚",
    "零": "零",
    "鈴": "鈴",
    "綾": "綾",
    "靈": "靈",
    "領": "領",
    "嶺": "嶺",
    "令": "令",
    "溜": "溜",
    "留": "留",
    "流": "流",
    "琉": "琉",
    "硫": "硫",
    "裗": "裗",
    "劉": "劉",
    "柳": "柳",
    "六": "六",
    "龙": "⻰",
    "竜": "⻯",
    "隆": "隆",
    "龍": "⿓",
    "籠": "籠",
    "聾": "聾",
    "㴳": "㴳",
    "壟": "壟",
    "慺": "慺",
    "樓": "樓",
    "陋": "陋",
    "漏": "漏",
    "盧": "盧",
    "蘆": "蘆",
    "廬": "廬",
    "爐": "爐",
    "卤": "⻧",
    "鹵": "⿄",
    "虜": "虜",
    "魯": "魯",
    "擄": "擄",
    "櫓": "櫓",
    "陸": "陸",
    "菉": "菉",
    "鹿": "⿅",
    "祿": "祿",
    "碌": "碌",
    "賂": "賂",
    "路": "路",
    "䘵": "䘵",
    "戮": "戮",
    "錄": "錄",
    "䩮": "䩮",
    "露": "露",
    "鷺": "鷺",
    "鸞": "鸞",
    "卵": "卵",
    "亂": "亂",
    "掠": "掠",
    "倫": "倫",
    "崙": "崙",
    "淪": "淪",
    "輪": "輪",
    "論": "論",
    "螺": "螺",
    "羅": "羅",
    "蘿": "蘿",
    "邏": "邏",
    "剆": "剆",
    "裸": "裸",
    "洛": "洛",
    "珞": "珞",
    "落": "落",
    "䌴": "䌴",
    "閭": "閭",
    "䕡": "䕡",
    "呂": "呂",
    "旅": "旅",
    "屢": "屢",
    "履": "履",
    "縷": "縷",
    "律": "律",
    "率": "率",
    "綠": "綠",
    "濾": "濾",
    "略": "略",
    "麻": "⿇",
    "䳸": "䳸",
    "马": "⻢",
    "馬": "⾺",
    "麦": "⻨",
    "売": "売",
    "麥": "⿆",
    "㡢": "㡢",
    "莽": "莽",
    "毛": "⽑",
    "矛": "⽭",
    "冒": "冒",
    "㒻": "㒻",
    "帽": "帽",
    "梅": "梅",
    "䍙": "䍙",
    "门": "⻔",
    "門": "⾨",
    "懞": "懞",
    "夢": "夢",
    "米": "⽶",
    "糸": "⽷",
    "泌": "泌",
    "鼏": "鼏",
    "免": "免",
    "黾": "⻪",
    "勉": "勉",
    "冕": "冕",
    "面": "⾯",
    "哶": "哶",
    "民": "⺠",
    "皿": "⽫",
    "敏": "敏",
    "黽": "⿌",
    "摩": "摩",
    "墨": "墨",
    "母": "⺟",
    "木": "⽊",
    "目": "⽬",
    "拏": "拏",
    "肭": "肭",
    "奈": "奈",
    "難": "難",
    "内": "內",
    "泥": "泥",
    "你": "你",
    "匿": "匿",
    "溺": "溺",
    "年": "年",
    "秊": "秊",
    "捻": "捻",
    "輦": "輦",
    "撚": "撚",
    "念": "念",
    "鸟": "⻦",
    "鳥": "⿃",
    "尿": "尿",
    "肀": "⺺",
    "涅": "涅",
    "寜": "寧",
    "寧": "寧",
    "牛": "⽜",
    "杻": "杻",
    "紐": "紐",
    "弄": "弄",
    "怒": "怒",
    "虐": "虐",
    "諾": "諾",
    "女": "⼥",
    "派": "派",
    "爿": "⽙",
    "龎": "龎",
    "噴": "噴",
    "濆": "濆",
    "䦕": "䦕",
    "皮": "⽪",
    "㓟": "㓟",
    "脾": "脾",
    "片": "⽚",
    "拼": "拼",
    "姘": "姘",
    "頻": "頻",
    "聠": "聠",
    "頩": "頩",
    "冖": "⼍",
    "郱": "郱",
    "荓": "荓",
    "洴": "洴",
    "㺸": "㺸",
    "塀": "塀",
    "蓱": "蓱",
    "蛢": "蛢",
    "缾": "缾",
    "䈂": "䈂",
    "竮": "竮",
    "鵧": "鵧",
    "攴": "⽁",
    "暜": "暜",
    "齐": "⻬",
    "斉": "⻫",
    "祈": "祈",
    "齊": "⿑",
    "邔": "邔",
    "芑": "芑",
    "杞": "杞",
    "起": "起",
    "豈": "豈",
    "啓": "啓",
    "气": "⽓",
    "契": "契",
    "器": "器",
    "岍": "岍",
    "汧": "汧",
    "蚈": "蚈",
    "雃": "雃",
    "鳽": "鳽",
    "䗗": "䗗",
    "灊": "灊",
    "凵": "⼐",
    "欠": "⽋",
    "䵖": "䵖",
    "襁": "襁",
    "鏹": "鏹",
    "瞧": "瞧",
    "切": "切",
    "勤": "勤",
    "青": "⻘",
    "靑": "⾭",
    "卿": "卿",
    "晴": "晴",
    "請": "請",
    "瓊": "瓊",
    "全": "全",
    "犬": "⽝",
    "嬈": "嬈",
    "人": "⼈",
    "䚾": "䚾",
    "忍": "忍",
    "刃": "刃",
    "䏕": "䏕",
    "軔": "軔",
    "日": "⽇",
    "荣": "荣",
    "冗": "冗",
    "肉": "⾁",
    "入": "⼊",
    "阮": "阮",
    "甤": "甤",
    "蕤": "蕤",
    "若": "若",
    "塞": "塞",
    "彡": "⼺",
    "氵": "⺡",
    "糣": "糣",
    "桒": "桒",
    "繅": "繅",
    "掃": "掃",
    "㛮": "㛮",
    "色": "⾊",
    "僧": "僧",
    "殺": "殺",
    "閷": "閷",
    "山": "⼭",
    "㣣": "㣣",
    "善": "善",
    "勺": "勺",
    "杓": "杓",
    "奢": "奢",
    "檨": "檨",
    "舌": "⾆",
    "捨": "捨",
    "社": "社",
    "身": "⾝",
    "什": "什",
    "神": "神",
    "沈": "沈",
    "慎": "慎",
    "生": "⽣",
    "省": "省",
    "盛": "盛",
    "尸": "⼫",
    "十": "⼗",
    "饣": "⻠",
    "石": "⽯",
    "䂖": "䂖",
    "拾": "拾",
    "食": "⻝",
    "識": "識",
    "矢": "⽮",
    "豕": "⾗",
    "士": "⼠",
    "氏": "⽒",
    "礻": "⺭",
    "示": "⽰",
    "視": "視",
    "手": "⼿",
    "首": "⾸",
    "寿": "寿",
    "殳": "⽎",
    "疋": "⽦",
    "書": "書",
    "輸": "輸",
    "秫": "秫",
    "暑": "暑",
    "黍": "⿉",
    "署": "署",
    "鼠": "⿏",
    "丨": "⼁",
    "忄": "⺖",
    "庶": "庶",
    "數": "數",
    "㶖": "㶖",
    "水": "⽔",
    "氺": "⺢",
    "帨": "帨",
    "裞": "裞",
    "說": "說",
    "説": "說",
    "厶": "⼛",
    "巳": "⺒",
    "罒": "⺫",
    "飼": "飼",
    "搜": "搜",
    "醙": "醙",
    "叟": "叟",
    "夊": "⼢",
    "歲": "歲",
    "索": "索",
    "獺": "獺",
    "䏙": "䏙",
    "炭": "炭",
    "嘆": "嘆",
    "唐": "唐",
    "糖": "糖",
    "弢": "弢",
    "絛": "絛",
    "啕": "啕",
    "扌": "⺘",
    "田": "⽥",
    "磌": "磌",
    "瑱": "瑱",
    "窱": "窱",
    "冂": "⼌",
    "突": "突",
    "屠": "屠",
    "圖": "圖",
    "圗": "圗",
    "土": "⼟",
    "兔": "兔",
    "堍": "堍",
    "侻": "侻",
    "娧": "娧",
    "駾": "駾",
    "拓": "拓",
    "瓦": "⽡",
    "嗢": "嗢",
    "丸": "丸",
    "挽": "挽",
    "王": "王",
    "网": "⽹",
    "忹": "忹",
    "惘": "惘",
    "望": "望",
    "囗": "⼞",
    "韦": "⻙",
    "韋": "⾱",
    "䧦": "䧦",
    "撝": "撝",
    "㬙": "㬙",
    "䈧": "䈧",
    "殟": "殟",
    "㬈": "㬈",
    "瘟": "瘟",
    "文": "⽂",
    "穏": "穏",
    "无": "⽆",
    "茣": "茣",
    "洖": "洖",
    "侮": "侮",
    "兀": "⺎",
    "夕": "⼣",
    "覀": "⻃",
    "西": "⻄",
    "吸": "吸",
    "犀": "犀",
    "熙": "𤋮",
    "凞": "凞",
    "㩬": "㩬",
    "匸": "⼖",
    "舄": "舄",
    "䊠": "䊠",
    "虩": "虩",
    "咞": "咞",
    "啣": "啣",
    "憲": "憲",
    "香": "⾹",
    "祥": "祥",
    "蠁": "蠁",
    "響": "響",
    "像": "像",
    "小": "⼩",
    "䀘": "䀘",
    "心": "⼼",
    "辛": "⾟",
    "形": "形",
    "㼛": "㼛",
    "侀": "侀",
    "型": "型",
    "硎": "硎",
    "鉶": "鉶",
    "峀": "峀",
    "歔": "歔",
    "玄": "⽞",
    "穴": "⽳",
    "血": "⾎",
    "㤜": "㤜",
    "巡": "巡",
    "巽": "巽",
    "牙": "⽛",
    "芽": "芽",
    "襾": "⾑",
    "咽": "咽",
    "淹": "淹",
    "湮": "湮",
    "讠": "⻈",
    "言": "⾔",
    "沿": "沿",
    "㿼": "㿼",
    "揅": "揅",
    "奄": "奄",
    "掩": "掩",
    "嵃": "嵃",
    "裺": "裺",
    "羊": "⽺",
    "羕": "羕",
    "幺": "⺓",
    "吆": "吆",
    "䌁": "䌁",
    "爻": "⽘",
    "嗂": "嗂",
    "徭": "徭",
    "榣": "榣",
    "㞁": "㞁",
    "页": "⻚",
    "頁": "⾴",
    "葉": "葉",
    "䁆": "䁆",
    "謁": "謁",
    "一": "⼀",
    "衤": "⻂",
    "衣": "⾐",
    "乁": "乁",
    "㰘": "㰘",
    "乙": "⼄",
    "㠯": "㠯",
    "弋": "⼷",
    "邑": "⾢",
    "易": "易",
    "㣇": "㣇",
    "益": "益",
    "異": "異",
    "逸": "逸",
    "廙": "廙",
    "乚": "⺃",
    "音": "⾳",
    "滛": "滛",
    "廴": "⼵",
    "瑩": "瑩",
    "瀛": "瀛",
    "媵": "媵",
    "勇": "勇",
    "用": "⽤",
    "尢": "⺐",
    "尣": "⺏",
    "酉": "⾣",
    "又": "⼜",
    "祐": "祐",
    "梎": "梎",
    "鱼": "⻥",
    "舁": "舁",
    "娛": "娛",
    "魚": "⿂",
    "揄": "揄",
    "瑜": "瑜",
    "羽": "⽻",
    "雨": "⾬",
    "㡼": "㡼",
    "瘐": "瘐",
    "玉": "⽟",
    "芋": "芋",
    "聿": "⾀",
    "育": "育",
    "愈": "愈",
    "諭": "諭",
    "冤": "冤",
    "寃": "寃",
    "蜎": "蜎",
    "䛇": "䛇",
    "曰": "⽈",
    "月": "⽉",
    "玥": "玥",
    "樂": "樂",
    "龠": "⿕",
    "瀹": "瀹",
    "暈": "暈",
    "蝹": "蝹",
    "馧": "馧",
    "霣": "霣",
    "災": "災",
    "甾": "甾",
    "再": "再",
    "鐕": "鐕",
    "偺": "偺",
    "璅": "璅",
    "憎": "憎",
    "贈": "贈",
    "喳": "喳",
    "楂": "楂",
    "牐": "牐",
    "宅": "宅",
    "长": "⻓",
    "杖": "杖",
    "爪": "⽖",
    "爫": "⺤",
    "乛": "⺂",
    "者": "者",
    "着": "着",
    "真": "真",
    "禎": "禎",
    "鬒": "鬒",
    "支": "⽀",
    "芝": "芝",
    "鼅": "鼅",
    "直": "直",
    "埴": "埴",
    "夂": "⼡",
    "止": "⽌",
    "祉": "祉",
    "茝": "茝",
    "黹": "⿋",
    "至": "⾄",
    "志": "志",
    "豸": "⾘",
    "炙": "炙",
    "寘": "寘",
    "櫛": "櫛",
    "塚": "塚",
    "舟": "⾈",
    "周": "周",
    "猪": "猪",
    "蝫": "蝫",
    "諸": "諸",
    "竹": "⽵",
    "陼": "陼",
    "渚": "渚",
    "煮": "煮",
    "祝": "祝",
    "著": "著",
    "築": "築",
    "灷": "灷",
    "篆": "篆",
    "丬": "⺦",
    "壮": "壮",
    "狀": "狀",
    "隹": "⾫",
    "衠": "衠",
    "琢": "琢",
    "鄑": "鄑",
    "椔": "椔",
    "嵫": "嵫",
    "滋": "滋",
    "緇": "緇",
    "子": "⼦",
    "自": "⾃",
    "朡": "朡",
    "縂": "縂",
    "辶": "⻌",
    "走": "⾛",
    "足": "⾜",
    "祖": "祖",
    "最": "最",
    "阝": "⻖",
    "㓁": "⺳",
    "䔫": "䔫",
    "㔾": "⺋",
    "㣺": "⺗",
    "飠": "⻟",
    "亅": "⼅",
    "亠": "⼇",
    "禸": "⽱",
    "〜": "～",
    "卄": "〹",
    "卅": "〺",
    "へ": "ヘ",
    "㖈": "䎛",
    "㘽": "㦳",
    "㬻": "䐠",
    "㩁": "搉",
    "㫚": "曶",
    "㬵": "胶",
    "㬺": "幐",
    "㮣": "槩",
    "䀿": "晣",
    "䃣": "䃣",
    "䑃": "朦",
    "䚶": "訞",
    "值": "値",
    "填": "塡",
    "墫": "壿",
    "媯": "嬀",
    "帡": "帲",
    "既": "既",
    "晚": "晩",
    "朌": "肦",
    "朏": "胐",
    "朐": "胊",
    "朓": "脁",
    "朘": "脧",
    "朣": "膧",
    "杮": "柿",
    "榝": "樧",
    "溈": "潙",
    "眞": "眞",
    "研": "硏",
    "礼": "礼",
    "絕": "絶",
    "胼": "腁",
    "芳": "芳",
    "蒍": "蔿",
    "蘒": "蘒",
    "蘷": "虁",
    "蟡": "蟡",
    "訮": "詽",
    "讆": "讏",
    "豜": "豣",
    "貫": "貫",
    "赿": "趆",
    "跺": "跥",
    "躗": "躛",
    "軿": "輧",
    "鎮": "鎭",
    "𣏕": "𣏕",
    "𥳐": "𥳐",
    "𪄅": "𪄅",
}

for ikey, ival in CONFUSABLES_CHARS.items():
    CONFUSABLES_CHARS[ikey] = ikey + ival
method: WMMethod = WMMethod.FIND_AND_REPLACE
