import * as cdk from '@aws-cdk/core';
/**
 * Datadog Monitors Downtime 3.0.0.
 *
 * @schema CfnDowntimeProps
 */
export interface CfnDowntimeProps {
    /**
     * Whether or not this downtime is currently active.
     *
     * @schema CfnDowntimeProps#Active
     */
    readonly active?: boolean;
    /**
     * POSIX Timestamp of cancellation of this downtime (null if not canceled).
     *
     * @schema CfnDowntimeProps#Canceled
     */
    readonly canceled?: number;
    /**
     * Id of the user who created this downtime.
     *
     * @schema CfnDowntimeProps#CreatorId
     */
    readonly creatorId?: number;
    /**
     * Whether or not this downtime is disabled.
     *
     * @schema CfnDowntimeProps#Disabled
     */
    readonly disabled?: boolean;
    /**
     * Type of this downtime.
     *
     * @schema CfnDowntimeProps#DowntimeType
     */
    readonly downtimeType?: number;
    /**
     * POSIX timestamp to end the downtime.
     *
     * If not provided, the downtime is in effect indefinitely (i.e. until you cancel it).
     *
     * @schema CfnDowntimeProps#End
     */
    readonly end?: number;
    /**
     * Id of this downtime.
     *
     * @schema CfnDowntimeProps#Id
     */
    readonly id?: number;
    /**
     * Message on the downtime.
     *
     * @schema CfnDowntimeProps#Message
     */
    readonly message?: string;
    /**
     * A single monitor to which the downtime applies.
     *
     * If not provided, the downtime applies to all monitors.
     *
     * @schema CfnDowntimeProps#MonitorId
     */
    readonly monitorId?: number;
    /**
     * A comma-separated list of monitor tags, to which the downtime applies.
     *
     * The resulting downtime applies to monitors that match ALL provided monitor tags.
     *
     * @schema CfnDowntimeProps#MonitorTags
     */
    readonly monitorTags?: string[];
    /**
     * The ID of the parent downtime to this one.
     *
     * @schema CfnDowntimeProps#ParentId
     */
    readonly parentId?: number;
    /**
     * The scope(s) to which the downtime applies.
     *
     * @schema CfnDowntimeProps#Scope
     */
    readonly scope: string[];
    /**
     * POSIX timestamp to start the downtime.
     *
     * If not provided, the downtime starts the moment it is created.
     *
     * @schema CfnDowntimeProps#Start
     */
    readonly start?: number;
    /**
     * The timezone for the downtime.
     *
     * @schema CfnDowntimeProps#Timezone
     */
    readonly timezone?: string;
    /**
     * Id of the user who updated this downtime.
     *
     * @schema CfnDowntimeProps#UpdaterId
     */
    readonly updaterId?: number;
}
/**
 * Converts an object of type 'CfnDowntimeProps' to JSON representation.
 */
export declare function toJson_CfnDowntimeProps(obj: CfnDowntimeProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Datadog::Monitors::Downtime`.
 *
 * @external
 * @cloudformationResource Datadog::Monitors::Downtime
 * @link http://unknown-url
 */
export declare class CfnDowntime extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "Datadog::Monitors::Downtime";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnDowntimeProps;
    /**
     * Create a new `Datadog::Monitors::Downtime`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDowntimeProps);
}
