# Generated by Django 4.2.4 on 2023-11-08 06:58
from django.db import migrations, connection
from django.conf import settings


def forwards_func(apps, schema_editor):
    table = "notifications_djangoprojectbasenotification"
    for name, sql in {
        "recipients_original_payload": f"ALTER TABLE {table} ADD COLUMN %s character varying(2048) NOT NULL DEFAULT ''",
        "recipients_original_payload_search": f"ALTER TABLE {table} ADD COLUMN %s text",
    }.items():
        try:
            with connection.cursor() as cursor:
                if "sqlite" in settings.DATABASES["default"]["ENGINE"].split(".")[-1]:
                    cursor.execute(f"SELECT COUNT(*) AS CNTREC FROM pragma_table_info('{table}') WHERE name='{name}';")
                else:
                    cursor.execute(
                        f"select exists (select 1 from information_schema.columns where table_name ='{table}' and column_name='{name}');"
                    )
                row = cursor.fetchone()
                if row and not next(iter(row), None):
                    cursor.execute(sql % name)
        except Exception as e:
            pass


def reverse_func(apps, schema_editor):
    pass


class Migration(migrations.Migration):
    dependencies = [
        ("notifications", "0008_deliveryreport_auxiliary_notification"),
    ]

    operations = [migrations.RunPython(forwards_func, reverse_func)]
