# Generated by Django 4.2.4 on 2023-08-18 14:42

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_project_base.notifications.models
import uuid


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.DJANGO_PROJECT_BASE_PROJECT_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="SearchItems",
            fields=[
                ("content_type_id", models.PositiveIntegerField()),
                ("object_id", models.PositiveBigIntegerField()),
                ("name", models.CharField(max_length=256)),
                (
                    "id",
                    models.PositiveBigIntegerField(primary_key=True, serialize=False),
                ),
            ],
            options={
                "db_table": "search-items-table",
                "abstract": False,
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="DjangoProjectBaseMessage",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        primary_key=True,
                        serialize=False,
                        verbose_name="Id",
                    ),
                ),
                (
                    "subject",
                    models.TextField(blank=True, null=True, verbose_name="Subject"),
                ),
                ("body", models.TextField(verbose_name="Body")),
                (
                    "footer",
                    models.TextField(blank=True, null=True, verbose_name="Footer"),
                ),
                (
                    "content_type",
                    models.CharField(
                        choices=[("text/plain", "Plain text"), ("text/html", "Html")],
                        default="text/plain",
                        max_length=64,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DjangoProjectBaseNotification",
            fields=[
                (
                    "locale",
                    models.CharField(blank=True, max_length=8, null=True, verbose_name="Locale"),
                ),
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        primary_key=True,
                        serialize=False,
                        verbose_name="Id",
                    ),
                ),
                (
                    "level",
                    models.CharField(
                        choices=[
                            ("success", "Success"),
                            ("info", "Info"),
                            ("warning", "Warning"),
                            ("error", "Error"),
                        ],
                        max_length=16,
                        verbose_name="Level",
                    ),
                ),
                (
                    "required_channels",
                    models.CharField(
                        blank=True,
                        max_length=32,
                        null=True,
                        verbose_name="Required channels",
                    ),
                ),
                (
                    "sent_channels",
                    models.CharField(
                        blank=True,
                        max_length=32,
                        null=True,
                        verbose_name="Sent channels",
                    ),
                ),
                (
                    "failed_channels",
                    models.CharField(
                        blank=True,
                        max_length=32,
                        null=True,
                        verbose_name="Failed channels",
                    ),
                ),
                (
                    "created_at",
                    models.BigIntegerField(
                        default=django_project_base.notifications.models.integer_ts,
                        editable=False,
                        verbose_name="Created at",
                    ),
                ),
                (
                    "sent_at",
                    models.BigIntegerField(blank=True, null=True, verbose_name="Sent at"),
                ),
                (
                    "delayed_to",
                    models.BigIntegerField(blank=True, null=True, verbose_name="Delayed to"),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("maintenance", "Maintenance"),
                            ("standard", "Standard"),
                        ],
                        default="standard",
                        max_length=16,
                        verbose_name="Type",
                    ),
                ),
                (
                    "recipients",
                    models.CharField(
                        max_length=2048,
                        null=True,
                        validators=[django.core.validators.int_list_validator],
                    ),
                ),
                ("exceptions", models.TextField(null=True)),
                ("content_entity_context", models.TextField()),
                ("counter", models.SmallIntegerField(default=1)),
                ("recipients_original_payload", models.CharField(max_length=2048)),
                (
                    "recipients_original_payload_search",
                    models.TextField(db_index=True, null=True),
                ),
                (
                    "message",
                    models.OneToOneField(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="notifications.djangoprojectbasemessage",
                        verbose_name="Message",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
