# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from opera.api.openapi.models.base_model_ import Model
from opera.api.openapi.models.invocation_state import InvocationState
from opera.api.openapi.models.operation_type import OperationType
from opera.api.openapi import util

from opera.api.openapi.models.invocation_state import InvocationState  # noqa: E501
from opera.api.openapi.models.operation_type import OperationType  # noqa: E501

class Invocation(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, id=None, state=None, operation=None, timestamp=None, service_template=None, inputs=None, clean_state=None, instance_state=None, exception=None, stdout=None, stderr=None):  # noqa: E501
        """Invocation - a model defined in OpenAPI

        :param id: The id of this Invocation.  # noqa: E501
        :type id: str
        :param state: The state of this Invocation.  # noqa: E501
        :type state: InvocationState
        :param operation: The operation of this Invocation.  # noqa: E501
        :type operation: OperationType
        :param timestamp: The timestamp of this Invocation.  # noqa: E501
        :type timestamp: str
        :param service_template: The service_template of this Invocation.  # noqa: E501
        :type service_template: str
        :param inputs: The inputs of this Invocation.  # noqa: E501
        :type inputs: object
        :param clean_state: The clean_state of this Invocation.  # noqa: E501
        :type clean_state: bool
        :param instance_state: The instance_state of this Invocation.  # noqa: E501
        :type instance_state: Dict[str, str]
        :param exception: The exception of this Invocation.  # noqa: E501
        :type exception: str
        :param stdout: The stdout of this Invocation.  # noqa: E501
        :type stdout: str
        :param stderr: The stderr of this Invocation.  # noqa: E501
        :type stderr: str
        """
        self.openapi_types = {
            'id': str,
            'state': InvocationState,
            'operation': OperationType,
            'timestamp': str,
            'service_template': str,
            'inputs': object,
            'clean_state': bool,
            'instance_state': Dict[str, str],
            'exception': str,
            'stdout': str,
            'stderr': str
        }

        self.attribute_map = {
            'id': 'id',
            'state': 'state',
            'operation': 'operation',
            'timestamp': 'timestamp',
            'service_template': 'service_template',
            'inputs': 'inputs',
            'clean_state': 'clean_state',
            'instance_state': 'instance_state',
            'exception': 'exception',
            'stdout': 'stdout',
            'stderr': 'stderr'
        }

        self._id = id
        self._state = state
        self._operation = operation
        self._timestamp = timestamp
        self._service_template = service_template
        self._inputs = inputs
        self._clean_state = clean_state
        self._instance_state = instance_state
        self._exception = exception
        self._stdout = stdout
        self._stderr = stderr

    @classmethod
    def from_dict(cls, dikt) -> 'Invocation':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Invocation of this Invocation.  # noqa: E501
        :rtype: Invocation
        """
        return util.deserialize_model(dikt, cls)

    @property
    def id(self):
        """Gets the id of this Invocation.


        :return: The id of this Invocation.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Invocation.


        :param id: The id of this Invocation.
        :type id: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def state(self):
        """Gets the state of this Invocation.


        :return: The state of this Invocation.
        :rtype: InvocationState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Invocation.


        :param state: The state of this Invocation.
        :type state: InvocationState
        """
        if state is None:
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501

        self._state = state

    @property
    def operation(self):
        """Gets the operation of this Invocation.


        :return: The operation of this Invocation.
        :rtype: OperationType
        """
        return self._operation

    @operation.setter
    def operation(self, operation):
        """Sets the operation of this Invocation.


        :param operation: The operation of this Invocation.
        :type operation: OperationType
        """
        if operation is None:
            raise ValueError("Invalid value for `operation`, must not be `None`")  # noqa: E501

        self._operation = operation

    @property
    def timestamp(self):
        """Gets the timestamp of this Invocation.

        An ISO8601 timestamp of the invocation.  # noqa: E501

        :return: The timestamp of this Invocation.
        :rtype: str
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this Invocation.

        An ISO8601 timestamp of the invocation.  # noqa: E501

        :param timestamp: The timestamp of this Invocation.
        :type timestamp: str
        """
        if timestamp is None:
            raise ValueError("Invalid value for `timestamp`, must not be `None`")  # noqa: E501

        self._timestamp = timestamp

    @property
    def service_template(self):
        """Gets the service_template of this Invocation.

        The service template used for the invocation.  # noqa: E501

        :return: The service_template of this Invocation.
        :rtype: str
        """
        return self._service_template

    @service_template.setter
    def service_template(self, service_template):
        """Sets the service_template of this Invocation.

        The service template used for the invocation.  # noqa: E501

        :param service_template: The service_template of this Invocation.
        :type service_template: str
        """

        self._service_template = service_template

    @property
    def inputs(self):
        """Gets the inputs of this Invocation.

        Inputs provided for invocation.  # noqa: E501

        :return: The inputs of this Invocation.
        :rtype: object
        """
        return self._inputs

    @inputs.setter
    def inputs(self, inputs):
        """Sets the inputs of this Invocation.

        Inputs provided for invocation.  # noqa: E501

        :param inputs: The inputs of this Invocation.
        :type inputs: object
        """

        self._inputs = inputs

    @property
    def clean_state(self):
        """Gets the clean_state of this Invocation.

        Whether a clean deployment was requested.  # noqa: E501

        :return: The clean_state of this Invocation.
        :rtype: bool
        """
        return self._clean_state

    @clean_state.setter
    def clean_state(self, clean_state):
        """Sets the clean_state of this Invocation.

        Whether a clean deployment was requested.  # noqa: E501

        :param clean_state: The clean_state of this Invocation.
        :type clean_state: bool
        """

        self._clean_state = clean_state

    @property
    def instance_state(self):
        """Gets the instance_state of this Invocation.

        State of the instances defined in service template.  # noqa: E501

        :return: The instance_state of this Invocation.
        :rtype: Dict[str, str]
        """
        return self._instance_state

    @instance_state.setter
    def instance_state(self, instance_state):
        """Sets the instance_state of this Invocation.

        State of the instances defined in service template.  # noqa: E501

        :param instance_state: The instance_state of this Invocation.
        :type instance_state: Dict[str, str]
        """

        self._instance_state = instance_state

    @property
    def exception(self):
        """Gets the exception of this Invocation.

        An internal xOpera error that occurred during the operation.  # noqa: E501

        :return: The exception of this Invocation.
        :rtype: str
        """
        return self._exception

    @exception.setter
    def exception(self, exception):
        """Sets the exception of this Invocation.

        An internal xOpera error that occurred during the operation.  # noqa: E501

        :param exception: The exception of this Invocation.
        :type exception: str
        """

        self._exception = exception

    @property
    def stdout(self):
        """Gets the stdout of this Invocation.

        xOpera console output for operation.  # noqa: E501

        :return: The stdout of this Invocation.
        :rtype: str
        """
        return self._stdout

    @stdout.setter
    def stdout(self, stdout):
        """Sets the stdout of this Invocation.

        xOpera console output for operation.  # noqa: E501

        :param stdout: The stdout of this Invocation.
        :type stdout: str
        """

        self._stdout = stdout

    @property
    def stderr(self):
        """Gets the stderr of this Invocation.

        xOpera error output for operation.  # noqa: E501

        :return: The stderr of this Invocation.
        :rtype: str
        """
        return self._stderr

    @stderr.setter
    def stderr(self, stderr):
        """Sets the stderr of this Invocation.

        xOpera error output for operation.  # noqa: E501

        :param stderr: The stderr of this Invocation.
        :type stderr: str
        """

        self._stderr = stderr
